/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public class AIUtilsPro {
    public static String getDatabaseObjectInfo(@NotNull DBSObject dbsObject, boolean isPromptInfo) {
        Object objectInfo = "";
        String objectFullName = DBUtils.getObjectFullName((DBPNamedObject)dbsObject, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        objectInfo = dbsObject instanceof DataSourceDescriptor ? (isPromptInfo ? "database with following tables" : "listed database tables") : (dbsObject instanceof DBSSchema ? "schema '" + objectFullName + "'" : (dbsObject instanceof DBSEntity ? "table '" + objectFullName + "'" : (dbsObject instanceof DBSEntityAttribute ? "column '" + objectFullName + "' in the table '" + DBUtils.getObjectFullName((DBPNamedObject)dbsObject.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "'" : DBUtils.getObjectTypeName((DBSObject)dbsObject) + " '" + objectFullName + "'")));
        return objectInfo;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static DBSSchema findSchemaInContext(@NotNull AIFunctionContext context, @NotNull String schemaName) throws DBException {
        DBSCatalog searchContainer;
        String actualSchemaName;
        String[] nameParts;
        void dsObjectContainer;
        AIDatabaseContext dbContext = context.getContext();
        if (dbContext == null) {
            throw new DBException("Not connected to database");
        }
        DBCExecutionContext executionContext = dbContext.getExecutionContext();
        DBPDataSource dBPDataSource = executionContext.getDataSource();
        if (!(dBPDataSource instanceof DBSObjectContainer)) throw new DBException("Cannot determine object container in data source " + String.valueOf(executionContext.getDataSource()));
        DBSObjectContainer dBSObjectContainer = (DBSObjectContainer)dBPDataSource;
        SQLDialect dialect = dsObjectContainer.getDataSource().getSQLDialect();
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        DBSCatalog defaultCatalog = null;
        if (contextDefaults != null) {
            defaultCatalog = contextDefaults.getDefaultCatalog();
        }
        if ((nameParts = schemaName.split("\\.")).length == 2) {
            String databaseName = nameParts[0];
            actualSchemaName = nameParts[1];
            DBSObject database = dsObjectContainer.getChild(context.getMonitor(), databaseName);
            if (!(database instanceof DBSObjectContainer)) throw new DBException("Database '" + databaseName + "' not found");
            DBSObjectContainer databaseContainer = (DBSObjectContainer)database;
            searchContainer = databaseContainer;
        } else {
            actualSchemaName = schemaName;
            searchContainer = defaultCatalog != null ? defaultCatalog : dsObjectContainer;
        }
        actualSchemaName = dialect.getUnquotedIdentifier(actualSchemaName);
        DBSObject schema = searchContainer.getChild(context.getMonitor(), actualSchemaName);
        if (schema == null) {
            throw new DBException("Cannot find schema '" + schemaName + "' in current scope");
        }
        if (!(schema instanceof DBSSchema)) throw new DBException("Schema '" + schemaName + "' is not a valid schema object");
        return (DBSSchema)schema;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static DBSDataContainer findTableInContext(@NotNull AIFunctionContext context, @NotNull String tableName) throws DBException {
        DBSSchema searchContainer;
        String actualTableName;
        String[] nameParts;
        void dsObjectContainer;
        AIDatabaseContext dbContext = context.getContext();
        if (dbContext == null) {
            throw new DBException("Not connected to database");
        }
        DBCExecutionContext executionContext = dbContext.getExecutionContext();
        DBPDataSource dBPDataSource = executionContext.getDataSource();
        if (!(dBPDataSource instanceof DBSObjectContainer)) {
            throw new DBException("Cannot determine object container in data source " + String.valueOf(executionContext.getDataSource()));
        }
        DBSObjectContainer dBSObjectContainer = (DBSObjectContainer)dBPDataSource;
        SQLDialect dialect = dsObjectContainer.getDataSource().getSQLDialect();
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        DBSSchema defaultSchema = null;
        DBSCatalog defaultCatalog = null;
        if (contextDefaults != null) {
            defaultSchema = contextDefaults.getDefaultSchema();
            defaultCatalog = contextDefaults.getDefaultCatalog();
        }
        if ((nameParts = tableName.split("\\.")).length > 1) {
            Object schemaName;
            if (nameParts.length == 3) {
                schemaName = nameParts[0] + "." + nameParts[1];
                actualTableName = nameParts[2];
            } else {
                schemaName = nameParts[0];
                actualTableName = nameParts[1];
            }
            searchContainer = AIUtilsPro.findSchemaInContext(context, (String)schemaName);
        } else {
            actualTableName = tableName;
            DBSSchema rootContainer = dsObjectContainer;
            if (dbContext.getScope() == AIDatabaseScope.CURRENT_SCHEMA) {
                rootContainer = defaultSchema;
            } else if (dbContext.getScope() == AIDatabaseScope.CURRENT_DATABASE) {
                rootContainer = defaultCatalog;
            }
            if (rootContainer == null) {
                throw new DBException("Cannot determine container for scope '" + String.valueOf(dbContext.getScope()) + "'");
            }
            searchContainer = rootContainer;
        }
        actualTableName = dialect.getUnquotedIdentifier(actualTableName);
        DBSObject table = searchContainer.getChild(context.getMonitor(), actualTableName);
        if (table == null && nameParts.length == 1 && dbContext.getScope() == AIDatabaseScope.CURRENT_DATABASE && defaultSchema != null) {
            table = defaultSchema.getChild(context.getMonitor(), actualTableName);
        }
        if (table == null) {
            throw new DBException("Cannot find table '" + tableName + "' in current scope");
        }
        if (table instanceof DBSDataContainer) {
            DBSDataContainer entity = (DBSDataContainer)table;
            return entity;
        }
        throw new DBException("Table '" + tableName + "' is not a data container");
    }
}

