/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCRegistry;
import com.dbeaver.data.compare.model.DCUtils;
import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskSettings
implements DBTTaskSettingsInput<DBSDataContainer> {
    private static final Log log = Log.getLog(DCCompareTaskSettings.class);
    private DBSDataContainer leftContainer;
    private DBSDataContainer rightContainer;
    private DBSAttributeBase[] leftKeys;
    private DBSAttributeBase[] rightKeys;
    private final Map<DBSAttributeBase, DBSAttributeBase> mappings = new LinkedHashMap<DBSAttributeBase, DBSAttributeBase>();
    private int comparedRowsLimit = 0;
    private int differentRowsLimit = 10000;
    private int fetchSize = 10000;
    private boolean storeResultsInMemory = true;
    private boolean includeModifiedRows = true;
    private boolean includeDeletedRows = true;
    private boolean includeInsertedRows = true;
    private boolean openNewConnections = false;
    private boolean openViewerOnFinish = true;
    private boolean queryRowsCount = false;
    private DCExporterDescriptor exporterDescriptor = DCRegistry.getInstance().getExporter("sql");
    private String outputFilePath;
    private DCChangeRelation outputRelation = DCChangeRelation.SOURCE;
    private DCChangeOrder outputOrder = DCChangeOrder.DEFAULT;

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> properties, @NotNull DBPProject project) {
        try {
            runnableContext.run(true, true, monitor -> {
                if (!properties.containsKey("project")) {
                    return;
                }
                Map leftProperties = JSONUtils.getObject((Map)properties, (String)"first");
                Map rightProperties = JSONUtils.getObject((Map)properties, (String)"second");
                ContainerInfo leftContainer = this.loadContainer(monitor, project, leftProperties);
                ContainerInfo rightContainer = this.loadContainer(monitor, project, rightProperties);
                if (leftContainer == null || rightContainer == null) {
                    return;
                }
                this.leftContainer = leftContainer.container;
                this.rightContainer = rightContainer.container;
                this.setLeftKeys(this.loadAttributes(leftContainer, leftProperties));
                this.setRightKeys(this.loadAttributes(rightContainer, rightProperties));
                this.setMappings(this.loadMappings(leftContainer, rightContainer, properties));
                this.comparedRowsLimit = CommonUtils.toInt(properties.get("comparedRowsLimit"), (int)0);
                this.differentRowsLimit = CommonUtils.toInt(properties.get("differentRowsLimit"), (int)10000);
                this.fetchSize = CommonUtils.toInt(properties.get("fetchSize"), (int)10000);
                this.storeResultsInMemory = CommonUtils.getBoolean(properties.get("storeResultsInMemory"), (boolean)true);
                this.includeModifiedRows = CommonUtils.getBoolean(properties.get("includeModifiedRows"), (boolean)true);
                this.includeDeletedRows = CommonUtils.getBoolean(properties.get("includeDeletedRows"), (boolean)true);
                this.includeInsertedRows = CommonUtils.getBoolean(properties.get("includeInsertedRows"), (boolean)true);
                this.openNewConnections = CommonUtils.getBoolean(properties.get("openNewConnections"), (boolean)false);
                this.openViewerOnFinish = CommonUtils.getBoolean(properties.get("openViewerOnFinish"), (boolean)true);
                this.queryRowsCount = CommonUtils.getBoolean(properties.get("queryRowsCount"), (boolean)false);
                this.outputFilePath = CommonUtils.toString(properties.get("outputFilePath"), null);
                this.outputRelation = (DCChangeRelation)CommonUtils.valueOf(DCChangeRelation.class, (String)CommonUtils.toString(properties.get("outputRelation")), (Enum)DCChangeRelation.SOURCE);
                this.outputOrder = (DCChangeOrder)CommonUtils.valueOf(DCChangeOrder.class, (String)CommonUtils.toString(properties.get("outputOrder")), (Enum)DCChangeOrder.DEFAULT);
                this.exporterDescriptor = DCRegistry.getInstance().getExporter(CommonUtils.toString(properties.get("outputFileFormat"), (String)"sql"));
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
    }

    @Nullable
    private ContainerInfo loadContainer(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull Map<String, Object> properties) {
        try {
            List attributes;
            DBSDataContainer container;
            DBSObject object = DCCompareTaskSettings.loadObject(monitor, project, CommonUtils.toString((Object)properties.get("objectId")));
            if (object == null) {
                return null;
            }
            String query = CommonUtils.toString((Object)properties.get("query"));
            if (CommonUtils.isNotEmpty((String)query)) {
                try {
                    container = DCUtils.createDataContainerFromQuery(monitor, (DBPDataSourceContainer)object, query);
                }
                catch (DBException e) {
                    log.error((Object)"Can't create data container from query", (Throwable)e);
                    monitor.done();
                    return null;
                }
            } else {
                container = (DBSDataContainer)object;
            }
            try {
                attributes = DTUtils.getAttributes((DBRProgressMonitor)monitor, (DBSDataContainer)container, (Object)container);
            }
            catch (DBException e) {
                log.error((Object)("Can't load attributes for object '" + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'"), (Throwable)e);
                monitor.done();
                return null;
            }
            HashMap<String, DBSAttributeBase> attributeMap = new HashMap<String, DBSAttributeBase>();
            for (DBSAttributeBase attribute : attributes) {
                attributeMap.put(attribute.getName(), attribute);
            }
            ContainerInfo containerInfo = new ContainerInfo(container, attributeMap);
            return containerInfo;
        }
        finally {
            monitor.done();
        }
    }

    @Nullable
    private static DBSObject loadObject(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String id) {
        DBSObject object;
        try {
            monitor.beginTask("Load object '" + id + "'", 1);
            object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)id);
            monitor.worked(1);
        }
        catch (DBException e) {
            log.error((Object)("Can't find object '" + id + "' in project '" + project.getName() + "'"), (Throwable)e);
            return null;
        }
        if (object == null) {
            log.error((Object)("Can't find object '" + id + "' in project '" + project.getName() + "'"));
            return null;
        }
        return object;
    }

    @Nullable
    private DBSAttributeBase[] loadAttributes(@NotNull ContainerInfo container, @NotNull Map<String, Object> properties) {
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        for (String column : JSONUtils.getStringList(properties, (String)"attributes")) {
            DBSAttributeBase attribute = this.loadAttribute(container, column, "key");
            if (attribute == null) {
                return null;
            }
            attributes.add(attribute);
        }
        return attributes.toArray(new DBSAttributeBase[0]);
    }

    @NotNull
    private Map<DBSAttributeBase, DBSAttributeBase> loadMappings(@NotNull ContainerInfo sourceContainer, @NotNull ContainerInfo targetContainer, @NotNull Map<String, Object> properties) {
        HashMap<DBSAttributeBase, DBSAttributeBase> mappings = new HashMap<DBSAttributeBase, DBSAttributeBase>();
        for (Map mapping : JSONUtils.getObjectList(properties, (String)"mappings")) {
            String source = CommonUtils.toString(mapping.get("source"));
            String target = CommonUtils.toString(mapping.get("target"));
            DBSAttributeBase sourceAttribute = this.loadAttribute(sourceContainer, source, "source");
            DBSAttributeBase targetAttribute = this.loadAttribute(targetContainer, target, "target");
            if (sourceAttribute == null || targetAttribute == null) continue;
            mappings.put(sourceAttribute, targetAttribute);
        }
        return mappings;
    }

    @Nullable
    private DBSAttributeBase loadAttribute(@NotNull ContainerInfo container, @NotNull String name, @NotNull String which) {
        DBSAttributeBase attribute = container.attributes.get(name);
        if (attribute == null) {
            log.error((Object)("Can't find " + which + " attribute '" + name + "'"));
            return null;
        }
        return attribute;
    }

    @NotNull
    public Map<String, Object> saveDataContainer(@NotNull DBSDataContainer container, @NotNull DBSAttributeBase[] keys) {
        SQLQueryContainer qc;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("attributes", Arrays.stream(keys).map(DBPNamedObject::getName).collect(Collectors.toList()));
        if (container instanceof SQLQueryContainer && (qc = (SQLQueryContainer)container).getDataSourceContainer() != null) {
            properties.put("objectId", DBUtils.getObjectFullId((DBSObject)qc.getDataSourceContainer()));
            properties.put("query", qc.getQuery().getText());
        } else {
            properties.put("objectId", DBUtils.getObjectFullId((DBSObject)container));
        }
        return properties;
    }

    public void saveConfiguration(@NotNull Map<String, Object> state) {
        state.put("project", this.leftContainer.getDataSource().getContainer().getProject().getName());
        state.put("first", this.saveDataContainer(this.leftContainer, this.leftKeys));
        state.put("second", this.saveDataContainer(this.rightContainer, this.rightKeys));
        ArrayList mappingsProperties = new ArrayList();
        for (Map.Entry<DBSAttributeBase, DBSAttributeBase> entry : this.mappings.entrySet()) {
            LinkedHashMap<String, String> mappingProperties = new LinkedHashMap<String, String>();
            mappingProperties.put("source", entry.getKey().getName());
            mappingProperties.put("target", entry.getValue().getName());
            mappingsProperties.add(mappingProperties);
        }
        state.put("mappings", mappingsProperties);
        state.put("comparedRowsLimit", this.comparedRowsLimit);
        state.put("differentRowsLimit", this.differentRowsLimit);
        state.put("fetchSize", this.fetchSize);
        state.put("storeResultsInMemory", this.storeResultsInMemory);
        state.put("includeModifiedRows", this.includeModifiedRows);
        state.put("includeDeletedRows", this.includeDeletedRows);
        state.put("includeInsertedRows", this.includeInsertedRows);
        state.put("openNewConnections", this.openNewConnections);
        state.put("openViewerOnFinish", this.openViewerOnFinish);
        state.put("queryRowsCount", this.queryRowsCount);
        if (!CommonUtils.isEmptyTrimmed((String)this.outputFilePath)) {
            state.put("outputFilePath", this.outputFilePath);
            state.put("outputFileFormat", this.exporterDescriptor.getId());
            state.put("outputRelation", this.outputRelation.name());
            state.put("outputOrder", this.outputOrder.name());
        }
    }

    public void loadSettingsFromInput(List<DBSDataContainer> objects) {
        switch (objects.size()) {
            case 1: {
                this.leftContainer = objects.get(0);
                this.rightContainer = objects.get(0);
                break;
            }
            case 2: {
                this.leftContainer = objects.get(0);
                this.rightContainer = objects.get(1);
                break;
            }
            default: {
                this.leftContainer = null;
                this.rightContainer = null;
                log.warn((Object)("Too many containers: " + objects.size()));
            }
        }
    }

    public DBSDataContainer getLeftContainer() {
        return this.leftContainer;
    }

    public void setLeftContainer(DBSDataContainer leftContainer) {
        this.leftContainer = leftContainer;
    }

    public DBSDataContainer getRightContainer() {
        return this.rightContainer;
    }

    public void setRightContainer(DBSDataContainer rightContainer) {
        this.rightContainer = rightContainer;
    }

    public DBSAttributeBase[] getLeftKeys() {
        return this.leftKeys;
    }

    public void setLeftKeys(DBSAttributeBase[] leftKeys) {
        this.leftKeys = leftKeys;
    }

    public DBSAttributeBase[] getRightKeys() {
        return this.rightKeys;
    }

    public void setRightKeys(DBSAttributeBase[] rightKeys) {
        this.rightKeys = rightKeys;
    }

    @NotNull
    public Map<DBSAttributeBase, DBSAttributeBase> getMappings() {
        return this.mappings;
    }

    public void setMappings(@NotNull Map<DBSAttributeBase, DBSAttributeBase> mappings) {
        this.mappings.clear();
        this.mappings.putAll(mappings);
    }

    public int getComparedRowsLimit() {
        return this.comparedRowsLimit;
    }

    public void setComparedRowsLimit(int comparedRowsLimit) {
        this.comparedRowsLimit = comparedRowsLimit;
    }

    public int getDifferentRowsLimit() {
        return this.differentRowsLimit;
    }

    public void setDifferentRowsLimit(int differentRowsLimit) {
        this.differentRowsLimit = differentRowsLimit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isStoreResultsInMemory() {
        return this.storeResultsInMemory;
    }

    public void setStoreResultsInMemory(boolean storeResultsInMemory) {
        this.storeResultsInMemory = storeResultsInMemory;
    }

    public boolean isIncludeModifiedRows() {
        return this.includeModifiedRows;
    }

    public void setIncludeModifiedRows(boolean includeModifiedRows) {
        this.includeModifiedRows = includeModifiedRows;
    }

    public boolean isIncludeDeletedRows() {
        return this.includeDeletedRows;
    }

    public void setIncludeDeletedRows(boolean includeDeletedRows) {
        this.includeDeletedRows = includeDeletedRows;
    }

    public boolean isIncludeInsertedRows() {
        return this.includeInsertedRows;
    }

    public void setIncludeInsertedRows(boolean includeInsertedRows) {
        this.includeInsertedRows = includeInsertedRows;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isOpenViewerOnFinish() {
        return this.openViewerOnFinish;
    }

    public void setOpenViewerOnFinish(boolean openViewerOnFinish) {
        this.openViewerOnFinish = openViewerOnFinish;
    }

    public boolean isQueryRowsCount() {
        return this.queryRowsCount;
    }

    public void setQueryRowsCount(boolean queryRowsCount) {
        this.queryRowsCount = queryRowsCount;
    }

    @Nullable
    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(@Nullable String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    @NotNull
    public DCExporterDescriptor getExporterDescriptor() {
        return this.exporterDescriptor;
    }

    public void setExporterDescriptor(@NotNull DCExporterDescriptor exporterDescriptor) {
        this.exporterDescriptor = exporterDescriptor;
    }

    @NotNull
    public DCChangeRelation getOutputRelation() {
        return this.outputRelation;
    }

    public void setOutputRelation(@NotNull DCChangeRelation outputRelation) {
        this.outputRelation = outputRelation;
    }

    @NotNull
    public DCChangeOrder getOutputOrder() {
        return this.outputOrder;
    }

    public void setOutputOrder(@NotNull DCChangeOrder outputOrder) {
        this.outputOrder = outputOrder;
    }

    private record ContainerInfo(@NotNull DBSDataContainer container, @NotNull Map<String, DBSAttributeBase> attributes) {
    }
}

