/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;

public class DCRegistry {
    public static final String EXTENSION_ID = "com.dbeaver.data.compare";
    public static final String DEFAULT_EXPORTER = "sql";
    private static DCRegistry instance;
    private final Map<String, DCExporterDescriptor> exporters = new LinkedHashMap<String, DCExporterDescriptor>();

    private DCRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if ("exporter".equals(extension.getName())) {
                DCExporterDescriptor descriptor = new DCExporterDescriptor(extension);
                this.exporters.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public static synchronized DCRegistry getInstance() {
        if (instance == null) {
            instance = new DCRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public Collection<DCExporterDescriptor> getExporters() {
        return this.exporters.values();
    }

    @NotNull
    public DCExporterDescriptor getExporter(@NotNull String id) {
        return this.exporters.get(id);
    }
}

