/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTransaction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.PeriodicJob;

public class QMDBCleanupJob
extends PeriodicJob {
    private static final Log log = Log.getLog(QMDBCleanupJob.class);
    @NotNull
    private final QMDBModel qmdbModel;

    public QMDBCleanupJob(@NotNull DBPPlatform platform, @NotNull QMDBModel qmdbModel) {
        super("QMDB data cleanup", platform, Duration.ofDays(1L));
        this.qmdbModel = qmdbModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doJob(@NotNull DBRProgressMonitor monitor) {
        if (!this.qmdbModel.isInitialized()) {
            return;
        }
        if (!this.platform.getPreferenceStore().getBoolean("qmdb.autoCleanup")) {
            log.trace((Object)"QM database cleanup is not enabled, skipping cleanup");
            return;
        }
        int daysToStore = this.platform.getPreferenceStore().getInt("qmdb.maxStoreHistoryDays");
        if (daysToStore <= 0) {
            log.debug((Object)("Invalid days to store history value: " + daysToStore + ", value must be greater than 0, skipping cleanup"));
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Connection dbCon = this.qmdbModel.getDatabaseConnection();
                try {
                    try (JDBCTransaction txn = new JDBCTransaction(dbCon);){
                        Object dbStat52;
                        Object dbStat42;
                        Object dbStat32;
                        Object dbStat22;
                        Timestamp maxDataTime = Timestamp.valueOf(LocalDateTime.now().minusDays(daysToStore));
                        monitor.subTask("Delete statements");
                        String deleteStatementQuery = "DELETE FROM {table_prefix}QM_STATEMENT WHERE STATEMENT_ID IN (SELECT EVENT_ID FROM {table_prefix}QM_EVENT e WHERE e.EVENT_TIME < ?)";
                        Throwable throwable2 = null;
                        Throwable throwable3 = null;
                        try {
                            dbStat22 = dbCon.prepareStatement(deleteStatementQuery);
                            try {
                                dbStat22.setTimestamp(1, maxDataTime);
                                dbStat22.execute();
                            }
                            finally {
                                if (dbStat22 != null) {
                                    dbStat22.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        monitor.subTask("Delete events");
                        String deleteEventsQuery = "DELETE FROM {table_prefix}QM_EVENT WHERE EVENT_TIME < ?";
                        throwable3 = null;
                        dbStat22 = null;
                        try {
                            dbStat32 = dbCon.prepareStatement(deleteEventsQuery);
                            try {
                                dbStat32.setTimestamp(1, maxDataTime);
                                dbStat32.execute();
                            }
                            finally {
                                if (dbStat32 != null) {
                                    dbStat32.close();
                                }
                            }
                        }
                        catch (Throwable dbStat22) {
                            if (throwable3 == null) {
                                throwable3 = dbStat22;
                                throw throwable3;
                            } else {
                                if (throwable3 == dbStat22) throw throwable3;
                                throwable3.addSuppressed(dbStat22);
                            }
                            throw throwable3;
                        }
                        monitor.subTask("Delete unused query filters");
                        String deleteQueryFiltersQuery = "DELETE FROM {table_prefix}QM_QUERY_FILTER WHERE QUERY_ID NOT IN (SELECT QUERY_ID FROM {table_prefix}QM_STATEMENT)";
                        dbStat22 = null;
                        dbStat32 = null;
                        try {
                            dbStat42 = dbCon.prepareStatement(deleteQueryFiltersQuery);
                            try {
                                dbStat42.execute();
                            }
                            finally {
                                if (dbStat42 != null) {
                                    dbStat42.close();
                                }
                            }
                        }
                        catch (Throwable dbStat32) {
                            if (dbStat22 == null) {
                                dbStat22 = dbStat32;
                                throw dbStat22;
                            } else {
                                if (dbStat22 == dbStat32) throw dbStat22;
                                ((Throwable)dbStat22).addSuppressed(dbStat32);
                            }
                            throw dbStat22;
                        }
                        monitor.subTask("Delete unused queries");
                        String deleteQueriesQuery = "DELETE FROM {table_prefix}QM_QUERY WHERE QUERY_ID NOT IN (SELECT QUERY_ID FROM {table_prefix}QM_STATEMENT)";
                        dbStat32 = null;
                        dbStat42 = null;
                        try {
                            dbStat52 = dbCon.prepareStatement(deleteQueriesQuery);
                            try {
                                dbStat52.execute();
                            }
                            finally {
                                if (dbStat52 != null) {
                                    dbStat52.close();
                                }
                            }
                        }
                        catch (Throwable dbStat42) {
                            if (dbStat32 == null) {
                                dbStat32 = dbStat42;
                                throw dbStat32;
                            } else {
                                if (dbStat32 == dbStat42) throw dbStat32;
                                ((Throwable)dbStat32).addSuppressed(dbStat42);
                            }
                            throw dbStat32;
                        }
                        monitor.subTask("Delete dead AI conversation messages");
                        String deleteDeadAIConversationMessagesQuery = "DELETE FROM {table_prefix}QM_AI_CONVERSATION_MESSAGE WHERE CONVERSATION_ID IN\n(SELECT CONVERSATION_ID FROM {table_prefix}QM_AI_CONVERSATION WHERE IS_DELETED = ?)\n";
                        dbStat42 = null;
                        dbStat52 = null;
                        try (PreparedStatement dbStat = dbCon.prepareStatement(deleteDeadAIConversationMessagesQuery);){
                            dbStat.setString(1, "Y");
                            dbStat.execute();
                        }
                        catch (Throwable dbStat52) {
                            if (dbStat42 == null) {
                                dbStat42 = dbStat52;
                                throw dbStat42;
                            } else {
                                if (dbStat42 == dbStat52) throw dbStat42;
                                ((Throwable)dbStat42).addSuppressed(dbStat52);
                            }
                            throw dbStat42;
                        }
                        monitor.subTask("Delete dead AI conversation context history");
                        String deleteDeadAIConversationContextHistoryQuery = "DELETE FROM {table_prefix}QM_AI_CONTEXT_HISTORY WHERE CONVERSATION_ID IN\n(SELECT CONVERSATION_ID FROM {table_prefix}QM_AI_CONVERSATION WHERE IS_DELETED = ?)\n";
                        dbStat52 = null;
                        Throwable throwable5 = null;
                        try (PreparedStatement dbStat = dbCon.prepareStatement(deleteDeadAIConversationContextHistoryQuery);){
                            dbStat.setString(1, "Y");
                            dbStat.execute();
                        }
                        catch (Throwable throwable6) {
                            if (dbStat52 == null) {
                                dbStat52 = throwable6;
                                throw dbStat52;
                            } else {
                                if (dbStat52 == throwable6) throw dbStat52;
                                ((Throwable)dbStat52).addSuppressed(throwable6);
                            }
                            throw dbStat52;
                        }
                        monitor.subTask("Delete dead AI conversations");
                        String deleteDeadAIConversationsQuery = "DELETE FROM {table_prefix}QM_AI_CONVERSATION\n       WHERE IS_DELETED = ? AND LAST_MESSAGE_AT < ?\n";
                        throwable5 = null;
                        Object var16_33 = null;
                        try (PreparedStatement dbStat = dbCon.prepareStatement(deleteDeadAIConversationsQuery);){
                            dbStat.setString(1, "Y");
                            dbStat.setTimestamp(2, maxDataTime);
                            dbStat.execute();
                        }
                        catch (Throwable throwable7) {
                            if (throwable5 == null) {
                                throwable5 = throwable7;
                                throw throwable5;
                            } else {
                                if (throwable5 == throwable7) throw throwable5;
                                throwable5.addSuppressed(throwable7);
                            }
                            throw throwable5;
                        }
                        txn.commit();
                    }
                    if (dbCon == null) return;
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    if (dbCon == null) throw throwable;
                    dbCon.close();
                    throw throwable;
                }
                dbCon.close();
                return;
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                    throw throwable;
                } else {
                    if (throwable == throwable9) throw throwable;
                    throwable.addSuppressed(throwable9);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error cleaning up QM database", (Throwable)e);
        }
    }
}

