/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCParameterMetaData;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBExtendedData;
import com.ibm.as400.access.DBExtendedDataFormat;
import com.ibm.as400.access.DBOriginalData;
import com.ibm.as400.access.DBOriginalDataFormat;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLDescriptorDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.DBVariableData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLArray;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.SQLLocator;
import com.ibm.as400.access.SQLVariableCompressible;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class AS400JDBCPreparedStatementImpl
extends AS400JDBCPreparedStatement {
    static final String copyright2 = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int descriptorHandle_;
    boolean executed_;
    private boolean outputParametersExpected_;
    int parameterCount_;
    int parameterInputCount_;
    boolean batchExecute_;
    private boolean executingBatchedStatement_ = false;
    private int[] parameterLengths_;
    private int[] parameterOffsets_;
    private boolean[] parameterNulls_;
    private boolean[] parameterDefaults_;
    private boolean[] parameterUnassigned_;
    private String[] parameterNames_;
    Vector batchParameterRows_;
    private int parameterTotalSize_;
    private int indicatorTotalSize_;
    private int headerTotalSize_;
    boolean[] parameterSet_;
    private boolean prepared_;
    private JDServerRow resultRow_;
    SQLInteger returnValueParameter_;
    JDSQLStatement sqlStatement_;
    boolean useReturnValueParameter_;
    private int maxToLog_ = 10000;
    private boolean containsArrayParameter_ = false;
    private boolean preserveParameters_ = false;
    private boolean saveParameterValues_ = false;
    private int containsLocator_ = -1;
    private static final int LOCATOR_UNKNOWN = -1;
    private static final int LOCATOR_NOT_FOUND = 0;
    private static final int LOCATOR_FOUND = 1;
    private static final short INDICATOR_NULL = -1;
    private static final short INDICATOR_DEFAULT = -5;
    private static final short INDICATOR_UNASSIGNED = -7;
    private boolean isjvm16Synchronizer;
    private static boolean isjvm16SynchronizerStatic;
    OutputStream dummyOutputStream = new OutputStream(){
        int b1 = 0;

        @Override
        public synchronized void write(int b) throws IOException {
            this.b1 = b;
        }
    };

    AS400JDBCPreparedStatementImpl(AS400JDBCConnection connection, int id, JDTransactionManager transactionManager, JDPackageManager packageManager, String blockCriteria, int blockSize, boolean prefetch, JDSQLStatement sqlStatement, boolean outputParametersExpected, String packageCriteria, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        super(connection, id, transactionManager, packageManager, blockCriteria, blockSize, prefetch, packageCriteria, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys);
        this.isjvm16Synchronizer = isjvm16SynchronizerStatic;
        if (this.connection_.getProperties().getBoolean(80)) {
            this.isjvm16Synchronizer = true;
        }
        this.batchExecute_ = false;
        this.outputParametersExpected_ = outputParametersExpected;
        this.parameterCount_ = sqlStatement.countParameters();
        this.parameterInputCount_ = 0;
        this.parameterLengths_ = new int[this.parameterCount_];
        this.parameterNulls_ = new boolean[this.parameterCount_];
        this.parameterDefaults_ = new boolean[this.parameterCount_];
        this.parameterUnassigned_ = new boolean[this.parameterCount_];
        this.parameterOffsets_ = new int[this.parameterCount_];
        this.parameterSet_ = new boolean[this.parameterCount_];
        this.sqlStatement_ = sqlStatement;
        this.useReturnValueParameter_ = sqlStatement.hasReturnValueParameter();
        if (this.useReturnValueParameter_) {
            this.returnValueParameter_ = new SQLInteger(this.connection_.getVRM(), this.settings_);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isjvm16Synchronizer=" + this.isjvm16Synchronizer);
            JDTrace.logInformation(this, "Preparing [" + this.sqlStatement_ + "]");
            if (this.useReturnValueParameter_) {
                JDTrace.logInformation(this, "Suppressing return value parameter (?=CALL)");
            }
        }
        this.allowImmediate_ = false;
        this.prepared_ = true;
        try {
            this.resultRow_ = this.commonPrepare(this.sqlStatement_);
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.executed_ = false;
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            Object[] parameters = new Object[this.parameterCount_];
            for (int i = 0; i < this.parameterCount_; ++i) {
                int sqlType;
                if (this.parameterRow_.isOutput(i + 1)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.parameterSet_[i]) {
                    JDError.throwSQLException((Object)this, "07001");
                }
                SQLData sqlData = this.parameterRow_.getSQLData(i + 1);
                if (!this.parameterNulls_[i]) {
                    parameters[i] = this.parameterDefaults_[i] ? Byte.valueOf("1") : (this.parameterUnassigned_[i] ? Byte.valueOf("2") : sqlData.getBatchableObject());
                }
                if (this.containsLocator_ != -1 || (sqlType = sqlData.getSQLType()) != 8 && sqlType != 4 && sqlType != 12 && sqlType != 34 && sqlType != 40) continue;
                this.containsLocator_ = 1;
            }
            if (this.containsLocator_ == -1) {
                this.containsLocator_ = 0;
            }
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "addBatch()");
            }
            this.batch_.addElement(parameters);
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDescriptor() throws SQLException {
        DBBaseRequestDS request2 = null;
        try {
            this.descriptorHandle_ = this.id_;
            request2 = DBDSPool.getDBSQLDescriptorDS(7680, this.id_, 0, this.descriptorHandle_);
            DBDataFormat parameterMarkerDataFormat = this.connection_.useExtendedFormats() ? new DBExtendedDataFormat(this.parameterCount_) : new DBOriginalDataFormat(this.parameterCount_);
            ((DBSQLDescriptorDS)request2).setParameterMarkerDataFormat(parameterMarkerDataFormat);
            parameterMarkerDataFormat.setConsistencyToken(1);
            parameterMarkerDataFormat.setRecordSize(this.parameterTotalSize_);
            if (this.isjvm16Synchronizer) {
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor:  totalParameterLength_ = " + this.parameterTotalSize_).getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.parameterCount_; ++i) {
                SQLData sqlData = this.parameterRow_.getSQLData(i + 1);
                parameterMarkerDataFormat.setFieldDescriptionLength(i);
                if (sqlData.getNativeType() == 10000) {
                    int arrayLen = ((SQLArray)sqlData).getArrayCount();
                    if (arrayLen > 0) {
                        parameterMarkerDataFormat.setFieldLength(i, this.parameterLengths_[i] / arrayLen);
                    } else {
                        parameterMarkerDataFormat.setFieldLength(i, this.parameterLengths_[i]);
                    }
                } else {
                    parameterMarkerDataFormat.setFieldLength(i, this.parameterLengths_[i]);
                }
                parameterMarkerDataFormat.setFieldCCSID(i, this.parameterRow_.getCCSID(i + 1));
                parameterMarkerDataFormat.setFieldNameLength(i, 0);
                parameterMarkerDataFormat.setFieldNameCCSID(i, 0);
                parameterMarkerDataFormat.setFieldName(i, "", this.connection_.getConverter());
                if (sqlData.getNativeType() == 10000) {
                    parameterMarkerDataFormat.setFieldSQLType(i, (short)(((SQLArray)sqlData).getElementNativeType() | 1));
                } else {
                    parameterMarkerDataFormat.setFieldSQLType(i, (short)(sqlData.getNativeType() | 1));
                }
                parameterMarkerDataFormat.setFieldScale(i, (short)sqlData.getScale());
                parameterMarkerDataFormat.setFieldPrecision(i, (short)sqlData.getPrecision());
                if (!this.isjvm16Synchronizer) continue;
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor:  Parameter " + (i + 1) + " length = " + this.parameterLengths_[i]).getBytes());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connection_.send(request2, this.descriptorHandle_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Descriptor " + this.descriptorHandle_ + " created or changed");
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        finally {
            if (this.isjvm16Synchronizer && request2 != null) {
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor.inUser_(false): request2-id=" + request2.hashCode()).getBytes());
                }
                catch (Exception exception) {}
            }
            if (request2 != null) {
                request2.returnToPool();
                request2 = null;
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            for (int i = 0; i < this.parameterCount_; ++i) {
                this.parameterNulls_[i] = false;
                this.parameterDefaults_[i] = false;
                this.parameterUnassigned_[i] = false;
                this.parameterSet_[i] = false;
            }
            if (this.useReturnValueParameter_) {
                this.returnValueParameter_.set(0);
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.internalLock.lock();
            if (this.isClosed()) {
                return;
            }
            if (this.descriptorHandle_ != 0) {
                DBSQLDescriptorDS request = null;
                try {
                    request = DBDSPool.getDBSQLDescriptorDS(7681, this.id_, 0, this.descriptorHandle_);
                    this.connection_.send(request, this.descriptorHandle_);
                }
                finally {
                    if (this.isjvm16Synchronizer) {
                        try {
                            if (request != null) {
                                this.dummyOutputStream.write(("!!!close.inUser_(false): request-id=" + request.hashCode()).getBytes());
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                }
                this.descriptorHandle_ = 0;
            }
            super.close();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    void commonExecuteAfter(JDSQLStatement sqlStatement, DBReplyRequestedDS reply) throws SQLException {
        super.commonExecuteAfter(sqlStatement, reply);
        if (this.prepared_) {
            DBData resultData = null;
            if (this.outputParametersExpected_) {
                resultData = reply.getResultData();
            }
            if (this.outputParametersExpected_ && resultData != null) {
                this.parameterRow_.setServerData(resultData);
                this.parameterRow_.setRowIndex(0);
            }
            try {
                if (this.useReturnValueParameter_) {
                    this.returnValueParameter_.set(reply.getSQLCA().getErrd(1));
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
            }
        }
    }

    @Override
    void commonExecuteBefore(JDSQLStatement sqlStatement, DBSQLRequestDS request) throws SQLException {
        super.commonExecuteBefore(sqlStatement, request);
        int requestLengthOffset = 0;
        int initialRawOffset = 0;
        int variableDataLength = 0;
        this.disableRllCompression_ = false;
        if (this.prepared_) {
            int i;
            this.closeResultSet(241);
            boolean outputExpected_ = false;
            this.parameterInputCount_ = 0;
            for (i = 0; i < this.parameterCount_; ++i) {
                if (!this.executingBatchedStatement_ && !this.parameterSet_[i] && this.parameterRow_.isInput(i + 1)) {
                    JDError.throwSQLException((Object)this, "07001");
                }
                if (this.parameterRow_.isOutput(i + 1)) {
                    outputExpected_ = true;
                }
                if (!this.parameterRow_.isInput(i + 1)) continue;
                ++this.parameterInputCount_;
            }
            if (!outputExpected_) {
                this.outputParametersExpected_ = false;
            }
            if (this.parameterCount_ > 0 && this.descriptorHandle_ == 0 || this.parameterCount_ > 0 && this.containsArrayParameter_) {
                this.parameterRow_.setRowIndex(-1);
                this.parameterTotalSize_ = 0;
                this.indicatorTotalSize_ = 0;
                this.headerTotalSize_ = 2;
                for (i = 0; i < this.parameterCount_; ++i) {
                    if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(i + 1)) {
                        SQLData sqlData = this.parameterRow_.getSQLData(i + 1);
                        if (sqlData.getType() == 2003) {
                            this.containsArrayParameter_ = true;
                            int arrayLen = ((SQLArray)sqlData).getArrayCount();
                            int elementSize = this.parameterRow_.getArrayDataLength(i + 1);
                            this.headerTotalSize_ = this.parameterNulls_[i] || this.parameterDefaults_[i] || this.parameterUnassigned_[i] ? (this.headerTotalSize_ += 4) : (this.headerTotalSize_ += 12);
                            this.parameterLengths_[i] = elementSize * arrayLen;
                            this.indicatorTotalSize_ += arrayLen * 2;
                        } else {
                            this.headerTotalSize_ += 8;
                            this.parameterLengths_[i] = this.parameterRow_.getLength(i + 1);
                            this.indicatorTotalSize_ += 2;
                        }
                        this.parameterOffsets_[i] = this.parameterTotalSize_;
                        this.parameterTotalSize_ += this.parameterLengths_[i];
                    }
                    if (!this.isjvm16Synchronizer) continue;
                    try {
                        this.dummyOutputStream.write(("!!!commonExecuteBefore:  Parameter " + (i + 1) + " length = " + this.parameterLengths_[i]).getBytes());
                        continue;
                    }
                    catch (Exception sqlData) {
                        // empty catch block
                    }
                }
                if (this.isjvm16Synchronizer) {
                    try {
                        this.dummyOutputStream.write(("!!!commonExecuteBefore:  totalParameterLength_ = " + this.parameterTotalSize_).getBytes());
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                }
                this.changeDescriptor();
            }
            try {
                request.setStatementType(sqlStatement.getNativeType());
                request.setParameterMarkerDescriptorHandle(this.descriptorHandle_);
                if (this.parameterCount_ > 0) {
                    if (this.saveParameterValues_ && this.parameterRow_ != null) {
                        this.parameterRow_.saveValues();
                    }
                    boolean descriptorChangeNeeded = false;
                    do {
                        DBData parameterMarkerData;
                        descriptorChangeNeeded = false;
                        int rowCount = this.batchExecute_ ? this.batchParameterRows_.size() : 1;
                        boolean useVariableFieldInsertCompression = false;
                        if (this.batchExecute_ && rowCount > 0 && this.useVariableFieldInsertCompression()) {
                            useVariableFieldInsertCompression = true;
                        }
                        if (this.parameterRow_.containsArray_) {
                            parameterMarkerData = new DBVariableData(this.parameterInputCount_, 2, this.headerTotalSize_, this.indicatorTotalSize_, this.parameterTotalSize_);
                            if (useVariableFieldInsertCompression) {
                                useVariableFieldInsertCompression = false;
                            }
                        } else if (this.connection_.useExtendedFormats()) {
                            parameterMarkerData = new DBExtendedData(rowCount, this.parameterCount_, 2, this.parameterTotalSize_);
                        } else {
                            parameterMarkerData = new DBOriginalData(rowCount, this.parameterCount_, 2, this.parameterTotalSize_);
                            if (useVariableFieldInsertCompression) {
                                useVariableFieldInsertCompression = false;
                            }
                        }
                        int parameterOffset = 0;
                        int rowDataOffset = 0;
                        for (int rowLoop = 0; rowLoop < rowCount; ++rowLoop) {
                            Object[] parameters = null;
                            if (this.batchExecute_) {
                                parameters = (Object[])this.batchParameterRows_.get(rowLoop);
                            }
                            if (rowLoop == 0) {
                                if (useVariableFieldInsertCompression) {
                                    requestLengthOffset = request.setParameterMarkerDataReserve(parameterMarkerData);
                                    ((DBExtendedData)parameterMarkerData).setParameterMarkerInputCompression(true);
                                } else {
                                    request.setParameterMarkerData(parameterMarkerData);
                                }
                                parameterMarkerData.setConsistencyToken(1);
                            }
                            if (rowLoop == 0) {
                                if (useVariableFieldInsertCompression) {
                                    initialRawOffset = ((DBExtendedData)parameterMarkerData).getRawOffset();
                                }
                                rowDataOffset = parameterMarkerData.getRowDataOffset(rowLoop);
                            } else {
                                rowDataOffset = useVariableFieldInsertCompression ? (rowDataOffset += parameterOffset) : parameterMarkerData.getRowDataOffset(rowLoop);
                            }
                            parameterOffset = 0;
                            for (int i3 = 0; i3 < this.parameterCount_; ++i3) {
                                if (this.batchExecute_ && parameters != null && (parameters[i3] == null || parameters[i3] instanceof Byte) || !this.batchExecute_ && (this.parameterNulls_[i3] || this.parameterDefaults_[i3] || this.parameterUnassigned_[i3])) {
                                    short indicatorValue = -1;
                                    if (this.batchExecute_ && parameters != null) {
                                        if (parameters[i3] == null) {
                                            indicatorValue = -1;
                                        } else if ((Byte)parameters[i3] == 1) {
                                            indicatorValue = -5;
                                        } else if ((Byte)parameters[i3] == 2) {
                                            indicatorValue = -7;
                                        }
                                    } else if (this.parameterNulls_[i3]) {
                                        indicatorValue = -1;
                                    } else if (this.parameterDefaults_[i3]) {
                                        indicatorValue = -5;
                                    } else if (this.parameterUnassigned_[i3]) {
                                        indicatorValue = -7;
                                    }
                                    SQLData sqlData = this.parameterRow_.getSQLType(i3 + 1);
                                    if (sqlData.getType() != 2003) {
                                        parameterMarkerData.setIndicator(rowLoop, i3, indicatorValue);
                                    }
                                    if (sqlData.getType() != 2003) {
                                        int z;
                                        int parameterDataLength;
                                        byte[] parameterData = parameterMarkerData.getRawBytes();
                                        if (useVariableFieldInsertCompression) {
                                            if (sqlData instanceof SQLVariableCompressible) {
                                                parameterData[rowDataOffset + parameterOffset] = 0;
                                                parameterData[rowDataOffset + ++parameterOffset] = 0;
                                                ++parameterOffset;
                                                variableDataLength += 2;
                                            } else {
                                                int parameterDataOffset = rowDataOffset + parameterOffset;
                                                parameterDataLength = this.parameterLengths_[i3] + parameterDataOffset;
                                                z = parameterDataOffset;
                                                while (z < parameterDataLength) {
                                                    parameterData[z++] = 0;
                                                }
                                                parameterOffset += this.parameterLengths_[i3];
                                            }
                                        } else {
                                            int parameterDataOffset = rowDataOffset + this.parameterOffsets_[i3];
                                            parameterDataLength = this.parameterLengths_[i3] + parameterDataOffset;
                                            z = parameterDataOffset;
                                            while (z < parameterDataLength) {
                                                parameterData[z++] = 0;
                                            }
                                        }
                                    }
                                    if (!this.parameterRow_.containsArray_ || !this.parameterRow_.isInput(i3 + 1)) continue;
                                    int arrayLen = -1;
                                    int elementType = -1;
                                    int size = -1;
                                    if (sqlData.getType() == 2003) {
                                        arrayLen = ((SQLArray)sqlData).getArrayCount();
                                        elementType = ((SQLArray)sqlData).getElementNativeType();
                                        size = this.parameterRow_.getArrayDataLength(i3 + 1);
                                    } else {
                                        size = this.parameterRow_.getLength(i3 + 1);
                                    }
                                    ((DBVariableData)parameterMarkerData).setHeaderColumnInfo(i3, (short)sqlData.getNativeType(), indicatorValue, (short)elementType, size, (short)arrayLen);
                                    continue;
                                }
                                SQLData sqlData = this.parameterRow_.getSQLType(i3 + 1);
                                if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(i3 + 1)) {
                                    if (sqlData.getType() == 2003) {
                                        for (int e = 0; e < ((SQLArray)sqlData).getArrayCount(); ++e) {
                                            if (((SQLArray)sqlData).isElementNull(e)) {
                                                parameterMarkerData.setIndicator(0, i3, -1);
                                                continue;
                                            }
                                            parameterMarkerData.setIndicator(0, i3, 0);
                                        }
                                    } else {
                                        parameterMarkerData.setIndicator(rowLoop, i3, 0);
                                    }
                                }
                                ConvTable ccsidConverter = this.connection_.getConverter(this.parameterRow_.getCCSID(i3 + 1));
                                int correctLength = -1;
                                if (this.batchExecute_ && parameters != null) {
                                    this.setValue(i3 + 1, parameters[i3], null, -1);
                                }
                                try {
                                    if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(i3 + 1)) {
                                        int thisParameterOffset = 0;
                                        if (useVariableFieldInsertCompression) {
                                            if (sqlData instanceof SQLVariableCompressible) {
                                                thisParameterOffset = rowDataOffset + parameterOffset;
                                                int written = ((SQLVariableCompressible)((Object)sqlData)).convertToCompressedBytes(parameterMarkerData.getRawBytes(), thisParameterOffset, ccsidConverter);
                                                variableDataLength += written;
                                                parameterOffset += written;
                                            } else {
                                                thisParameterOffset = rowDataOffset + parameterOffset;
                                                sqlData.convertToRawBytes(parameterMarkerData.getRawBytes(), thisParameterOffset, ccsidConverter);
                                                parameterOffset += this.parameterLengths_[i3];
                                            }
                                        } else {
                                            thisParameterOffset = rowDataOffset + this.parameterOffsets_[i3];
                                            sqlData.convertToRawBytes(parameterMarkerData.getRawBytes(), thisParameterOffset, ccsidConverter);
                                        }
                                        boolean checkRawBytes = this.testDataTruncation(i3 + 1, sqlData);
                                        if (checkRawBytes) {
                                            sqlData.validateRawTruncatedData(parameterMarkerData.getRawBytes(), thisParameterOffset, ccsidConverter);
                                        }
                                    }
                                    if (this.parameterRow_.containsArray_ && this.parameterRow_.isInput(i3 + 1)) {
                                        int size;
                                        int arrayLen = -1;
                                        int elementType = -1;
                                        if (sqlData.getType() == 2003) {
                                            size = this.parameterRow_.getArrayDataLength(i3 + 1);
                                            arrayLen = ((SQLArray)sqlData).getArrayCount();
                                            elementType = ((SQLArray)sqlData).getElementNativeType();
                                        } else {
                                            size = this.parameterRow_.getLength(i3 + 1);
                                        }
                                        ((DBVariableData)parameterMarkerData).setHeaderColumnInfo(i3, (short)sqlData.getNativeType(), (short)0, (short)elementType, size, (short)arrayLen);
                                    }
                                }
                                catch (SQLException e) {
                                    if (e.getSQLState().trim().equals("HY000")) {
                                        if (this.parameterRow_.containsArray_) {
                                            throw e;
                                        }
                                        if (e.getMessage().indexOf("Change Descriptor") != -1) {
                                            correctLength = sqlData.getPrecision();
                                        }
                                        throw e;
                                    }
                                    throw e;
                                }
                                if (correctLength < 0) continue;
                                descriptorChangeNeeded = true;
                                this.parameterLengths_[i3] = correctLength;
                                this.parameterTotalSize_ = this.parameterOffsets_[i3] + correctLength;
                                if (i3 + 1 >= this.parameterCount_) continue;
                                for (int j = i3 + 1; j < this.parameterCount_; ++j) {
                                    this.parameterOffsets_[j] = this.parameterTotalSize_;
                                    this.parameterTotalSize_ += this.parameterLengths_[j];
                                }
                            }
                            if (!descriptorChangeNeeded) continue;
                            this.changeDescriptor();
                        }
                        if (!useVariableFieldInsertCompression) continue;
                        int parametersLength = (rowDataOffset += parameterOffset) - initialRawOffset;
                        request.updateLength(requestLengthOffset, parametersLength);
                        if (variableDataLength <= 80 * parametersLength / 100) continue;
                        this.disableRllCompression_ = true;
                    } while (descriptorChangeNeeded);
                    request.setParameterMarkerBlockIndicator(0);
                }
                if (this.outputParametersExpected_) {
                    request.addOperationResultBitmap(0x4000000);
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
            }
        }
    }

    private boolean useVariableFieldInsertCompression() throws SQLException {
        if (this.useVariableFieldInsertCompression_) {
            int totalSize = 0;
            int compressibleSize = 0;
            for (int parameterNumber = 0; parameterNumber < this.parameterCount_; ++parameterNumber) {
                int parameterSize = this.parameterRow_.getLength(parameterNumber + 1);
                SQLData sqlData = this.parameterRow_.getSQLType(parameterNumber + 1);
                if (sqlData instanceof SQLVariableCompressible) {
                    compressibleSize += parameterSize;
                }
                totalSize += parameterSize;
            }
            return compressibleSize > totalSize / 3;
        }
        return false;
    }

    @Override
    void commonPrepareAfter(JDSQLStatement sqlStatement, DBReplyRequestedDS reply) throws SQLException {
        super.commonPrepareAfter(sqlStatement, reply);
        if (this.prepared_) {
            JDServerRow newParameterRow = new JDServerRow(this.connection_, this.id_, reply.getParameterMarkerFormat(), this.settings_);
            if (this.preserveParameters_ && this.parameterRow_ != null) {
                newParameterRow.restoreSavedParameters(this.parameterRow_);
            }
            this.parameterRow_ = newParameterRow;
        }
    }

    @Override
    void commonPrepareBefore(JDSQLStatement sqlStatement, DBSQLRequestDS request) throws SQLException {
        super.commonPrepareBefore(sqlStatement, request);
        if (this.prepared_) {
            request.addOperationResultBitmap(0x800000);
        }
    }

    @Override
    void commonPrepareBypass(JDSQLStatement sqlStatement, int statementIndex) throws SQLException {
        super.commonPrepareBypass(sqlStatement, statementIndex);
        if (this.prepared_) {
            this.parameterRow_ = new JDServerRow(this.connection_, this.id_, this.packageManager_.getCachedParameterMarkerFormat(statementIndex), this.settings_);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            boolean bl = this.resultSet_ != null;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columns) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.batch_ == null || this.batch_.size() == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            this.batchParameterRows_ = new Vector();
            int batchSize = this.batch_.size();
            int[] updateCounts = new int[batchSize];
            int numSuccessful = 0;
            boolean canBatch = true;
            try {
                if (!this.sqlStatement_.canBatch()) {
                    canBatch = false;
                }
                if (this.containsLocator_ == 1) {
                    canBatch = false;
                }
                this.batchExecute_ = true;
                this.rowsInserted_ = 0;
                if (!this.prepared_) {
                    this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                    this.prepared_ = true;
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException((Object)this, "24000");
                    }
                }
                if (canBatch) {
                    int maximumBlockedInputRows = this.connection_.getMaximumBlockedInputRows();
                    Enumeration list = this.batch_.elements();
                    int count = 0;
                    int totalUpdateCount = 0;
                    while (list.hasMoreElements()) {
                        this.batchParameterRows_.add(list.nextElement());
                        if (++count != maximumBlockedInputRows || !list.hasMoreElements()) continue;
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                        }
                        this.executingBatchedStatement_ = true;
                        this.commonExecute(this.sqlStatement_, this.resultRow_);
                        this.executingBatchedStatement_ = false;
                        totalUpdateCount += this.updateCount_;
                        this.batchParameterRows_.clear();
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException((Object)this, "24000");
                        }
                        count = 0;
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                    }
                    this.executingBatchedStatement_ = true;
                    this.commonExecute(this.sqlStatement_, this.resultRow_);
                    this.executingBatchedStatement_ = false;
                    totalUpdateCount += this.updateCount_;
                    this.batchParameterRows_.clear();
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException((Object)this, "24000");
                    }
                    numSuccessful = batchSize;
                    int updateCount = -2;
                    if (batchSize == totalUpdateCount && this.sqlStatement_.isInsert_) {
                        updateCount = 1;
                    }
                    for (int i = 0; i < batchSize; ++i) {
                        updateCounts[i] = updateCount;
                    }
                } else {
                    Enumeration list = this.batch_.elements();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Begin batching via client-side multiple executes.");
                    }
                    while (list.hasMoreElements()) {
                        this.batchParameterRows_.addElement(list.nextElement());
                        this.executingBatchedStatement_ = true;
                        this.commonExecute(this.sqlStatement_, this.resultRow_);
                        this.executingBatchedStatement_ = false;
                        this.batchParameterRows_.removeAllElements();
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException((Object)this, "24000");
                        }
                        updateCounts[numSuccessful++] = this.rowsInserted_;
                    }
                }
                this.executed_ = true;
            }
            catch (SQLException e) {
                int[] counts = null;
                if (canBatch) {
                    counts = new int[this.rowsInserted_];
                    for (int i = 0; i < counts.length; ++i) {
                        counts[i] = -2;
                    }
                } else {
                    counts = new int[numSuccessful];
                    System.arraycopy(updateCounts, 0, counts, 0, numSuccessful);
                }
                BatchUpdateException batchUpdateException = new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), counts);
                batchUpdateException.initCause(e);
                throw batchUpdateException;
            }
            finally {
                this.batch_.removeAllElements();
                this.batchExecute_ = false;
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Done batching.");
                }
            }
            int[] nArray = updateCounts;
            return nArray;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ == null && (this.behaviorOverride_ & 1) == 0) {
                JDError.throwSQLException((Object)this, "24000");
            }
            AS400JDBCResultSet aS400JDBCResultSet = this.resultSet_;
            return aS400JDBCResultSet;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
                if (this.resultRow_ != null) {
                    JDError.throwSQLException((Object)this, "24000");
                }
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ != null) {
                this.closeResultSet(241);
                JDError.throwSQLException((Object)this, "24000");
            }
            int n = this.updateCount_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columns) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.resultRow_ == null) {
                ResultSetMetaData resultSetMetaData = null;
                return resultSetMetaData;
            }
            ConvTable convTable = null;
            DBExtendedColumnDescriptors extendedDescriptors = this.extendedColumnDescriptors_;
            if (extendedDescriptors != null) {
                convTable = this.connection_.getConverter();
            }
            AS400JDBCResultSetMetaData aS400JDBCResultSetMetaData = new AS400JDBCResultSetMetaData(this.connection_.getCatalog(), this.resultSetConcurrency_, this.cursor_.getName(), this.resultRow_, extendedDescriptors, convTable, this.connection_);
            return aS400JDBCResultSetMetaData;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    void validatePSParameterIndex(int param) throws SQLException {
        int parameterCount = this.getParameterCount();
        if (param > parameterCount) {
            JDError.throwSQLException((Object)this, "07009", param + ">" + parameterCount);
        }
        if (param < 1) {
            JDError.throwSQLException((Object)this, "07009", param + "<1");
        }
    }

    @Override
    String getParameterClassName(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    String string = this.returnValueParameter_.getJavaClassName();
                    return string;
                }
                --param;
            }
            String string = this.parameterRow_.getSQLData(param).getJavaClassName();
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int getParameterCount() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                int n = this.parameterCount_ + 1;
                return n;
            }
            int n = this.parameterCount_;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            ParameterMetaData parameterMetaData = new AS400JDBCParameterMetaData(this);
            return parameterMetaData;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getParameterMode(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = 4;
                    return n;
                }
                --param;
            }
            boolean input = this.parameterRow_.isInput(param);
            boolean output = this.parameterRow_.isOutput(param);
            if (input && output) {
                int n = 2;
                return n;
            }
            if (input) {
                int n = 1;
                return n;
            }
            if (output) {
                int n = 4;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int getParameterType(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = this.returnValueParameter_.getType();
                    return n;
                }
                --param;
            }
            int n = this.parameterRow_.getSQLData(param).getType();
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int getParameterCcsid(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = 0;
                    return n;
                }
                --param;
            }
            int n = this.parameterRow_.getCCSID(param);
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    String getParameterTypeName(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    String string = this.returnValueParameter_.getTypeName();
                    return string;
                }
                --param;
            }
            String string = this.parameterRow_.getSQLData(param).getTypeName();
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int getPrecision(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = this.returnValueParameter_.getPrecision();
                    return n;
                }
                --param;
            }
            int n = this.parameterRow_.getSQLData(param).getPrecision();
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int getScale(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = this.returnValueParameter_.getScale();
                    return n;
                }
                --param;
            }
            int n = this.parameterRow_.getSQLData(param).getScale();
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    int isNullable(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    int n = 0;
                    return n;
                }
                --param;
            }
            int n = this.parameterRow_.isNullable(param);
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    boolean isSigned(int param) throws SQLException {
        this.validatePSParameterIndex(param);
        try {
            this.internalLock.lock();
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (param == 1) {
                    boolean bl = this.returnValueParameter_.isSigned();
                    return bl;
                }
                --param;
            }
            boolean bl = this.parameterRow_.getSQLData(param).isSigned();
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setArray(int parameterIndex, Array parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setArray()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: Array type " + parameterValue.getBaseTypeName());
            }
        }
        if (!this.sqlStatement_.isProcedureCall()) {
            JDError.throwSQLException((Object)this, "HY105");
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        if (length < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (parameterValue != null) {
                try {
                    int sqlType = sqlData.getSQLType();
                    if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                        }
                        sqlData.set(new ConvTableReader(parameterValue, 819, 0, 1000000), null, length);
                    } else if (sqlType == 41) {
                        JDError.throwSQLException((Object)this, "07006");
                    } else {
                        sqlData.set(JDUtilities.readerToString(new ConvTableReader(parameterValue, 819, 0, 1000000), length), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = parameterValue == null;
            this.parameterDefaults_[parameterIndex - 1] = false;
            this.parameterUnassigned_[parameterIndex - 1] = false;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBigDecimal()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        if (length < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (parameterValue != null) {
                if (sqlData instanceof SQLLocator) {
                    SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                    sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    sqlData.set(parameterValue, null, length);
                } else {
                    sqlData.set(JDUtilities.streamToBytes(parameterValue, length), null, length);
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = parameterValue == null;
            this.parameterDefaults_[parameterIndex - 1] = false;
            this.parameterUnassigned_[parameterIndex - 1] = false;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + parameterValue.length());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBoolean()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, (short)(parameterValue ? 1 : 0), null, -1);
    }

    @Override
    public void setByte(int parameterIndex, byte parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setByte()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBytes()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (parameterValue.length > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + parameterValue.length);
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + parameterValue.length + " value: " + Trace.toHexString(parameterValue));
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        if (length < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (parameterValue != null) {
                int sqlType = sqlData.getSQLType();
                if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                    SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                    sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    }
                    sqlData.set(JDUtilities.readerToString(parameterValue, length), null, -1);
                } else if (sqlType == 41) {
                    JDError.throwSQLException((Object)this, "07006");
                } else {
                    sqlData.set(JDUtilities.readerToString(parameterValue, length), null, -1);
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = parameterValue == null;
            this.parameterDefaults_[parameterIndex - 1] = false;
            this.parameterUnassigned_[parameterIndex - 1] = false;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (parameterValue.length() > (long)this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.getSubString(1L, (int)parameterValue.length()));
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + parameterValue.length());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setDate(int parameterIndex, Date parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setDate(int parameterIndex, Date parameterValue, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(parameterIndex, parameterValue, calendar, -1);
    }

    @Override
    public void setDB2Default(int parameterIndex) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Default()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex);
        }
        this.setValueExtendedIndicator(parameterIndex, 1);
    }

    @Override
    public void setDBDefault(int parameterIndex) throws SQLException {
        this.setDB2Default(parameterIndex);
    }

    @Override
    public void setDB2Unassigned(int parameterIndex) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Unassigned()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex);
        }
        this.setValueExtendedIndicator(parameterIndex, 2);
    }

    @Override
    public void setDBUnassigned(int parameterIndex) throws SQLException {
        this.setDB2Unassigned(parameterIndex);
    }

    @Override
    public void setDouble(int parameterIndex, double parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDouble()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setFloat(int parameterIndex, float parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFloat()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, Float.valueOf(parameterValue), null, -1);
    }

    @Override
    public void setInt(int parameterIndex, int parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setInt()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setLong(int parameterIndex, long parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setLong()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
        }
        this.setValue(parameterIndex, null, null, -1);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
        }
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " type: " + parameterValue.getClass().getName() + " toString():" + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object parameterValue, int sqlType) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " type: " + parameterValue.getClass().getName() + " toString():" + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object parameterValue, int sqlType, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " type: " + parameterValue.getClass().getName() + " toString():" + parameterValue.toString());
            }
        }
        if (scale < 0) {
            JDError.throwSQLException((Object)this, "HY094");
        }
        if (parameterValue instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)parameterValue);
        } else {
            this.setValue(parameterIndex, parameterValue, null, scale);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref parameterValue) throws SQLException {
        JDError.throwSQLException((Object)this, "HY105");
    }

    @Override
    public void setShort(int parameterIndex, short parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setShort()");
            JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setString(int parameterIndex, String parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setString()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (parameterValue.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + parameterValue.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue);
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setTime(int parameterIndex, Time parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setTime(int parameterIndex, Time parameterValue, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(parameterIndex, parameterValue, calendar, -1);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp parameterValue, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(parameterIndex, parameterValue, calendar, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setUnicodeStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        if (length < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (parameterValue != null) {
                try {
                    int sqlType = sqlData.getSQLType();
                    if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                        SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                        sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                        }
                        sqlData.set(new ConvTableReader(parameterValue, 13488, 0, 1000000), null, length / 2);
                    } else if (sqlType == 41) {
                        JDError.throwSQLException((Object)this, "07006");
                    } else {
                        sqlData.set(JDUtilities.readerToString(new ConvTableReader(parameterValue, 13488, 0, 1000000), length / 2), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = parameterValue == null;
            this.parameterDefaults_[parameterIndex - 1] = false;
            this.parameterUnassigned_[parameterIndex - 1] = false;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setURL(int parameterIndex, URL parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setURL()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + parameterValue.toString());
            }
        }
        this.setValue(parameterIndex, parameterValue, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(int parameterIndex, Object parameterValue, Calendar calendar, int scale) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (parameterValue != null) {
                int sqlType = sqlData.getSQLType();
                if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                    SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                    sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    }
                }
                sqlData.set(parameterValue, calendar, scale);
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = parameterValue == null;
            this.parameterDefaults_[parameterIndex - 1] = false;
            this.parameterUnassigned_[parameterIndex - 1] = false;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    void setValueExtendedIndicator(int parameterIndex, int parameterValue) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            this.parameterNulls_[parameterIndex - 1] = false;
            this.parameterDefaults_[parameterIndex - 1] = parameterValue == 1;
            this.parameterUnassigned_[parameterIndex - 1] = parameterValue == 2;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private boolean testDataTruncation(int parameterIndex, SQLData data) throws SQLException {
        return this.connection_.testDataTruncation(this, null, parameterIndex, true, data, this.sqlStatement_);
    }

    void testSQLType(int sqlType, int parameterIndex) throws SQLException {
        int parameterType = this.parameterRow_.getSQLType(parameterIndex).getType();
        if (sqlType != parameterType && (sqlType != 1 && sqlType != 12 || parameterType != 1 && parameterType != 12)) {
            JDError.throwSQLException((Object)this, "HY105");
        }
    }

    @Override
    JDServerRow getResultRow() {
        return this.resultRow_;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setRowId()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + x.toString());
            }
        }
        this.setValue(parameterIndex, x, null, -1);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNString()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (value.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + value.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + value);
            }
        }
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        this.setCharacterStream(parameterIndex, value, (int)length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (value.length() > (long)this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + value.getSubString(1L, (int)value.length()));
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + value.length());
            }
        }
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        this.setBinaryStream(parameterIndex, inputStream, (int)length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + length);
            }
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (JDTrace.isTraceOn()) {
            int len = xmlObject == null ? 0 : xmlObject.getString().length();
            JDTrace.logInformation(this, "setSQLXML()");
            if (xmlObject == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            } else if (len < this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: " + xmlObject.getString());
            } else {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " length: " + len);
            }
        }
        if (xmlObject == null) {
            this.setValue(parameterIndex, xmlObject, null, -1);
            return;
        }
        SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
        int sqlDataType = sqlData.getType();
        switch (sqlDataType) {
            case 2005: {
                this.setCharacterStream(parameterIndex, xmlObject.getCharacterStream());
                break;
            }
            case 2004: {
                this.setBinaryStream(parameterIndex, xmlObject.getBinaryStream());
                break;
            }
            default: {
                this.setValue(parameterIndex, xmlObject, null, -1);
            }
        }
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCPreparedStatement", "java.sql.PreparedStatement"};
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeParameterNames() throws SQLException {
        boolean isProcedure = this.sqlStatement_.getProcedure() != null;
        int count = 0;
        if (this.parameterNames_ == null) {
            this.parameterNames_ = new String[this.parameterCount_];
            boolean allFound = true;
            for (int parameterNumber = 0; allFound && parameterNumber < this.parameterCount_; ++parameterNumber) {
                try {
                    String name = this.parameterRow_.getFieldName(parameterNumber + 1);
                    if (name != null) {
                        this.parameterNames_[parameterNumber] = name;
                        continue;
                    }
                    if (!isProcedure) continue;
                    allFound = false;
                    continue;
                }
                catch (SQLException sqlex) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "exception while retrieving field names", sqlex);
                    }
                    allFound = false;
                }
            }
            if (!allFound) {
                Statement s = null;
                ResultSet rs = null;
                try {
                    s = this.connection_.createStatement();
                    String catalogSeparator = "";
                    catalogSeparator = this.connection_.getProperties().equals(9, "sql") ? "." : "/";
                    String schema = this.sqlStatement_.getSchema();
                    if ((schema == null || schema.equals("")) && (schema = this.connection_.getDefaultSchema(true)) == null) {
                        if (catalogSeparator.equals(".")) {
                            schema = this.connection_.getUserName();
                        } else {
                            ResultSet rs1 = JDUtilities.getLibraries(this, this.connection_, null, true);
                            Vector<String> libListV = new Vector<String>();
                            while (rs1.next()) {
                                libListV.addElement(rs1.getString(1));
                            }
                            rs1.close();
                            String[] libList = new String[libListV.size()];
                            libListV.toArray(libList);
                            Statement s1 = this.connection_.createStatement(1004, 1007);
                            rs = s1.executeQuery("SELECT ROUTINE_SCHEMA FROM QSYS2" + catalogSeparator + "SYSPROCS WHERE ROUTINE_NAME='" + AS400JDBCPreparedStatementImpl.unquote(this.sqlStatement_.getProcedure()) + "' AND IN_PARMS + OUT_PARMS + INOUT_PARMS = " + this.parameterCount_);
                            if (!rs.next()) {
                                JDError.throwSQLException((Object)this, "HY000");
                            }
                            boolean found = false;
                            for (int i = 0; i < libList.length && !found; ++i) {
                                if (libList[i].length() == 0) continue;
                                rs.beforeFirst();
                                while (rs.next() && !found) {
                                    if (!rs.getString(1).equals(libList[i])) continue;
                                    schema = rs.getString(1);
                                    found = true;
                                }
                            }
                            rs.close();
                            s1.close();
                            if (!found) {
                                JDError.throwSQLException((Object)this, "HY000");
                            }
                        }
                    }
                    if (!(rs = s.executeQuery("SELECT SPECIFIC_NAME FROM QSYS2" + catalogSeparator + "SYSPROCS WHERE ROUTINE_SCHEMA = '" + AS400JDBCPreparedStatementImpl.unquote(schema) + "' AND ROUTINE_NAME = '" + AS400JDBCPreparedStatementImpl.unquote(this.sqlStatement_.getProcedure()) + "' AND IN_PARMS + OUT_PARMS + INOUT_PARMS = " + this.parameterCount_)).next()) {
                        JDError.throwSQLException((Object)this, "HY000");
                    }
                    String specificName = rs.getString(1);
                    rs.close();
                    rs = s.executeQuery("SELECT PARAMETER_NAME, ORDINAL_POSITION FROM QSYS2" + catalogSeparator + "SYSPARMS WHERE  SPECIFIC_NAME = '" + AS400JDBCPreparedStatementImpl.unquoteNoUppercase(specificName) + "' AND SPECIFIC_SCHEMA = '" + AS400JDBCPreparedStatementImpl.unquote(schema) + "'");
                    while (rs.next()) {
                        ++count;
                        String colName = rs.getString(1);
                        int colInd = rs.getInt(2);
                        this.parameterNames_[colInd - 1] = colName;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                }
                if (count != this.parameterCount_) {
                    JDError.throwSQLException((Object)this, "HY000");
                }
            }
        }
    }

    @Override
    int findParameterIndex(String parameterName) throws SQLException {
        if (parameterName == null) {
            throw JDError.throwSQLException((Object)this, "HY024");
        }
        if (this.isClosed()) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        boolean caseSensitive = false;
        int count = 0;
        int returnParm = 0;
        if (parameterName.startsWith("\"") && parameterName.endsWith("\"")) {
            parameterName = JDUtilities.stripOuterDoubleQuotes(parameterName);
            caseSensitive = true;
        }
        if (this.parameterNames_ == null) {
            this.initializeParameterNames();
        }
        while (count < this.parameterNames_.length) {
            if (this.parameterNames_[count] != null && (caseSensitive && this.parameterNames_[count].equals(parameterName) || !caseSensitive && this.parameterNames_[count].equalsIgnoreCase(parameterName))) {
                returnParm = count + 1;
                break;
            }
            ++count;
        }
        if (returnParm == 0) {
            JDError.throwSQLException((Object)this, "42703");
        }
        if (this.useReturnValueParameter_) {
            ++returnParm;
        }
        return returnParm;
    }

    @Override
    public String getDB2ParameterName(int parm) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parm);
            --parm;
            if (this.useReturnValueParameter_) {
                --parm;
            }
            if (this.parameterNames_ == null) {
                this.initializeParameterNames();
            }
            if (parm >= 0 && parm < this.parameterNames_.length) {
                String string = this.parameterNames_[parm];
                return string;
            }
            JDError.throwSQLException((Object)this, "07009", "INTERNAL_ERROR");
            String string = null;
            return string;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private static final String unquote(String name) {
        return JDUtilities.prepareForSingleQuotes(name, true);
    }

    private static final String unquoteNoUppercase(String name) {
        return JDUtilities.prepareForSingleQuotes(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (x != null) {
                int sqlType = sqlData.getSQLType();
                if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                    SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                    sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    }
                    sqlData.set(x, null, -2);
                } else {
                    sqlData.set(x, null, -2);
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = x == null;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream(int, InputStream)");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setInputStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream(int, InputStream)");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setInputStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob(int, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setInputStream(parameterIndex, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReader(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.internalLock.lock();
            this.checkOpen();
            this.validatePSParameterIndex(parameterIndex);
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --parameterIndex;
                }
            }
            if (!this.parameterRow_.isInput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sqlData = this.parameterRow_.getSQLType(parameterIndex);
            if (reader != null) {
                int sqlType = sqlData.getSQLType();
                if (sqlType == 8 || sqlType == 4 || sqlType == 12 || sqlType == 34 || sqlType == 40) {
                    SQLLocator sqlDataAsLocator = (SQLLocator)sqlData;
                    sqlDataAsLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(parameterIndex));
                    }
                    sqlData.set(reader, null, -2);
                } else if (sqlType == 41) {
                    JDError.throwSQLException((Object)this, "07006");
                } else {
                    sqlData.set(JDUtilities.readerToString(reader), null, -1);
                }
                this.testDataTruncation(parameterIndex, sqlData);
            }
            this.parameterNulls_[parameterIndex - 1] = reader == null;
            this.parameterSet_[parameterIndex - 1] = true;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setReader(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setReader(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream(int, Reader)");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setReader(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + parameterIndex + " value: NULL");
            }
        }
        this.setReader(parameterIndex, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        int intType = this.mapSQLType(targetSqlType);
        this.setObject(parameterIndex, x, intType, scaleOrLength);
    }

    int mapSQLType(Object targetSqlType) throws SQLException {
        return 0;
    }

    @Override
    public void setObject(int parameterIndex, Object x, Object targetSqlType) throws SQLException {
        int intType = this.mapSQLType(targetSqlType);
        this.setObject(parameterIndex, x, intType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    void checkOpen() throws SQLException {
        super.checkOpen();
        if (this.connectionReset_) {
            this.preserveParameters_ = true;
            if (this.parameterRow_ != null) {
                this.parameterRow_.saveValues();
            }
            this.resultRow_ = this.commonPrepare(this.sqlStatement_);
            this.connectionReset_ = false;
        }
    }

    @Override
    void setConnectionReset(boolean reset) {
        this.descriptorHandle_ = 0;
        super.setConnectionReset(reset);
    }

    @Override
    void setSaveParameterValues(boolean saveParameterValues) {
        this.saveParameterValues_ = saveParameterValues;
    }

    static {
        String jvm16Synchronize = SystemProperties.getProperty("com.ibm.as400.access.JDBC.jvm16Synchronize");
        isjvm16SynchronizerStatic = false;
        if (jvm16Synchronize != null && Boolean.valueOf(jvm16Synchronize.trim()).booleanValue()) {
            try {
                Class.forName("java.sql.SQLXML");
                isjvm16SynchronizerStatic = true;
            }
            catch (Exception e) {
                isjvm16SynchronizerStatic = false;
            }
        } else {
            isjvm16SynchronizerStatic = false;
        }
    }
}

