/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator.advanced.markovchain;

import com.dbeaver.ee.mockdata.engine.generator.advanced.AdvancedStringValueGenerator;
import com.dbeaver.ee.mockdata.engine.generator.advanced.markovchain.MarkovChain;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class MarkovChainGenerator
extends AdvancedStringValueGenerator {
    private static final String DEF_BOOK = "book_hamlet.txt";
    private MarkovChain mc;
    private int minWordCount;
    private int maxWordCount;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<String, Object> properties) throws DBException {
        super.init(container, attribute, properties);
        this.minWordCount = CommonUtils.toInt((Object)properties.get("minWordCount"), (int)5);
        this.maxWordCount = CommonUtils.toInt((Object)properties.get("maxWordCount"), (int)10);
    }

    @Override
    protected Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.mc == null) {
            this.initMC();
        }
        int wordCount = this.minWordCount == this.maxWordCount ? this.minWordCount : this.minWordCount + this.mc.getRandom().nextInt(this.maxWordCount - this.minWordCount);
        return MarkovChainGenerator.concat(this.mc.compose(wordCount));
    }

    private void initMC() throws IOException {
        List<String> textLines = super.readDict(DEF_BOOK);
        LinkedHashSet wordSet = new LinkedHashSet();
        for (String line : textLines) {
            Collections.addAll(wordSet, line.split("(\\s|\\W)+"));
        }
        String[] words = wordSet.toArray(new String[0]);
        MarkovChainGenerator.setWordsToLowerCase(words);
        this.mc = new MarkovChain(words, 2);
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(string);
            ++n2;
        }
        return sb.toString();
    }

    private static void setWordsToLowerCase(String[] words) {
        int i = 0;
        while (i < words.length) {
            words[i] = words[i].toLowerCase();
            ++i;
        }
    }
}

