/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator;

import com.dbeaver.ee.mockdata.engine.generator.AbstractMockValueGenerator;
import com.dbeaver.ee.mockdata.engine.internal.MockDataMessages;
import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class BooleanSequenceGenerator
extends AbstractMockValueGenerator {
    private boolean value;
    private ORDER order;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<String, Object> properties) throws DBException {
        Boolean initial;
        super.init(container, attribute, properties);
        String o = (String)properties.get("order");
        if (o != null) {
            this.order = ORDER.find(o);
        }
        if ((initial = (Boolean)properties.get("initial")) != null) {
            this.value = initial == false;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        switch (this.order) {
            case CONSTANT: {
                return this.value;
            }
            case ALTERNATELY: {
                this.value = !this.value;
                return this.value;
            }
        }
        return null;
    }

    private static enum ORDER {
        ALTERNATELY(MockDataMessages.tools_mockdata_generator_boolean_sequence_prop_order_value_alternately),
        CONSTANT(MockDataMessages.tools_mockdata_generator_boolean_sequence_prop_order_value_constant);

        private String label;

        private ORDER(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static ORDER find(String label) {
            ORDER[] oRDERArray = ORDER.values();
            int n = oRDERArray.length;
            int n2 = 0;
            while (n2 < n) {
                ORDER order = oRDERArray[n2];
                if (order.label.equalsIgnoreCase(label)) {
                    return order;
                }
                ++n2;
            }
            return null;
        }
    }
}

