/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ManagedWorkgroupListItem;

public class ListManagedWorkgroupsIterable
implements SdkIterable<ListManagedWorkgroupsResponse> {
    private final RedshiftServerlessClient client;
    private final ListManagedWorkgroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedWorkgroupsIterable(RedshiftServerlessClient client, ListManagedWorkgroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedWorkgroupsResponseFetcher();
    }

    public Iterator<ListManagedWorkgroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedWorkgroupListItem> managedWorkgroups() {
        Function<ListManagedWorkgroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedWorkgroups() != null) {
                return response.managedWorkgroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedWorkgroupsResponseFetcher
    implements SyncPageFetcher<ListManagedWorkgroupsResponse> {
        private ListManagedWorkgroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedWorkgroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedWorkgroupsResponse nextPage(ListManagedWorkgroupsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedWorkgroupsIterable.this.client.listManagedWorkgroups(ListManagedWorkgroupsIterable.this.firstRequest);
            }
            return ListManagedWorkgroupsIterable.this.client.listManagedWorkgroups((ListManagedWorkgroupsRequest)((Object)ListManagedWorkgroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

