/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lightcouch.CouchDbProperties;
import org.lightcouch.CouchDbUtil;

class CouchDbConfig {
    private static final Log log = LogFactory.getLog(CouchDbConfig.class);
    private static final String DEFAULT_FILE = "couchdb.properties";
    private Properties properties = new Properties();
    private String configFile;
    private CouchDbProperties dbProperties;

    public CouchDbConfig() {
        this(DEFAULT_FILE);
    }

    public CouchDbConfig(String configFile) {
        this.configFile = configFile;
        try {
            InputStream instream = CouchDbConfig.class.getClassLoader().getResourceAsStream(configFile);
            this.properties.load(instream);
        }
        catch (Exception e) {
            String msg = "Could not read configuration file from the classpath: " + configFile;
            log.error((Object)msg);
            throw new IllegalStateException(msg, e);
        }
        this.readProperties();
    }

    public CouchDbConfig(CouchDbProperties dbProperties) {
        CouchDbUtil.assertNotEmpty(dbProperties, "Properties");
        CouchDbUtil.assertNotEmpty(dbProperties.getDbName(), "Database");
        CouchDbUtil.assertNotEmpty(dbProperties.getProtocol(), "Protocol");
        CouchDbUtil.assertNotEmpty(dbProperties.getHost(), "Host");
        CouchDbUtil.assertNotEmpty(dbProperties.getPort(), "Port");
        this.dbProperties = dbProperties;
    }

    private void readProperties() {
        try {
            this.dbProperties = new CouchDbProperties();
            this.dbProperties.setDbName(this.getProperty("couchdb.name", true));
            this.dbProperties.setCreateDbIfNotExist(new Boolean(this.getProperty("couchdb.createdb.if-not-exist", true)));
            this.dbProperties.setProtocol(this.getProperty("couchdb.protocol", true));
            this.dbProperties.setHost(this.getProperty("couchdb.host", true));
            this.dbProperties.setPort(Integer.parseInt(this.getProperty("couchdb.port", true)));
            this.dbProperties.setUsername(this.getProperty("couchdb.username", true));
            this.dbProperties.setPassword(this.getProperty("couchdb.password", true));
            this.dbProperties.setPath(this.getProperty("couchdb.path", false));
            this.dbProperties.setSocketTimeout(this.getPropertyAsInt("couchdb.http.socket.timeout", false));
            this.dbProperties.setConnectionTimeout(this.getPropertyAsInt("couchdb.http.connection.timeout", false));
            this.dbProperties.setMaxConnections(this.getPropertyAsInt("couchdb.max.connections", false));
            this.dbProperties.setProxyHost(this.getProperty("couchdb.proxy.host", false));
            this.dbProperties.setProxyPort(this.getPropertyAsInt("couchdb.proxy.port", false));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.properties = null;
    }

    public CouchDbProperties getProperties() {
        return this.dbProperties;
    }

    private String getProperty(String key, boolean isRequired) {
        String property = this.properties.getProperty(key);
        if (property == null && isRequired) {
            String msg = String.format("A required property is missing. Key: %s, File: %s", key, this.configFile);
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return property != null && property.length() != 0 ? property.trim() : null;
    }

    private int getPropertyAsInt(String key, boolean isRequired) {
        String prop = this.getProperty(key, isRequired);
        return prop != null ? Integer.parseInt(prop) : 0;
    }
}

