/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.auth.Credentials;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.InstanceName;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@BetaApi(value="Channel priming is not currently stable and might change in the future")
class BigtableChannelPrimer
implements ChannelPrimer {
    private static Logger LOG = Logger.getLogger(BigtableChannelPrimer.class.toString());
    static final Metadata.Key<String> REQUEST_PARAMS = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final PingAndWarmRequest request;
    private final CallCredentials callCredentials;
    private final Map<String, String> headers;

    static BigtableChannelPrimer create(String projectId, String instanceId, String appProfileId, Credentials credentials, Map<String, String> headers) {
        return new BigtableChannelPrimer(projectId, instanceId, appProfileId, credentials, headers);
    }

    BigtableChannelPrimer(String projectId, String instanceId, String appProfileId, Credentials credentials, Map<String, String> headers) {
        this.callCredentials = credentials != null ? MoreCallCredentials.from((Credentials)credentials) : null;
        this.request = PingAndWarmRequest.newBuilder().setName(InstanceName.format((String)projectId, (String)instanceId)).setAppProfileId(appProfileId).build();
        this.headers = headers;
    }

    public void primeChannel(ManagedChannel managedChannel) {
        try {
            this.primeChannelUnsafe(managedChannel);
        }
        catch (IOException | RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected error while trying to prime a channel", e);
        }
    }

    private void primeChannelUnsafe(ManagedChannel managedChannel) throws IOException {
        this.sendPrimeRequests(managedChannel);
    }

    private void sendPrimeRequests(ManagedChannel managedChannel) {
        try {
            ClientCall clientCall = managedChannel.newCall(BigtableGrpc.getPingAndWarmMethod(), CallOptions.DEFAULT.withCallCredentials(this.callCredentials).withDeadline(Deadline.after((long)1L, (TimeUnit)TimeUnit.MINUTES)));
            final SettableApiFuture future = SettableApiFuture.create();
            clientCall.start((ClientCall.Listener)new ClientCall.Listener<PingAndWarmResponse>(){
                PingAndWarmResponse response;

                public void onMessage(PingAndWarmResponse message) {
                    this.response = message;
                }

                public void onClose(Status status, Metadata trailers) {
                    if (status.isOk()) {
                        future.set((Object)this.response);
                    } else {
                        future.setException((Throwable)status.asException());
                    }
                }
            }, BigtableChannelPrimer.createMetadata(this.headers, this.request));
            clientCall.sendMessage((Object)this.request);
            clientCall.halfClose();
            clientCall.request(Integer.MAX_VALUE);
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Failed to prime channel", e);
        }
    }

    private static Metadata createMetadata(Map<String, String> headers, PingAndWarmRequest request) {
        Metadata metadata = new Metadata();
        headers.forEach((k, v) -> metadata.put(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), v));
        try {
            metadata.put(REQUEST_PARAMS, (Object)String.format("name=%s&app_profile_id=%s", URLEncoder.encode(request.getName(), "UTF-8"), URLEncoder.encode(request.getAppProfileId(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "Failed to encode request params", e);
        }
        return metadata;
    }
}

