/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.ReaderFilter;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class UnicodeABAPStreamPutval
extends AbstractABAPStreamPutval {
    private Reader stream;

    public UnicodeABAPStreamPutval(ABAPStreamTranslator translator, char[] ca) {
        this(translator, new CharArrayReader(ca), -1L);
    }

    public UnicodeABAPStreamPutval(ABAPStreamTranslator translator, Reader stream, long length) {
        super(translator);
        this.stream = length >= 0L ? new ReaderFilter(stream, length) : stream;
        this.clearColumns();
        this.addColumn(0, 17, 2, 0, 1, 0);
    }

    public void transferStream(DataPart dataPart) throws SQLException {
        boolean streamExhausted = dataPart.fillWithOMSReader(this.stream, this.rowSize);
        if (streamExhausted) {
            try {
                this.stream.close();
            }
            catch (IOException ioex) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
            }
            this.stream = null;
        }
    }

    public boolean atEnd() {
        return this.stream == null;
    }
}

