/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AsciiStreamTranslator;
import com.sap.dbtech.jdbc.translators.BinaryStreamTranslator;
import com.sap.dbtech.jdbc.translators.BooleanTranslator;
import com.sap.dbtech.jdbc.translators.BytesTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.DateTranslator;
import com.sap.dbtech.jdbc.translators.InternalDateTranslator;
import com.sap.dbtech.jdbc.translators.InternalTimeTranslator;
import com.sap.dbtech.jdbc.translators.InternalTimestampTranslator;
import com.sap.dbtech.jdbc.translators.NumericTranslator;
import com.sap.dbtech.jdbc.translators.ProcedureStreamTranslator;
import com.sap.dbtech.jdbc.translators.SpaceoptionStringTranslator;
import com.sap.dbtech.jdbc.translators.SpaceoptionUnicodeStringTranslator;
import com.sap.dbtech.jdbc.translators.StringTranslator;
import com.sap.dbtech.jdbc.translators.StructureTranslator;
import com.sap.dbtech.jdbc.translators.TimeTranslator;
import com.sap.dbtech.jdbc.translators.TimestampTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeDateTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeInternalDateTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeInternalTimeTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeInternalTimestampTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeProcedureStreamTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeStreamTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeStringTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeTimeTranslator;
import com.sap.dbtech.jdbc.translators.UnicodeTimestampTranslator;
import com.sap.dbtech.jdbc.translators.VoidTranslator;
import java.sql.SQLException;

public abstract class TranslatorFactory {
    public static DBTechTranslator create(int mode, int ioType, int dataType, int frac, int len, int ioLen, int bufpos_in, int bufpos_out, boolean spaceoption, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean dateTimeFormatInternal) throws SQLException {
        DBTechTranslator result = null;
        switch (dataType) {
            case 2: 
            case 3: 
            case 31: 
            case 32: {
                if (spaceoption) {
                    result = new SpaceoptionStringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new StringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 4: {
                if (procParamInfo != null && procParamInfo.getType() == 2) {
                    result = new StructureTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, readOnly, autoIncre);
                    break;
                }
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 33: {
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 23: {
                result = new BooleanTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 11: {
                if (dateTimeFormatInternal) {
                    result = new InternalTimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new TimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 10: {
                if (dateTimeFormatInternal) {
                    result = new InternalDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new DateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 13: {
                if (dateTimeFormatInternal) {
                    result = new InternalTimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new TimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 0: 
            case 1: 
            case 12: 
            case 29: 
            case 30: {
                result = new NumericTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                if (isDBProcedure) {
                    result = new ProcedureStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new AsciiStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 8: 
            case 21: {
                if (isDBProcedure) {
                    result = new ProcedureStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new BinaryStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 24: 
            case 36: {
                if (spaceoption) {
                    result = new SpaceoptionUnicodeStringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeStringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 34: 
            case 35: {
                if (isDBProcedure) {
                    result = new UnicodeProcedureStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 38: {
                result = new ABAPStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 27: {
                result = new VoidTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            default: {
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
            }
        }
        return result;
    }

    public static DBTechTranslator createForUnicode(int mode, int ioType, int dataType, int frac, int len, int ioLen, int bufpos_in, int bufpos_out, boolean spaceoption, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean dateTimeFormatInternal) throws SQLException {
        DBTechTranslator result = null;
        switch (dataType) {
            case 2: 
            case 3: 
            case 31: 
            case 32: {
                if (spaceoption) {
                    result = new SpaceoptionUnicodeStringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeStringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 4: {
                if (procParamInfo != null && procParamInfo.getType() == 2) {
                    result = new StructureTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, true, readOnly, autoIncre);
                    break;
                }
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                if (isDBProcedure) {
                    result = new UnicodeProcedureStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 11: {
                if (dateTimeFormatInternal) {
                    result = new UnicodeInternalTimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeTimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 13: {
                if (dateTimeFormatInternal) {
                    result = new UnicodeInternalTimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeTimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 10: {
                if (dateTimeFormatInternal) {
                    result = new UnicodeInternalDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                    break;
                }
                result = new UnicodeDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 38: {
                result = new ABAPStreamTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, true, readOnly, autoIncre);
                break;
            }
            default: {
                result = TranslatorFactory.create(mode, ioType, dataType, frac, len, ioLen, bufpos_in, bufpos_out, spaceoption, isDBProcedure, procParamInfo, readOnly, autoIncre, dateTimeFormatInternal);
            }
        }
        return result;
    }
}

