/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.keyspaces.model;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import com.dbeaver.db.keyspaces.model.SigV4AuthProvider;
import com.dbeaver.model.security.StaticTLSUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AWSKeyspacesDataSource
extends CasDataSource {
    private static final String AWS_KEYSPACES_TLS_CERT_URL = "https://certs.secureserver.net/repository/sf-class2-root.crt";
    private static final String AWS_LOCAL_CONFIG_FOLDER = ".aws";
    private AuthModelAWSCredentials authCredentials;

    public AWSKeyspacesDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    protected ConsistencyLevel getDefaultConsistencyLevel() {
        return ConsistencyLevel.LOCAL_QUORUM;
    }

    protected void configureEndpoint(DBPConnectionConfiguration connectionInfo, CqlSessionBuilder builder) throws DBException {
        String regionId = connectionInfo.getHostName();
        if (!CommonUtils.isEmpty((String)regionId)) {
            try {
                builder.addContactPoint(new InetSocketAddress(InetAddress.getByName("cassandra." + regionId + ".amazonaws.com"), 9142));
                builder.withLocalDatacenter(regionId);
            }
            catch (UnknownHostException e) {
                throw new DBException("Error resolving keyspaces", (Throwable)e);
            }
        }
    }

    public boolean supportsPermissions() {
        return false;
    }

    protected void configureAuth(DBRProgressMonitor monitor, CqlSessionBuilder builder, DBPConnectionConfiguration connectionInfo) throws DBException {
        builder.withAuthProvider((AuthProvider)new SigV4AuthProvider(this.authCredentials.getAuthCredentialsProvider(monitor, connectionInfo), connectionInfo.getHostName()));
    }

    protected void configureSSL(DBRProgressMonitor monitor, CqlSessionBuilder builder) throws DBException {
        Path caCertFile = StaticTLSUtils.getStaticCertFile((DBRProgressMonitor)monitor, (Path)DBWorkbench.getPlatform().getWorkspace().getMetadataFolder(), fileName -> AWSKeyspacesDataSource.class.getClassLoader().getResourceAsStream("tls/" + fileName), (String)AWS_LOCAL_CONFIG_FOLDER, (String)AWS_KEYSPACES_TLS_CERT_URL);
        if (caCertFile != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                DBACertificateStorage securityManager = DBWorkbench.getPlatform().getCertificateStorage();
                securityManager.addCertificate(this.getContainer(), "ssl", Files.readAllBytes(caCertFile), null, null);
                KeyStore trustStore = securityManager.getKeyStore(this.getContainer(), "ssl");
                char[] keyStorePass = securityManager.getKeyStorePassword(this.getContainer(), "ssl");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(trustStore, keyStorePass);
                keyManagerFactory.getKeyManagers();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                trustManagerFactory.init(trustStore);
                trustManagerFactory.getTrustManagers();
                sslContext.init(null, null, new SecureRandom());
                this.configureSslWithOptions(builder, sslContext);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
                throw new DBException("Error configuring Keyspaces trust store");
            }
        }
    }

    void setAuthCredentials(AuthModelAWSCredentials crdentials) {
        this.authCredentials = crdentials;
    }

    @NotNull
    protected CasExecutionContext createExecutionContext(String purpose, String keyspaceName) {
        return super.createExecutionContext(purpose, keyspaceName);
    }
}

