/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.model;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.model.RedisDataSource;
import com.dbeaver.db.redis.model.RedisKey;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.cache.ListCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class RedisDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPSystemObject,
DBPObjectStatistics {
    private static final Log log = Log.getLog(RedisDatabase.class);
    private final RedisDataSource dataSource;
    private final String dbName;
    private long keyNumber;
    private boolean persisted;
    private ListCache<RedisDatabase, RedisKey> keyList;
    private List<RedisKey> keyTree;
    private int id;

    public RedisDatabase(RedisDataSource dataSource, String dbName, long keyNumber) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        this.keyNumber = keyNumber;
        if (this.dbName.startsWith("db")) {
            try {
                this.id = Integer.parseInt(this.dbName.substring(2));
            }
            catch (Exception e) {
                log.error((Object)"Can't extract DB id", (Throwable)e);
            }
        } else {
            this.id = 0;
        }
        this.persisted = true;
    }

    public DBSObjectCache<RedisDatabase, RedisKey> getKeyCache() {
        return this.keyList;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public List<RedisKey> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getKeyList(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (DBSObject)DBUtils.findObject(this.getKeyList(monitor), (String)childName);
    }

    @NotNull
    public Class<RedisKey> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return RedisKey.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return false;
    }

    @Association
    public List<RedisKey> getKeyList(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.keyList == null) {
            if (monitor.isCanceled() || monitor.isForceCacheUsage()) {
                return null;
            }
            String keyFilterString = this.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-redis.key.filters");
            Set<String> keyFilters = RedisUtils.parseKeyFilterString(keyFilterString);
            keyFilters = keyFilters.stream().map(SQLUtils::makeGlobFromSqlLikePattern).collect(Collectors.toSet());
            this.keyList = new ListCache(RedisUtils.getKeys(monitor, this, null, keyFilters, false));
        }
        return this.keyList.getCachedObjects();
    }

    @Association
    public List<RedisKey> getKeyTree(DBRProgressMonitor monitor) throws DBCException {
        if (this.keyTree == null) {
            this.keyTree = RedisUtils.getKeys(monitor, this, null, null, true);
        }
        return this.keyTree;
    }

    public boolean hasStatistics() {
        return true;
    }

    @Property(hidden=true, formatter=DecimalFormat.class)
    public long getStatObjectSize() {
        return this.keyNumber;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

