/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisDataSource;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisDeploymentType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisSentineled;

public class RedisExecutionContext
extends AbstractExecutionContext<RedisDataSource>
implements DBCExecutionContextDefaults<RedisDatabase, DBSSchema> {
    private Integer defaultDatabase;

    public RedisExecutionContext(RedisDataSource dataSource, String purpose, Integer defaultDatabase) {
        super((DBPDataSource)dataSource, purpose);
        this.defaultDatabase = defaultDatabase;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((RedisDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open redis session");
                super.initContextBootstrap(monitor, true);
                ((RedisDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((RedisDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public RedisSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new RedisSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            switch (((RedisDataSource)this.dataSource).getDeploymentType()) {
                case SENTINEL: {
                    Throwable throwable = null;
                    Object var3_7 = null;
                    try (JedisSentineled jedisSentineled = ((RedisDataSource)this.dataSource).acquireCommands(JedisSentineled.class);){
                        jedisSentineled.ping();
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                case CLUSTER: {
                    Throwable throwable = null;
                    Object var3_9 = null;
                    try (JedisCluster cmd = ((RedisDataSource)this.dataSource).acquireCommands(JedisCluster.class);){
                        cmd.getClusterNodes();
                        break;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                case STANDALONE: {
                    ((RedisDataSource)this.dataSource).getJedis().ping();
                }
            }
        }
        catch (Throwable e) {
            throw new DBException("Error pinging Redis", e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (Jedis client = ((RedisDataSource)this.dataSource).getJedis();){
                    client.ping("Invalidate");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RedisExecutionContext redisExecutionContext = this;
        synchronized (redisExecutionContext) {
            ((RedisDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    public Integer getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(Integer defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public RedisDatabase getDefaultCatalog() {
        for (RedisDatabase db : ((RedisDataSource)this.getDataSource()).getDatabases()) {
            if (this.defaultDatabase == null || db.getId() != this.defaultDatabase.intValue()) continue;
            return db;
        }
        return null;
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, RedisDatabase catalog, DBSSchema schema) throws DBCException {
        RedisDatabase oldSelectedDB = this.getDefaultCatalog();
        if (oldSelectedDB == catalog) {
            return;
        }
        if (!RedisDeploymentType.CLUSTER.equals((Object)((RedisDataSource)this.dataSource).getDeploymentType())) {
            Jedis commands = ((RedisDataSource)this.getDataSource()).getJedis();
            commands.select(catalog.getId());
            this.defaultDatabase = catalog.getId();
        }
        if (oldSelectedDB != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedDB, (boolean)false, (DBCExecutionContext)this);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        this.defaultDatabase = this.getDefaultDatabase();
        return true;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        String catalogName = this.getDefaultCatalog() != null ? this.getDefaultCatalog().getName() : null;
        return new DBCCachedContextDefaults(catalogName, null);
    }
}

