/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.auth;

import com.dbeaver.db.redis.auth.RedisCredentials;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.utils.CommonUtils;

public class RedisMultiPasswordAuthModel
extends AuthModelDatabaseNative<RedisCredentials> {
    @NotNull
    public RedisCredentials createCredentials() {
        return new RedisCredentials();
    }

    protected void loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, RedisCredentials credentials) {
        super.loadCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        credentials.setNodePassword(CommonUtils.notEmpty((String)configuration.getAuthProperty("redis.sentinel.master.password")));
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull RedisCredentials credentials) {
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        configuration.setAuthProperty("redis.sentinel.master.password", credentials.getNodePassword());
    }
}

