/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.ui.views;

import com.dbeaver.db.sqlite.ui.internal.SQLiteUIMessages;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class SQLiteExtensionsPage
extends ConnectionPageAbstract {
    private List extensionsList;

    public SQLiteExtensionsPage() {
        this.setTitle(SQLiteUIMessages.page_extensions_title);
        this.setDescription(SQLiteUIMessages.page_extensions_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.extensionsList = new List(composite, 2820);
        this.extensionsList.setLayoutData((Object)new GridData(1808));
        ToolBar toolbar = new ToolBar(composite, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)SQLiteUIMessages.page_extensions_toolbar_add, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SQLiteExtensionsPage.this.getShell(), 4098);
                dialog.setText(SQLiteUIMessages.page_extensions_chooser_title);
                dialog.setFilterExtensions(new String[]{"*.dll;*.dylib;*.so"});
                dialog.setFilterNames(new String[]{SQLiteUIMessages.page_extensions_chooser_name});
                if (dialog.open() != null) {
                    String[] stringArray = dialog.getFileNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        String path = dialog.getFilterPath() + File.separator + name;
                        if (SQLiteExtensionsPage.this.extensionsList.indexOf(path) < 0) {
                            SQLiteExtensionsPage.this.extensionsList.add(path);
                        }
                        ++n2;
                    }
                }
            }
        });
        final ToolItem removeItem = UIUtils.createToolItem((ToolBar)toolbar, (String)SQLiteUIMessages.page_extensions_toolbar_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SQLiteExtensionsPage.this.extensionsList.getSelectionIndex();
                SQLiteExtensionsPage.this.extensionsList.remove(index);
                SQLiteExtensionsPage.this.extensionsList.select(CommonUtils.clamp((int)index, (int)0, (int)(SQLiteExtensionsPage.this.extensionsList.getItemCount() - 1)));
                SQLiteExtensionsPage.this.extensionsList.notifyListeners(13, new Event());
            }
        });
        removeItem.setEnabled(false);
        this.extensionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                removeItem.setEnabled(SQLiteExtensionsPage.this.extensionsList.getItemCount() > 0);
            }
        });
        UIUtils.createInfoLabel((Composite)composite, (String)SQLiteUIMessages.page_extensions_tip, (int)768, (int)2);
        this.loadSettings();
        this.setControl((Control)composite);
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        String extensions = configuration.getProviderProperty("sqlite-extensions");
        if (CommonUtils.isNotEmpty((String)extensions)) {
            String[] stringArray = extensions.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                this.extensionsList.add(extension);
                ++n2;
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        String extensions = String.join((CharSequence)File.pathSeparator, this.extensionsList.getItems());
        configuration.setProviderProperty("sqlite-extensions", extensions);
    }

    public boolean isComplete() {
        return true;
    }
}

