/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.ortho;

import com.dbeaver.ui.editors.erd.ortho.OrthoPath;
import com.dbeaver.ui.editors.erd.ortho.OrthoPathUtils;
import com.dbeaver.ui.editors.erd.ortho.RouteLine;
import com.dbeaver.ui.editors.erd.ortho.RouteRectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;

public class OrthogonalRouter {
    private static final int INDENTATION_END = 50;
    private static final int INDENTATION_START = 4;
    private Log log = Log.getLog((String)OrthogonalRouter.class.getName());
    private static final double INDENTATION_DEFAULT = 35.0;
    private static final int INTERSECTION_LINE_SPACING = 10;
    private static final int LINE_SPACING_VERTICAL = 10;
    private static final int LINE_SPACING_HORIZONTAL = 10;
    private static final int LINE_SPACING_VERTICAL_DEFAULT = 15;
    private static final int ENTITY_OFFSET = 35;
    private static final int ENTITY_DEFORMATED_OFFSET = 10;
    private static final int MAX_RESOLVE_ITERATION_VERTICAL = 5;
    private static final int MAX_RESOLVE_ITERATION_HORIZONTAL = 5;
    private static final int MAX_RESOLVE_INTERSECTION_ITERATION = 7;
    private int lineSpacing;
    private int spacing = 10;
    private List<OrthoPath> orderedPaths;
    private Map<OrthoPath, List<OrthoPath>> pathsToChildPaths;
    private List<RouteRectangle> userObstacles;
    private List<OrthoPath> userPaths = new ArrayList<OrthoPath>();
    private List<OrthoPath> workingPaths = new ArrayList<OrthoPath>();

    public OrthogonalRouter() {
        this.pathsToChildPaths = new HashMap<OrthoPath, List<OrthoPath>>();
        this.userObstacles = new ArrayList<RouteRectangle>();
        this.orderedPaths = new ArrayList<OrthoPath>();
    }

    public void addObstacle(Rectangle rect) {
        this.internalAddObstacle(new RouteRectangle(rect));
    }

    public void addPath(OrthoPath path) {
        this.userPaths.add(path);
        this.workingPaths.add(path);
    }

    private void bendPaths() {
        int i = 0;
        while (i < this.orderedPaths.size()) {
            OrthoPath path = this.orderedPaths.get(i);
            path.points.addPoint(new Point(path.getStart().x, path.getStart().y));
            path.points.addPoint(new Point(path.getEnd().x, path.getEnd().y));
            ++i;
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    private void internalAddObstacle(RouteRectangle obs) {
        this.userObstacles.add(obs);
    }

    private void orderPath(OrthoPath path) {
        this.orderedPaths.add(path);
    }

    private void orderPaths() {
        this.orderedPaths = new ArrayList<OrthoPath>();
        int i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            this.orderPath(path);
            ++i;
        }
    }

    private void recombineChildrenPaths() {
        for (OrthoPath path : this.pathsToChildPaths.keySet()) {
            path.fullReset();
            List<OrthoPath> childPaths = this.pathsToChildPaths.get(path);
            OrthoPath childPath = null;
            int i = 0;
            while (i < childPaths.size()) {
                childPath = childPaths.get(i);
                path.points.addAll(childPath.getPoints());
                path.points.removePoint(path.points.size() - 1);
                ++i;
            }
            path.points.addPoint(childPath.points.getLastPoint());
        }
    }

    public void removeObstacle(Rectangle rect) {
        RouteRectangle obs = null;
        int index = -1;
        int i = 0;
        while (i < this.userObstacles.size()) {
            obs = this.userObstacles.get(i);
            if (obs.equals(rect)) {
                index = i;
                break;
            }
            ++i;
        }
        this.userObstacles.remove(index);
    }

    public boolean removePath(OrthoPath path) {
        this.userPaths.remove(path);
        List<OrthoPath> children = this.pathsToChildPaths.get(path);
        if (children == null) {
            this.workingPaths.remove(path);
        } else {
            this.workingPaths.removeAll(children);
        }
        return true;
    }

    private void resetVertices() {
        int i = 0;
        while (i < this.userObstacles.size()) {
            RouteRectangle obs = this.userObstacles.get(i);
            obs.reset();
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            OrthoPath path = this.workingPaths.get(i);
            path.getStart().fullReset();
            path.getEnd().fullReset();
            ++i;
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public List<OrthoPath> solve() {
        this.solveDirtyPaths();
        this.orderPaths();
        this.bendPaths();
        this.recombineChildrenPaths();
        this.joinObstacles();
        this.computeOrthoPath();
        return Collections.unmodifiableList(this.userPaths);
    }

    private void computeOrthoPath() {
        for (OrthoPath path : Collections.unmodifiableList(this.userPaths)) {
            PointList points = this.computeRoutePoints(path);
            path.setPoints(points);
        }
    }

    @NotNull
    private PointList computeRoutePoints(@NotNull OrthoPath path) {
        RouteLine trgDistanceLine;
        this.lineSpacing = 15;
        Connection connection = path.getConnection();
        path.removeTraceLines();
        PointList resolvedRoutePoints = new PointList();
        IFigure srcOwner = connection.getSourceAnchor().getOwner();
        if (srcOwner == null) {
            return resolvedRoutePoints;
        }
        IFigure trgOwner = connection.getTargetAnchor().getOwner();
        if (trgOwner == null) {
            return resolvedRoutePoints;
        }
        PointList points = path.getPoints().getCopy();
        Rectangle srcBounds = srcOwner.getBounds().getCopy();
        Rectangle trgBounds = trgOwner.getBounds().getCopy();
        RouteRectangle vrSource = new RouteRectangle(srcBounds);
        RouteRectangle vrTarget = new RouteRectangle(trgBounds);
        Point start = this.getStartPoint(connection, points);
        Point end = this.getEndPoint(connection, points);
        OrthoPathUtils.OrthoPathDirection directionByY = OrthoPathUtils.getDirectionByY(srcOwner, trgOwner);
        OrthoPathUtils.OrthoPathDirection directionByX = OrthoPathUtils.getDirectionByX(srcBounds, trgBounds);
        boolean isEnoughtDist = OrthoPathUtils.isEnoughtDistance(srcBounds, trgBounds);
        OrthoPathUtils.OrthoPathDirection directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
        OrthoPathUtils.OrthoPathDirection directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
        if (directionByY == OrthoPathUtils.OrthoPathDirection.UP && directionByX == OrthoPathUtils.OrthoPathDirection.RIGHT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
                start = vrSource.centerRight;
                end = vrTarget.centerLeft;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerRight;
                end = vrTarget.centerRight;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.UP && directionByX == OrthoPathUtils.OrthoPathDirection.LEFT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerLeft;
                end = vrTarget.centerRight;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerRight;
                end = vrTarget.centerRight;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.UP && directionByX == OrthoPathUtils.OrthoPathDirection.NONE) {
            directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
            directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
            start = vrSource.centerRight;
            end = vrTarget.centerRight;
        }
        if (directionByY == OrthoPathUtils.OrthoPathDirection.DOWN && directionByX == OrthoPathUtils.OrthoPathDirection.RIGHT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
                start = vrSource.centerRight;
                end = vrTarget.centerLeft;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerRight;
                end = vrTarget.centerRight;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.DOWN && directionByX == OrthoPathUtils.OrthoPathDirection.LEFT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerLeft;
                end = vrTarget.centerRight;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerRight;
                end = vrTarget.centerRight;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.DOWN && directionByX == OrthoPathUtils.OrthoPathDirection.NONE) {
            directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
            directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
            start = vrSource.centerRight;
            end = vrTarget.centerRight;
        }
        if (directionByY == OrthoPathUtils.OrthoPathDirection.NONE && directionByX == OrthoPathUtils.OrthoPathDirection.RIGHT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
                start = vrSource.centerRight;
                end = vrTarget.centerLeft;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerLeft;
                end = vrTarget.centerRight;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.NONE && directionByX == OrthoPathUtils.OrthoPathDirection.LEFT) {
            if (isEnoughtDist) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerLeft;
                end = vrTarget.centerRight;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
                start = vrSource.centerRight;
                end = vrTarget.centerLeft;
            }
        } else if (directionByY == OrthoPathUtils.OrthoPathDirection.NONE && directionByX == OrthoPathUtils.OrthoPathDirection.NONE) {
            directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
            directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
            start = vrSource.centerRight;
            end = vrTarget.centerRight;
        }
        RouteLine sourceDistanceLine = new RouteLine(new Point(start.x + (int)(Math.cos(Math.toRadians(directionSrcToTrg.getDirection())) * 4.0), start.y - (int)(Math.sin(Math.toRadians(directionSrcToTrg.getDirection())) * 4.0)), new Point(start.x + (int)(Math.cos(Math.toRadians(directionSrcToTrg.getDirection())) * 50.0), start.y - (int)(Math.sin(Math.toRadians(directionSrcToTrg.getDirection())) * 50.0)));
        if (this.isRouteIntersectEntity(OrthoPathUtils.toPointList(sourceDistanceLine), this.getObstacles(), false)) {
            if (start.equals((Object)vrSource.centerRight)) {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.LEFT;
                start = vrSource.centerLeft;
            } else {
                directionSrcToTrg = OrthoPathUtils.OrthoPathDirection.RIGHT;
                start = vrSource.centerRight;
            }
        }
        if (this.isRouteIntersectEntity(OrthoPathUtils.toPointList(trgDistanceLine = new RouteLine(new Point(end.x + (int)(Math.cos(Math.toRadians(directionTrgToSrc.getDirection())) * 4.0), end.y - (int)(Math.sin(Math.toRadians(directionTrgToSrc.getDirection())) * 4.0)), new Point(end.x + (int)(Math.cos(Math.toRadians(directionTrgToSrc.getDirection())) * 50.0), end.y - (int)(Math.sin(Math.toRadians(directionTrgToSrc.getDirection())) * 50.0)))), this.getObstacles(), false)) {
            if (end.equals((Object)vrTarget.centerRight)) {
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.LEFT;
                end = vrTarget.centerLeft;
            } else {
                directionTrgToSrc = OrthoPathUtils.OrthoPathDirection.RIGHT;
                end = vrTarget.centerRight;
            }
        }
        PointList modifiedPoints = new PointList();
        modifiedPoints.addPoint(start);
        int dx1 = (int)(Math.cos(Math.toRadians(directionSrcToTrg.getDirection())) * 35.0);
        int dy1 = (int)(Math.sin(Math.toRadians(directionSrcToTrg.getDirection())) * 35.0);
        int dx2 = (int)(Math.cos(Math.toRadians(directionTrgToSrc.getDirection())) * 35.0);
        int dy2 = (int)(Math.sin(Math.toRadians(directionTrgToSrc.getDirection())) * 35.0);
        modifiedPoints.addPoint(new Point(start.x + dx1, start.y - dy1));
        int i = 1;
        while (i < points.size() - 1) {
            modifiedPoints.addPoint(points.getPoint(i));
            ++i;
        }
        modifiedPoints.addPoint(new Point(end.x + dx2, end.y - dy2));
        modifiedPoints.addPoint(end);
        PointList intermediate = new PointList();
        int i2 = 1;
        while (i2 < modifiedPoints.size() - 1) {
            intermediate.addPoint(modifiedPoints.getPoint(i2));
            ++i2;
        }
        resolvedRoutePoints = OrthoPathUtils.calcOrthoRoutePoints(intermediate, directionSrcToTrg.getDirection());
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveIntersections(resolvedRoutePoints, this.getObstacles());
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveOverlappingRouteSegmentsHorizontally(resolvedRoutePoints, path);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveOverlappingRouteSegmentsVertically(resolvedRoutePoints, path);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveIntersections(resolvedRoutePoints, this.getObstacles());
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.combineRoutePoints(start, end, resolvedRoutePoints);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        return resolvedRoutePoints;
    }

    @NotNull
    private PointList combineRoutePoints(@NotNull Point start, @NotNull Point end, @NotNull PointList resolvedRoutePoints) {
        PointList resultPointList = new PointList();
        resultPointList.addPoint(start);
        resultPointList.addAll(resolvedRoutePoints);
        resultPointList.addPoint(end);
        return resultPointList;
    }

    private Point getStartPoint(@NotNull Connection currentConnection, @NotNull PointList points) {
        PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(0));
        currentConnection.translateToAbsolute((Translatable)ref1);
        Point start = currentConnection.getSourceAnchor().getLocation((Point)ref1).getCopy();
        currentConnection.translateToRelative((Translatable)start);
        return start;
    }

    private Point getEndPoint(@NotNull Connection currentConnection, @NotNull PointList points) {
        PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
        currentConnection.translateToAbsolute((Translatable)ref2);
        Point end = currentConnection.getTargetAnchor().getLocation((Point)ref2).getCopy();
        currentConnection.translateToRelative((Translatable)end);
        return end;
    }

    @NotNull
    private PointList resolveExtraRoutePoints(@NotNull PointList orginalPointList) {
        PointList routePointList = this.cutExtraPoints(orginalPointList);
        PointList nextRoutePointList = this.cutExtraPoints(routePointList);
        if (routePointList.size() != nextRoutePointList.size()) {
            this.resolveExtraRoutePoints(nextRoutePointList);
        }
        List<RouteLine> routeLines = OrthoPathUtils.toRouteLines(nextRoutePointList);
        List<Point> listPoint = OrthoPathUtils.toListPoint(nextRoutePointList);
        ArrayList nonOrtho = new ArrayList();
        routeLines.forEach(l -> {
            if (!l.isOrthoLine()) {
                nonOrtho.add(l.getFirst());
            }
        });
        int j = 0;
        while (j < nonOrtho.size()) {
            listPoint.remove(nonOrtho.get(j));
            ++j;
        }
        return OrthoPathUtils.toPointList(listPoint);
    }

    @NotNull
    private PointList cutExtraPoints(@NotNull PointList routePointList) {
        LinkedHashSet<Point> uniquePoints = new LinkedHashSet<Point>();
        int j = 0;
        while (j < routePointList.size()) {
            uniquePoints.add(routePointList.getPoint(j));
            ++j;
        }
        PointList pointList = OrthoPathUtils.toPointList(uniquePoints);
        if (uniquePoints.size() < 2) {
            return pointList;
        }
        int j2 = 2;
        while (j2 < pointList.size()) {
            Point pointA = pointList.getPoint(j2 - 2);
            Point pointB = pointList.getPoint(j2 - 1);
            Point pointC = pointList.getPoint(j2);
            if (pointA.x == pointB.x && pointA.x == pointC.x) {
                if (pointB.y < pointA.y && pointB.y < pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointB.y > pointA.y && pointB.y > pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointA.y < pointB.y && pointB.y < pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointC.y < pointB.y && pointB.y < pointA.y) {
                    pointList.removePoint(j2 - 1);
                }
            }
            if (pointA.y == pointB.y && pointA.y == pointC.y) {
                if (pointB.x < pointA.x && pointB.x < pointC.x || pointB.x > pointA.x && pointB.x > pointC.x) {
                    pointList.removePoint(j2 - 1);
                } else if (pointA.x < pointB.x && pointB.x < pointC.x) {
                    pointList.removePoint(j2 - 1);
                } else if (pointC.x < pointB.x && pointB.x < pointA.x) {
                    pointList.removePoint(j2 - 1);
                }
            }
            ++j2;
        }
        return pointList;
    }

    private PointList resolveIntersections(@NotNull PointList routePoints, @NotNull List<RouteRectangle> userObstacles) {
        int iterationCounter = 0;
        while (iterationCounter < 7) {
            if (!this.isRouteIntersectEntity(routePoints, userObstacles, true)) {
                return routePoints;
            }
            routePoints = this.resolveExtraRoutePoints(this.createRouteArroundOfEntities(routePoints, userObstacles));
            ++iterationCounter;
        }
        return routePoints;
    }

    private boolean isRouteIntersectEntity(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles, boolean deformate) {
        for (RouteRectangle entity : userObstacles) {
            RouteRectangle rr = deformate ? this.getDeformedRectangle(entity, 10) : entity;
            int j = 1;
            while (j < routePointList.size()) {
                Point pointB;
                Point pointA = routePointList.getPoint(j - 1);
                RouteLine line = new RouteLine(pointA, pointB = routePointList.getPoint(j));
                if (OrthoPathUtils.isIntersects(line, rr)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    @NotNull
    private RouteRectangle getDeformedRectangle(@NotNull RouteRectangle r, int extraOffset) {
        int offset = extraOffset * 2;
        Rectangle rect = new Rectangle(r.x - extraOffset, r.y - extraOffset, r.width + offset, r.height + offset);
        return new RouteRectangle(rect);
    }

    private PointList createRouteArroundOfEntities(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles) {
        Map<Integer, PointList> intersection = this.getPositionPointsArroundOfEntity(routePointList, userObstacles);
        int position = 0;
        for (Map.Entry<Integer, PointList> entry : intersection.entrySet()) {
            position += entry.getKey().intValue();
            PointList points = entry.getValue();
            int j = 0;
            while (j < points.size()) {
                Point p = points.getPoint(j);
                if (routePointList.size() - 1 >= position) {
                    routePointList.insertPoint(p, position++);
                }
                ++j;
            }
        }
        return routePointList;
    }

    @NotNull
    private Map<Integer, PointList> getPositionPointsArroundOfEntity(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles) {
        LinkedHashMap<Integer, PointList> pointAround = new LinkedHashMap<Integer, PointList>();
        for (RouteRectangle entity : userObstacles) {
            int j = 1;
            while (j < routePointList.size()) {
                Point pointA = routePointList.getPoint(j - 1);
                Point pointB = routePointList.getPoint(j);
                RouteLine line = new RouteLine(pointA, pointB);
                RouteLine nextLine = null;
                if (j + 1 < routePointList.size()) {
                    Point pointC = routePointList.getPoint(j + 1);
                    nextLine = new RouteLine(pointB, pointC);
                }
                if (OrthoPathUtils.isIntersects(line, entity)) {
                    PointList pointsAroundEntity = this.computePointsAroundEntity(line, entity, nextLine);
                    pointAround.put(j, pointsAroundEntity);
                    return pointAround;
                }
                ++j;
            }
        }
        return pointAround;
    }

    private PointList resolveOverlappingRouteSegmentsHorizontally(PointList originalPoints, @NotNull OrthoPath path) {
        PointList resolvedPoints = originalPoints;
        int iterationCounter = 0;
        while (iterationCounter < 5) {
            List<RouteLine> intersectionLines = this.getHorzIntersections(resolvedPoints, path);
            if (intersectionLines.isEmpty()) {
                return resolvedPoints;
            }
            if (intersectionLines.isEmpty()) {
                return resolvedPoints;
            }
            resolvedPoints = this.resolveHorizontalIntersections(resolvedPoints, intersectionLines);
            ++iterationCounter;
        }
        return resolvedPoints;
    }

    @NotNull
    private PointList resolveHorizontalIntersections(@NotNull PointList originalPoints, @NotNull List<RouteLine> intersectionLines) {
        List<RouteLine> routerLines = OrthoPathUtils.toRouteLines(originalPoints);
        int index = 1;
        while (index < routerLines.size() - 2) {
            RouteLine routeLine = routerLines.get(index);
            this.lineSpacing = 10;
            for (RouteLine interSectionLine : intersectionLines) {
                if (!routeLine.equals(interSectionLine)) continue;
                routeLine.getFirst().y += 10;
                routeLine.getLast().y += 10;
                this.lineSpacing += 10;
                break;
            }
            ++index;
        }
        return OrthoPathUtils.toPointList(routerLines);
    }

    @NotNull
    private List<RouteLine> getHorzIntersections(@NotNull PointList originalPoints, @NotNull OrthoPath path) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (OrthoPath entry : this.userPaths) {
            if (entry.equals(path)) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesHorizontally(originalPoints, entry.getPoints()));
        }
        return intersectionLines;
    }

    @NotNull
    private List<RouteLine> getVerticalIntersections(@NotNull PointList originalPoints, @NotNull OrthoPath path) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (OrthoPath entry : this.userPaths) {
            if (entry.equals(path)) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesVertically(originalPoints, entry.getPoints()));
        }
        return intersectionLines;
    }

    @NotNull
    private List<RouteLine> detectOverlappingRouteLinesHorizontally(@NotNull PointList orthoPoints, @NotNull PointList connectionPoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < orthoPoints.size()) {
            Point pointA = orthoPoints.getPoint(j - 1);
            Point pointB = orthoPoints.getPoint(j);
            int i = 1;
            while (i < connectionPoints.size()) {
                Point pointC = connectionPoints.getPoint(i - 1);
                Point pointD = connectionPoints.getPoint(i);
                RouteLine intersectionLine = this.getIntersectionsHorizontally(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    @NotNull
    private List<RouteLine> detectOverlappingRouteLinesVertically(@NotNull PointList originalPoints, @NotNull PointList routePoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < originalPoints.size()) {
            Point pointA = originalPoints.getPoint(j - 1);
            Point pointB = originalPoints.getPoint(j);
            int i = 1;
            while (i < routePoints.size()) {
                Point pointC = routePoints.getPoint(i - 1);
                Point pointD = routePoints.getPoint(i);
                RouteLine intersectionLine = this.getIntersectionsVertically(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                    lines.add(new RouteLine(pointC, pointD));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    @Nullable
    private RouteLine getIntersectionsVertically(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(x1 - x3) < 10 && Math.abs(x2 - x4) < 10) {
            int lineABottom = 0;
            int lineATop = 0;
            int lineBBottom = 0;
            int lineBTop = 0;
            if (y1 > y2) {
                lineABottom = y1;
                lineATop = y2;
            } else {
                lineABottom = y2;
                lineATop = y1;
            }
            if (y3 > y4) {
                lineBTop = y4;
                lineBBottom = y3;
            } else {
                lineBTop = y3;
                lineBBottom = y4;
            }
            if (lineABottom == lineBBottom && lineATop == lineBTop && lineABottom == lineATop) {
                return null;
            }
            if (lineBBottom == lineBTop || lineABottom == lineATop) {
                return null;
            }
            if (lineATop == lineBTop && lineABottom == lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineATop < lineBTop && lineABottom < lineBBottom && lineABottom > lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineBBottom < lineABottom && lineBBottom > lineATop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom > lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineABottom == lineBBottom && lineATop < lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineABottom == lineBBottom && lineATop > lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    @Nullable
    private RouteLine getIntersectionsHorizontally(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(y1 - y3) < 10 && Math.abs(y2 - y4) < 10) {
            int lineARight = 0;
            int lineALeft = 0;
            int lineBRight = 0;
            int lineBLeft = 0;
            if (x1 > x2) {
                lineARight = x1;
                lineALeft = x2;
            } else {
                lineARight = x2;
                lineALeft = x1;
            }
            if (x3 > x4) {
                lineBRight = x3;
                lineBLeft = x4;
            } else {
                lineBRight = x4;
                lineBLeft = x3;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft && lineARight == lineBLeft) {
                return null;
            }
            if (lineBLeft == lineBRight || lineALeft == lineARight) {
                return null;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight > lineARight && lineALeft > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineARight > lineBLeft && lineARight < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft > lineBLeft && lineALeft < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight >= lineARight && lineBLeft > lineALeft && lineBLeft < lineARight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft == lineBLeft && lineARight > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    @NotNull
    private PointList computePointsAroundEntity(@NotNull RouteLine line, @NotNull RouteRectangle entity, @Nullable RouteLine nextLine) {
        RouteRectangle obstacle = this.getDeformedRectangle(entity, 35);
        entity = this.getDeformedRectangle(entity, 10);
        PointList aroundEntity = new PointList();
        PointList entityTopLine = new PointList();
        entityTopLine.addPoint(entity.getTopLeft());
        entityTopLine.addPoint(entity.getTopRight());
        PointList entityBottomLine = new PointList();
        entityBottomLine.addPoint(entity.getBottomLeft());
        entityBottomLine.addPoint(entity.getBottomRight());
        PointList entityRightLine = new PointList();
        entityRightLine.addPoint(entity.getTopRight());
        entityRightLine.addPoint(entity.getBottomRight());
        PointList entityLeftLine = new PointList();
        entityLeftLine.addPoint(entity.getTopLeft());
        entityLeftLine.addPoint(entity.getBottomLeft());
        PointList lineCenterToLeftTopLine = new PointList();
        lineCenterToLeftTopLine.addPoint(entity.getCenter());
        lineCenterToLeftTopLine.addPoint(entity.getTopLeft());
        PointList lineCenterToRightTopLine = new PointList();
        lineCenterToRightTopLine.addPoint(entity.getCenter());
        lineCenterToRightTopLine.addPoint(entity.getTopRight());
        PointList lineCenterToLeftBottomLine = new PointList();
        lineCenterToLeftBottomLine.addPoint(entity.getCenter());
        lineCenterToLeftBottomLine.addPoint(entity.getBottomLeft());
        PointList lineCenterToRightBottomLine = new PointList();
        lineCenterToRightBottomLine.addPoint(entity.getCenter());
        lineCenterToRightBottomLine.addPoint(entity.getBottomRight());
        PointList nextLineIntersectByTop = new PointList();
        PointList nextLineIntersectByBottom = new PointList();
        PointList nextLineIntersectByLeft = new PointList();
        PointList nextLineIntersectByRight = new PointList();
        if (nextLine != null) {
            nextLineIntersectByTop = OrthoPathUtils.detectIntesections(nextLine, entityTopLine);
            nextLineIntersectByBottom = OrthoPathUtils.detectIntesections(nextLine, entityBottomLine);
            nextLineIntersectByLeft = OrthoPathUtils.detectIntesections(nextLine, entityLeftLine);
            nextLineIntersectByRight = OrthoPathUtils.detectIntesections(nextLine, entityRightLine);
        }
        PointList frstLineIntersectByLeft = OrthoPathUtils.detectIntesections(line, entityLeftLine);
        PointList frstLineIntersectByRight = OrthoPathUtils.detectIntesections(line, entityRightLine);
        PointList frstLineIntersectByBottom = OrthoPathUtils.detectIntesections(line, entityBottomLine);
        PointList frstLineIntersectByTop = OrthoPathUtils.detectIntesections(line, entityTopLine);
        if (this.isCornerIntersection(nextLineIntersectByTop, nextLineIntersectByBottom, nextLineIntersectByLeft, nextLineIntersectByRight)) {
            aroundEntity = this.getPointsAroundCornerSegment(line, obstacle, nextLineIntersectByTop, nextLineIntersectByBottom, nextLineIntersectByLeft, nextLineIntersectByRight, frstLineIntersectByLeft, frstLineIntersectByRight, frstLineIntersectByTop, frstLineIntersectByBottom);
        } else {
            PointList frstLineIntersectCenterToLeftTop = OrthoPathUtils.detectIntesections(line, lineCenterToLeftTopLine);
            PointList frstLineIntersectCenterToLeftBottom = OrthoPathUtils.detectIntesections(line, lineCenterToLeftBottomLine);
            PointList intesectionsByCenterToRightTop = OrthoPathUtils.detectIntesections(line, lineCenterToRightTopLine);
            PointList intesectionsByCenterToRightBottom = OrthoPathUtils.detectIntesections(line, lineCenterToRightBottomLine);
            if (frstLineIntersectCenterToLeftTop.size() > 0 && frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity = this.getPointsAroundLeftSegment(line, obstacle);
            } else if (intesectionsByCenterToRightTop.size() > 0 && intesectionsByCenterToRightBottom.size() > 0) {
                aroundEntity = this.getPointsAroundRightSegment(line, obstacle);
            } else if (intesectionsByCenterToRightBottom.size() > 0 && frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByBotomSegment(line, obstacle);
            } else if (intesectionsByCenterToRightTop.size() > 0 && frstLineIntersectCenterToLeftTop.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByTopSegment(line, obstacle);
            } else if (frstLineIntersectByLeft.size() > 0 && frstLineIntersectByRight.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByTopSegment(line, obstacle);
            } else if (frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
            } else {
                if (frstLineIntersectCenterToLeftTop.size() > 0) {
                    if (frstLineIntersectByLeft.size() > 0 && nextLineIntersectByBottom.size() > 0) {
                        aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                        aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                        aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
                    } else {
                        aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
                        aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
                        aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
                    }
                    return aroundEntity;
                }
                if (intesectionsByCenterToRightTop.size() > 0 && nextLineIntersectByTop.size() > 0) {
                    aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
                    aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
                    aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
                    return aroundEntity;
                }
                if (intesectionsByCenterToRightTop.size() > 0 && nextLineIntersectByBottom.size() > 0) {
                    aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
                    aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
                    aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
                    return aroundEntity;
                }
            }
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundLeftRightByTopSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        }
        return aroundEntity;
    }

    private PointList resolveOverlappingRouteSegmentsVertically(PointList originalPoints, @NotNull OrthoPath path) {
        PointList points = originalPoints;
        int iterationCounter = 0;
        while (iterationCounter < 5) {
            List<RouteLine> intersectionLines = this.getVerticalIntersections(points, path);
            if (intersectionLines.isEmpty()) {
                return points;
            }
            points = this.resolveVerticalIntersections(points, intersectionLines);
            points = this.resolveExtraRoutePoints(points);
            ++iterationCounter;
        }
        return points;
    }

    @NotNull
    private PointList resolveVerticalIntersections(@NotNull PointList originalPoints, @NotNull List<RouteLine> intersectionLines) {
        List<RouteLine> routerLines = OrthoPathUtils.toRouteLines(originalPoints);
        boolean fromLeftRight = OrthoPathUtils.isLeftRightDirection(originalPoints.getFirstPoint(), originalPoints.getLastPoint());
        boolean fromBottomToTop = OrthoPathUtils.isBottomToTop(originalPoints);
        for (RouteLine interSectionLine : intersectionLines) {
            this.lineSpacing = 10;
            for (RouteLine routeLine : routerLines) {
                if (!routeLine.equals(interSectionLine)) continue;
                if (fromBottomToTop) {
                    routeLine.getFirst().x -= this.lineSpacing;
                    routeLine.getLast().x -= this.lineSpacing;
                } else if (fromLeftRight) {
                    routeLine.getFirst().x += this.lineSpacing;
                    routeLine.getLast().x += this.lineSpacing;
                } else {
                    routeLine.getFirst().x -= this.lineSpacing;
                    routeLine.getLast().x -= this.lineSpacing;
                }
                this.lineSpacing += 15;
            }
        }
        if (routerLines.size() > 1 && routerLines.get(0).getFirst().equals((Object)routerLines.get(1).getFirst())) {
            routerLines.remove(0);
        }
        return OrthoPathUtils.toPointList(routerLines);
    }

    @NotNull
    private PointList getPointsAroundLeftRightByBotomSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == 0) {
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundRightSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == -90) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundLeftSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == -90 || direction == 90) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundCornerSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle, @NotNull PointList nextLineIntersectTop, @NotNull PointList nextLineIntersectBottom, @NotNull PointList nextLineIntersectLeft, @NotNull PointList nextLineintersectRight, @NotNull PointList frstLineintersectLeft, @NotNull PointList frstLineintersectRight, @NotNull PointList frstLineintersectTop, @NotNull PointList frstLineintersectBottom) {
        int direction = (int)Math.toDegrees(line.getAngel());
        PointList aroundEntity = new PointList();
        if (frstLineintersectLeft.size() > 0 && nextLineIntersectBottom.size() > 0) {
            if (direction == 0) {
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
            } else {
                aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
            }
            return aroundEntity;
        }
        if (frstLineintersectLeft.size() > 0 && nextLineIntersectTop.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
            return aroundEntity;
        }
        if (frstLineintersectRight.size() > 0 && nextLineIntersectBottom.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
            return aroundEntity;
        }
        if (frstLineintersectRight.size() > 0 && nextLineIntersectTop.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
            return aroundEntity;
        }
        if (frstLineintersectBottom.size() > 0 && nextLineIntersectLeft.size() > 0) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
            return aroundEntity;
        }
        if (frstLineintersectBottom.size() > 0 && nextLineintersectRight.size() > 0) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            return aroundEntity;
        }
        if (frstLineintersectTop.size() > 0 && nextLineIntersectLeft.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
            return aroundEntity;
        }
        return aroundEntity;
    }

    private boolean isCornerIntersection(@NotNull PointList intersectionsNextByTop, @NotNull PointList intersectionsNextByBottom, @NotNull PointList intersectionsNextByLeft, @NotNull PointList intersectionsNextByRight) {
        return intersectionsNextByBottom.size() > 0 || intersectionsNextByTop.size() > 0 || intersectionsNextByLeft.size() > 0 || intersectionsNextByRight.size() > 0;
    }

    private void joinObstacles() {
    }

    private int solveDirtyPaths() {
        OrthoPath path;
        int numSolved = 0;
        int i = 0;
        while (i < this.userPaths.size()) {
            path = this.userPaths.get(i);
            if (path.isDirty) {
                List<OrthoPath> children = this.pathsToChildPaths.get(path);
                int prevCount = 1;
                int newCount = 1;
                if (children == null) {
                    children = Collections.emptyList();
                } else {
                    prevCount = children.size();
                }
                if (path.getBendPoints() != null) {
                    newCount = path.getBendPoints().size() + 1;
                }
                if (prevCount != newCount) {
                    children = this.regenerateChildPaths(path, children, prevCount, newCount);
                }
                this.refreshChildrenEndpoints(path, children);
            }
            ++i;
        }
        i = 0;
        while (i < this.workingPaths.size()) {
            path = this.workingPaths.get(i);
            if (!path.isDirty) {
                path.resetPartial();
            } else {
                ++numSolved;
                path.fullReset();
                this.resetVertices();
            }
            ++i;
        }
        if (numSolved == 0) {
            this.resetVertices();
        }
        return numSolved;
    }

    private void refreshChildrenEndpoints(OrthoPath path, List<OrthoPath> children) {
        Point previous = path.getStartPoint();
        PointList bendpoints = path.getBendPoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendpoints.size() ? bendpoints.getPoint(i) : path.getEndPoint();
            OrthoPath child = children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<OrthoPath> regenerateChildPaths(OrthoPath path, List<OrthoPath> children, int currentSize, int newSize) {
        block2: {
            if (currentSize != 1) break block2;
            this.workingPaths.remove(path);
            currentSize = 0;
            children = new ArrayList<OrthoPath>();
            this.pathsToChildPaths.put(path, children);
            ** GOTO lbl24
        }
        if (newSize != 1) ** GOTO lbl24
        this.workingPaths.removeAll(children);
        this.workingPaths.add(path);
        this.pathsToChildPaths.remove(path);
        return Collections.emptyList();
lbl-1000:
        // 1 sources

        {
            child = new OrthoPath();
            this.workingPaths.add(child);
            children.add(child);
            ++currentSize;
lbl24:
            // 3 sources

            ** while (currentSize < newSize)
        }
lbl25:
        // 2 sources

        while (currentSize > newSize) {
            child = children.remove(children.size() - 1);
            this.workingPaths.remove(child);
            --currentSize;
        }
        return children;
    }

    public void updateObstacle(Rectangle oldBounds, Rectangle newBounds) {
        this.removeObstacle(oldBounds);
        this.addObstacle(newBounds);
    }

    public List<RouteRectangle> getObstacles() {
        return this.userObstacles;
    }

    static class PathStack
    extends ArrayList<Object> {
        private static final long serialVersionUID = -1686339891731420061L;

        PathStack() {
        }

        OrthoPath pop() {
            return (OrthoPath)this.remove(this.size() - 1);
        }

        void push(OrthoPath path) {
            this.add(path);
        }
    }
}

