/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.ortho;

import com.dbeaver.ui.editors.erd.ortho.OrthoPath;
import com.dbeaver.ui.editors.erd.ortho.OrthoPathUtils;
import com.dbeaver.ui.editors.erd.ortho.OrthogonalConnection;
import com.dbeaver.ui.editors.erd.ortho.OrthogonalIntersection;
import com.dbeaver.ui.editors.erd.ortho.OrthogonalRouter;
import com.dbeaver.ui.editors.erd.ortho.RouteLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouter;

public class OrthogonalPathRouting
extends ERDConnectionRouter {
    private static final int DISTANCE_TO_CORNER = 7;
    private Log log = Log.getLog((String)OrthogonalPathRouting.class.getName());
    private final Map<Connection, Object> constraintMap = new LinkedHashMap<Connection, Object>();
    private final Set<Connection> staleConnections = new LinkedHashSet<Connection>();
    private final LayoutListener listener = new LayoutTracker();
    @Nullable
    private Map<IFigure, Rectangle> figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
    @Nullable
    private Map<Connection, OrthoPath> connectionToPaths;
    private Map<Connection, Polyline> connectionToFigure = new LinkedHashMap<Connection, Polyline>();
    private Map<Connection, List<OrthogonalIntersection>> connection2intersections = new LinkedHashMap<Connection, List<OrthogonalIntersection>>();
    private Map<Connection, PointList> connection2pointlist = new LinkedHashMap<Connection, PointList>();
    private final OrthogonalRouter algorithm = new OrthogonalRouter();
    private boolean isDirty;
    private boolean ignoreInvalidate;
    private final FigureListener figureListener = source -> {
        Rectangle newBounds = source.getBounds().getCopy();
        this.algorithm.updateObstacle(this.figuresToBounds.get(source), newBounds);
        this.queueSomeRouting();
        this.isDirty = true;
        this.figuresToBounds.put(source, newBounds);
    };

    void addChild(@NotNull IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.addObstacle(bounds);
        this.figuresToBounds.put(child, bounds);
        child.addFigureListener(this.figureListener);
        this.isDirty = true;
    }

    private void hookAll() {
        this.figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
        this.getContainer().getChildren().forEach(this::addChild);
        this.getContainer().addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.getContainer().removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.getConnectionPoints().put(connection, new PointList());
        this.isDirty = true;
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new LinkedHashMap<Connection, OrthoPath>();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = iter.next();
            OrthoPath path = this.connectionToPaths.get(conn);
            if (path == null) {
                path = new OrthoPath(conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.emptyList();
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.getContainer().translateToRelative((Translatable)start);
            this.getContainer().translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                for (Object element : constraint) {
                    Bendpoint bp = (Bendpoint)element;
                    bends.addPoint(bp.getLocation());
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    void queueSomeRouting() {
        if (this.connectionToPaths == null || this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            this.connectionToPaths.keySet().iterator().next().revalidate();
        }
        finally {
            this.ignoreInvalidate = false;
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        this.connectionToFigure.remove(connection);
        if (this.connectionToPaths == null) {
            return;
        }
        OrthoPath path = this.connectionToPaths.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    void removeChild(@NotNull IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        this.isDirty = true;
        this.queueSomeRouting();
    }

    public void route(Connection currentConnection) {
        if (this.isDirty) {
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            if (this.connectionToPaths == null) {
                return;
            }
            List<OrthoPath> algorithmPathes = this.algorithm.solve();
            if (algorithmPathes.isEmpty()) {
                return;
            }
            for (OrthoPath path : algorithmPathes) {
                Connection connection = path.getConnection();
                connection.revalidate();
                PointList points = path.getPoints().getCopy();
                if (points.size() == 0) {
                    connection.setVisible(false);
                    continue;
                }
                this.getConnectionPoints().put(connection, points);
                this.connection2pointlist = this.detectGlobalIntersections();
                this.connection2intersections = this.detectBridges(connection);
                Polyline routeLine = this.connectionToFigure.computeIfAbsent(connection, l -> {
                    Polyline polyline = new Polyline();
                    connection.add((IFigure)polyline, 0);
                    return polyline;
                });
                routeLine.setPoints(points);
                connection.setPoints(points);
                ((OrthogonalConnection)connection).addTarceLine(path.getTraceLines());
            }
            for (OrthoPath path : algorithmPathes) {
                Connection connection = path.getConnection();
                if (!(connection instanceof OrthogonalConnection)) continue;
                OrthogonalConnection orthoConnection = (OrthogonalConnection)connection;
                orthoConnection.clearBridges();
                orthoConnection.createBridges(this.findBridgesForConnection((Connection)orthoConnection));
            }
            this.ignoreInvalidate = false;
        }
    }

    private List<OrthogonalIntersection> findBridgesForConnection(Connection connection) {
        ArrayList<OrthogonalIntersection> intersections = new ArrayList<OrthogonalIntersection>();
        Map<Connection, PointList> intersectionsConnection2pointList = this.getItersectionConnection2PointList();
        Map<Connection, List<OrthogonalIntersection>> intesectionsConnection2ortho = this.getItersectionConnection2Ortholine();
        PointList globalPointList = intersectionsConnection2pointList.get(connection);
        if (globalPointList == null) {
            return Collections.emptyList();
        }
        List<Point> listOfGlobalIntersections = OrthoPathUtils.toListPoint(globalPointList);
        List<OrthogonalIntersection> listOfInterSections = intesectionsConnection2ortho.get(connection);
        if (listOfInterSections == null) {
            return Collections.emptyList();
        }
        for (OrthogonalIntersection orthoIntersection : listOfInterSections) {
            Point intersection;
            if (!orthoIntersection.isPrimary() || !listOfGlobalIntersections.contains(intersection = orthoIntersection.getPoint())) continue;
            PointList cornerPoints = OrthoPathUtils.getCornerPoints(connection.getPoints());
            boolean isCloseToCorner = false;
            int i = 0;
            while (i < cornerPoints.size()) {
                RouteLine absLine = new RouteLine(cornerPoints.getPoint(i), intersection);
                if (absLine.isOrthoLine() && absLine.getLength() < 7.0) {
                    isCloseToCorner = true;
                    break;
                }
                ++i;
            }
            if (isCloseToCorner) continue;
            intersections.add(orthoIntersection);
        }
        return intersections;
    }

    private Map<Connection, PointList> detectGlobalIntersections() {
        this.connection2pointlist.clear();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            Connection connection = (Connection)entry.getKey();
            if (!(connection instanceof OrthogonalConnection)) continue;
            OrthogonalConnection erdConnection = (OrthogonalConnection)connection;
            PointList crossPoints = new PointList();
            for (Map.Entry targetEntry : this.getConnectionPoints().entrySet()) {
                if (targetEntry.equals(entry)) continue;
                crossPoints.addAll(OrthoPathUtils.detectIntesections((PointList)entry.getValue(), (PointList)targetEntry.getValue()));
            }
            this.connection2pointlist.put((Connection)erdConnection, crossPoints);
        }
        return this.connection2pointlist;
    }

    private Map<Connection, List<OrthogonalIntersection>> detectBridges(Connection connection) {
        ArrayList<OrthogonalIntersection> orthoIntersections = new ArrayList<OrthogonalIntersection>();
        if (connection instanceof OrthogonalConnection) {
            OrthogonalConnection conn = (OrthogonalConnection)connection;
            PointList pointList = (PointList)this.getConnectionPoints().get((Object)conn);
            for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
                if (((Connection)entry.getKey()).equals((Object)conn)) continue;
                orthoIntersections.addAll(OrthoPathUtils.detectOrthogonalIntesections(pointList, (PointList)entry.getValue()));
            }
            for (Map.Entry<Object, Object> entry : this.connection2intersections.entrySet()) {
                if (((Connection)entry.getKey()).equals(connection)) continue;
                for (OrthogonalIntersection current : orthoIntersections) {
                    for (OrthogonalIntersection slave : (List)entry.getValue()) {
                        if (!current.getPoint().equals((Object)slave.getPoint())) continue;
                        slave.setPrimary(false);
                    }
                }
            }
            this.connection2intersections.put(connection, orthoIntersections);
        }
        return this.connection2intersections;
    }

    public List<?> getPathsAfterRouting() {
        if (this.isDirty) {
            this.processStaleConnections();
            this.isDirty = false;
            return this.algorithm.solve();
        }
        return Collections.emptyList();
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    public void clearConstraint(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        this.isDirty = true;
    }

    public boolean hasMoreConnections() {
        return this.connectionToPaths != null && !this.connectionToPaths.isEmpty();
    }

    public void setIgnoreInvalidate(boolean b) {
        this.ignoreInvalidate = b;
    }

    public boolean shouldIgnoreInvalidate() {
        return this.ignoreInvalidate;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean containsConnection(Connection conn) {
        return this.connectionToPaths != null && this.connectionToPaths.containsKey(conn);
    }

    @NotNull
    public PolylineConnection getConnectionInstance() {
        return new OrthogonalConnection();
    }

    protected void handleCollision(@NotNull PointList points, int index) {
    }

    public Map<Connection, PointList> getItersectionConnection2PointList() {
        return this.connection2pointlist;
    }

    public Map<Connection, List<OrthogonalIntersection>> getItersectionConnection2Ortholine() {
        return this.connection2intersections;
    }

    public void revalidateCahce() {
        this.connection2intersections.clear();
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            if (OrthogonalPathRouting.this.staleConnections.isEmpty()) {
                return;
            }
            OrthogonalPathRouting.this.staleConnections.iterator().next().revalidate();
        }

        public void remove(@NotNull IFigure child) {
            OrthogonalPathRouting.this.removeChild(child);
        }

        public void setConstraint(@NotNull IFigure child, Object constraint) {
            OrthogonalPathRouting.this.addChild(child);
        }
    }
}

