/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.model;

import com.dbeaver.ui.editors.erd.edit.LabelCellEditorLocator;
import com.dbeaver.ui.editors.erd.edit.TableNameCellEditorValidator;
import com.dbeaver.ui.editors.erd.policies.AttributeDirectEditPolicy;
import com.dbeaver.ui.editors.erd.policies.AttributeEditPolicy;
import com.dbeaver.ui.editors.erd.policies.AttributeForeignKeyEditPolicy;
import com.dbeaver.ui.editors.erd.policies.EntityDirectEditPolicy;
import com.dbeaver.ui.editors.erd.policies.EntityEditPolicyExt;
import com.dbeaver.ui.editors.erd.policies.EntityForeignKeyEditPolicy;
import com.dbeaver.ui.editors.erd.policies.ForeignKeyEditPolicy;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.editors.erd.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.ui.editors.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ui.editors.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ui.editors.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ui.editors.erd.figures.EntityFigure;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDModelAdapterDefault;
import org.jkiss.dbeaver.ui.editors.erd.part.AssociationPart;
import org.jkiss.dbeaver.ui.editors.erd.part.AttributePart;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.ui.editors.erd.part.PropertyAwarePart;

public class ERDEditableModelAdapter
extends ERDModelAdapterDefault {
    public static final String PROP_EDIT_MODE = "EDIT_MODE";
    public static final String COMMAND_EDIT_MODE = "com.dbeaver.ui.erd.switchEditMode";
    private static final Log log = Log.getLog(ERDEditableModelAdapter.class);
    private ERDDiagram diagram;
    private boolean editMode = false;
    private DBECommandContext commandContext;
    private boolean modelInitialized;
    private static Boolean propsVisibleInitially;

    public ERDEditableModelAdapter(ERDDiagram diagram) {
        this.diagram = diagram;
    }

    public void setDiagram(ERDDiagram diagram) {
        this.diagram = diagram;
    }

    public boolean supportsModelEdit() {
        return this.editMode;
    }

    public void setEditMode(boolean editable) {
        if (editable == this.editMode) {
            return;
        }
        this.editMode = editable;
        this.diagram.firePropertyChange(PROP_EDIT_MODE, (Object)(!editable ? 1 : 0), (Object)editable);
    }

    public void installPartEditPolicies(EditPart editPart) {
        if (this.getCommandContext(editPart) == null) {
            return;
        }
        if (editPart instanceof EntityPart) {
            editPart.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new EntityDirectEditPolicy());
            editPart.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new EntityEditPolicyExt());
            editPart.installEditPolicy((Object)"GraphicalNodeEditPolicy", (EditPolicy)new EntityForeignKeyEditPolicy());
        } else if (editPart instanceof AttributePart) {
            editPart.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new AttributeEditPolicy());
            editPart.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new AttributeDirectEditPolicy());
            editPart.installEditPolicy((Object)"ContainerEditPolicy", (EditPolicy)new AttributeForeignKeyEditPolicy((AttributePart)editPart));
        } else if (editPart instanceof AssociationPart) {
            editPart.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new ForeignKeyEditPolicy());
        } else {
            boolean cfr_ignored_0 = editPart instanceof DiagramPart;
        }
    }

    public void performPartRequest(EditPart editPart, Request request) {
        if (!this.diagram.isEditEnabled() || this.getCommandContext(editPart) == null) {
            return;
        }
        if (editPart instanceof EntityPart) {
            if (request.getType() == "direct edit" && request instanceof DirectEditRequest) {
                if (!this.directEditHitTest(((EntityPart)editPart).getFigure(), ((DirectEditRequest)request).getLocation().getCopy())) {
                    return;
                }
                this.performEntityDirectEdit((EntityPart)editPart);
            }
        } else if (editPart instanceof AttributePart) {
            if (request.getType() == "direct edit" && request instanceof DirectEditRequest) {
                if (!this.directEditHitTest(((AttributePart)editPart).getFigure(), ((DirectEditRequest)request).getLocation().getCopy())) {
                    return;
                }
                this.performAttributeDirectEdit((AttributePart)editPart);
            }
        } else {
            boolean cfr_ignored_0 = editPart instanceof DiagramPart;
        }
    }

    private DBECommandContext getCommandContext(EditPart editPart) {
        if (!this.modelInitialized) {
            this.commandContext = ((PropertyAwarePart)editPart).getCommandContext();
            this.modelInitialized = true;
        }
        return this.commandContext;
    }

    private boolean directEditHitTest(EntityFigure figure, Point requestLoc) {
        EditableLabel nameLabel = figure.getNameLabel();
        nameLabel.translateToRelative((Translatable)requestLoc);
        return nameLabel.containsPoint(requestLoc);
    }

    private boolean directEditHitTest(AttributeItemFigure figure, Point requestLoc) {
        figure.translateToRelative((Translatable)requestLoc);
        return figure.containsPoint(requestLoc);
    }

    private void performEntityDirectEdit(EntityPart entityPart) {
        ERDGraphicalViewer viewer = entityPart.getViewer();
        ValidationMessageHandler handler = viewer.getValidationHandler();
        EntityFigure figure = entityPart.getFigure();
        EditableLabel nameLabel = figure.getNameLabel();
        ExtendedDirectEditManager manager = new ExtendedDirectEditManager((GraphicalEditPart)entityPart, TextCellEditor.class, (CellEditorLocator)new LabelCellEditorLocator((Label)nameLabel), (IFigure)nameLabel, (ICellEditorValidator)new TableNameCellEditorValidator(handler));
        manager.show();
    }

    private void performAttributeDirectEdit(AttributePart attributePart) {
        ERDGraphicalViewer viewer = (ERDGraphicalViewer)attributePart.getViewer();
        viewer.getValidationHandler();
        EditableLabel nameLabel = attributePart.getFigure().getLabel();
        ExtendedDirectEditManager manager = new ExtendedDirectEditManager((GraphicalEditPart)attributePart, TextCellEditor.class, (CellEditorLocator)new LabelCellEditorLocator((Label)nameLabel), (IFigure)nameLabel, value -> null);
        manager.show();
    }

    public void handlePropertyChange(ERDEditorPart editorPart, PropertyChangeEvent event) {
        if (event.getPropertyName().equals(PROP_EDIT_MODE)) {
            this.onChangeEditMode(editorPart);
        }
    }

    public void handleContentChange(ERDEditorPart editorPart) {
        this.onChangeEditMode(editorPart);
    }

    private void onChangeEditMode(ERDEditorPart erdEditor) {
        erdEditor.setEditMode(this.editMode);
        IWorkbenchPage activePage = erdEditor.getSite().getWorkbenchWindow().getActivePage();
        IViewPart propsView = activePage.findView("org.eclipse.ui.views.PropertySheet");
        if (propsVisibleInitially == null) {
            propsVisibleInitially = propsView != null;
        }
        if (this.editMode) {
            if (propsView == null || !activePage.isPartVisible((IWorkbenchPart)propsView)) {
                try {
                    activePage.showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException e) {
                    log.error((Object)e);
                }
            }
        } else {
            if (propsView != null && !propsVisibleInitially.booleanValue()) {
                activePage.hideView(propsView);
            }
            propsVisibleInitially = null;
        }
        ActionUtils.fireCommandRefresh((String[])new String[]{COMMAND_EDIT_MODE});
    }
}

