/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.figures;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class BridgeFigure
extends Ellipse {
    private static final int HEIGHT = 30;
    private static final int WIDTH = 30;
    private double angle = 90.0;
    private int width = 1;
    private Point locationPoint;

    public BridgeFigure() {
        this.angle = 90.0;
    }

    public BridgeFigure(double angle) {
        this.angle = angle;
    }

    public void setLocation(Point p) {
        super.setLocation(p);
        this.locationPoint = p;
        this.setBounds(new Rectangle(p.x - 5, p.y - 5, 30, 30));
    }

    protected void fillShape(Graphics graphics) {
        graphics.setLineWidth(this.width);
        if (this.angle == 90.0 || this.angle == -90.0) {
            graphics.fillArc(this.locationPoint.x - 3, this.locationPoint.y, 14, 12, 270, 180);
        } else {
            graphics.fillArc(this.locationPoint.x - 1, this.locationPoint.y, 12, 14, 0, 180);
        }
    }

    protected void outlineShape(Graphics graphics) {
        graphics.setLineWidth(this.width);
        if (this.angle == 90.0 || this.angle == -90.0) {
            graphics.drawArc(this.locationPoint.x - 1, this.locationPoint.y, 11, 11, 270, 180);
        } else {
            graphics.drawArc(this.locationPoint.x - 1, this.locationPoint.y, 11, 11, 0, 180);
        }
    }

    public void setBridgeWidth(int width) {
        this.width = width;
    }
}

