/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec.query;

import com.dbeaver.db.google.firestore.exec.FireStoreExecutionContext;
import com.dbeaver.db.google.firestore.exec.query.FireStoreSQLQueryProcessor;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Filter;
import com.google.cloud.firestore.Query;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.utils.Pair;

public class FireStoreQueryBuilder {
    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof NullValue) {
            return null;
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = FireStoreSQLQueryProcessor.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + String.valueOf(expr));
        }
        throw new DBCException("Unsupported value: " + String.valueOf(expr));
    }

    /*
     * WARNING - void declaration
     */
    private static Filter buildWhereFilter(Expression expr) throws DBCException {
        ParenthesedExpressionList parenthesis;
        if (expr instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)expr;
            Filter leftWhereFilter = FireStoreQueryBuilder.buildWhereFilter(andExpression.getLeftExpression());
            Filter rightWhereFilter = FireStoreQueryBuilder.buildWhereFilter(andExpression.getRightExpression());
            return Filter.and((Filter[])new Filter[]{leftWhereFilter, rightWhereFilter});
        }
        if (expr instanceof InExpression) {
            void itemsList;
            InExpression inExpression = (InExpression)expr;
            Expression leftExpression = inExpression.getLeftExpression();
            if (!(leftExpression instanceof Column)) {
                throw new DBCException("IN conditions mast have column on the left side");
            }
            Expression expression = inExpression.getRightExpression();
            if (!(expression instanceof ExpressionList)) {
                throw new DBCException("IN conditions mast have expression list on the right side");
            }
            ExpressionList expressionList = (ExpressionList)expression;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : itemsList) {
                Object fieldValue = FireStoreQueryBuilder.parseValueExpression(exp);
                values.add(fieldValue);
            }
            if (inExpression.isNot()) {
                return Filter.notInArray((String)((Column)leftExpression).getColumnName(), values);
            }
            return Filter.inArray((String)((Column)leftExpression).getColumnName(), values);
        }
        if (expr instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)expr;
            Filter leftWhereFilter = FireStoreQueryBuilder.buildWhereFilter(orExpression.getLeftExpression());
            Filter rightWhereFilter = FireStoreQueryBuilder.buildWhereFilter(orExpression.getRightExpression());
            return Filter.or((Filter[])new Filter[]{leftWhereFilter, rightWhereFilter});
        }
        if (expr instanceof BinaryExpression) {
            return FireStoreQueryBuilder.parseBinaryExpression((BinaryExpression)expr);
        }
        if (expr instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)expr).size() == 1) {
            return FireStoreQueryBuilder.buildWhereFilter((Expression)parenthesis.get(0));
        }
        if (expr instanceof IsNullExpression) {
            void column;
            IsNullExpression isNullExpression = (IsNullExpression)expr;
            Expression leftExpression = isNullExpression.getLeftExpression();
            if (!(leftExpression instanceof Column)) {
                throw new DBCException("Null check condition must have column on the left side");
            }
            Column exp = (Column)leftExpression;
            String fieldName = FireStoreSQLQueryProcessor.unquote(column.getFullyQualifiedName());
            if (isNullExpression.isNot()) {
                return Filter.notEqualTo((String)fieldName, null);
            }
            throw new DBCException("IS NULL indexing is not supported by Firestore");
        }
        throw new DBCException("Unsupported expression: " + String.valueOf(expr));
    }

    /*
     * WARNING - void declaration
     */
    private static Filter parseBinaryExpression(BinaryExpression expr) throws DBCException {
        void column;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + String.valueOf(left));
        }
        Column column2 = (Column)left;
        String fieldName = FireStoreSQLQueryProcessor.unquote(column.getFullyQualifiedName());
        Object fieldValue = FireStoreQueryBuilder.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            return Filter.equalTo((String)fieldName, (Object)fieldValue);
        }
        if (expr instanceof NotEqualsTo) {
            return Filter.notEqualTo((String)fieldName, (Object)fieldValue);
        }
        if (expr instanceof GreaterThan) {
            return Filter.greaterThan((String)fieldName, (Object)fieldValue);
        }
        if (expr instanceof GreaterThanEquals) {
            return Filter.greaterThanOrEqualTo((String)fieldName, (Object)fieldValue);
        }
        if (expr instanceof MinorThan) {
            return Filter.lessThan((String)fieldName, (Object)fieldValue);
        }
        if (expr instanceof MinorThanEquals) {
            return Filter.lessThanOrEqualTo((String)fieldName, (Object)fieldValue);
        }
        throw new DBCException("Unsupported operation: " + expr.getStringExpression());
    }

    public static Query buildQueryFromStatement(@NotNull FireStoreExecutionContext context, @NotNull Statement sqlQuery, @NotNull String collectionPath) throws DBCException {
        CollectionReference collectionReference;
        CollectionReference query = collectionReference = FireStoreQueryBuilder.findCollection(context, collectionPath);
        Expression expression = null;
        if (sqlQuery instanceof Delete) {
            Delete delete = (Delete)sqlQuery;
            expression = delete.getWhere();
        } else if (sqlQuery instanceof Update) {
            Update update = (Update)sqlQuery;
            expression = update.getWhere();
        } else {
            throw new DBCException("Unsupported statement");
        }
        query = FireStoreQueryBuilder.addWhereCondition(expression, (Query)query, collectionReference);
        return query;
    }

    @NotNull
    public static Query buildQueryFromSelect(@NotNull FireStoreExecutionContext context, @NotNull PlainSelect sqlQuery, @NotNull String collectionPath, int offset, int limit) throws DBCException {
        CollectionReference collectionReference;
        CollectionReference query = collectionReference = FireStoreQueryBuilder.findCollection(context, collectionPath);
        Expression expression = sqlQuery.getWhere();
        query = FireStoreQueryBuilder.addWhereCondition(expression, (Query)query, collectionReference);
        List<Pair<Column, Boolean>> orderList = FireStoreSQLQueryProcessor.getOrdering(sqlQuery);
        if (!orderList.isEmpty()) {
            for (Pair<Column, Boolean> column : orderList) {
                String fieldName = DBUtils.getUnQuotedIdentifier((DBPDataSource)context.getDataSource(), (String)((Column)column.getFirst()).getColumnName());
                query = fieldName.equals("__name__") ? query.orderBy(FieldPath.documentId(), (Boolean)column.getSecond() != false ? Query.Direction.ASCENDING : Query.Direction.DESCENDING) : query.orderBy(FieldPath.of((String[])new String[]{fieldName}), (Boolean)column.getSecond() != false ? Query.Direction.ASCENDING : Query.Direction.DESCENDING);
            }
        }
        if (offset > 0) {
            query = query.offset(offset);
        }
        if (limit > 0) {
            query = query.limit(limit);
        }
        return query;
    }

    private static Query addWhereCondition(Expression where, Query query, CollectionReference collectionReference) throws DBCException {
        if (where != null) {
            Filter whereFilter = FireStoreQueryBuilder.buildWhereFilter(where);
            query = collectionReference.where(whereFilter);
        }
        return query;
    }

    private static CollectionReference findCollection(@NotNull FireStoreExecutionContext context, @NotNull String collectionPath) throws DBCException {
        try {
            return context.getService().collection(collectionPath);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new DBCException("Collection Not Found");
        }
    }
}

