/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.FirestoreUtils;
import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreExecutionContext;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.exec.query.FireStoreQueryBuilder;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class FireStoreQueryStatement
extends FireStoreBaseStatement {
    private FireStoreDatasource dataSource;
    private String collectionPath;
    private boolean count;
    private Object executeError;

    public FireStoreQueryStatement(@NotNull FireStoreSession session, @NotNull String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        this.updateDataSource();
        try {
            String queryText = SQLUtils.stripComments((SQLDialect)this.dataSource.getSQLDialect(), (String)this.getQueryString());
            Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)this.dataSource.getSQLDialect(), (String)queryText);
            FireStoreExecutionContext executionContext = ((FireStoreSession)this.getSession()).getExecutionContext();
            if (statement instanceof Select) {
                Select select = (Select)statement;
                PlainSelect plainSelect = this.makePlainSelectFromStatement(select);
                Query query = FireStoreQueryBuilder.buildQueryFromSelect(executionContext, plainSelect, this.collectionPath, this.offset, this.limit);
                QuerySnapshot queryDocumentSnapshots = (QuerySnapshot)query.get().get((long)this.timeout, TimeUnit.SECONDS);
                this.result = this.count ? Long.valueOf(((AggregateQuerySnapshot)query.count().get().get((long)this.timeout, TimeUnit.SECONDS)).getCount()) : queryDocumentSnapshots.getDocuments().stream().filter(DocumentSnapshot::exists).collect(Collectors.toList());
            } else if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                this.parseDelete(delete);
                Query query = FireStoreQueryBuilder.buildQueryFromStatement(executionContext, (Statement)delete, this.collectionPath);
                QuerySnapshot queryDocumentSnapshots = (QuerySnapshot)query.get().get((long)this.timeout, TimeUnit.SECONDS);
                List documents = queryDocumentSnapshots.getDocuments();
                for (QueryDocumentSnapshot document : documents) {
                    executionContext.getService().recursiveDelete(document.getReference());
                }
                this.setUpdateRowCount(documents.size());
            } else if (statement instanceof Insert) {
                Expression expression;
                Insert insert = (Insert)statement;
                this.parseInsert(insert);
                ExpressionList columns = insert.getColumns();
                List expressions = FireStoreQueryStatement.getExpressions(insert, (List<Column>)columns);
                if (expressions.size() == 1 && (expression = expressions.get(0)) instanceof RowConstructor) {
                    RowConstructor rowConstructor = (RowConstructor)expression;
                    expressions = rowConstructor.getExpressions();
                }
                HashMap<String, Object> insertMap = new HashMap<String, Object>();
                String docID = null;
                int i = 0;
                while (i < columns.size()) {
                    Column item = (Column)columns.get(i);
                    String key = FirestoreUtils.unquote(item.getFullyQualifiedName());
                    Object value = FirestoreUtils.convertValueExpressionToObject((Expression)expressions.get(i));
                    if ("__name__".equals(key)) {
                        docID = CommonUtils.toString((Object)value);
                    } else {
                        insertMap.put(key, value);
                    }
                    ++i;
                }
                Table table = insert.getTable();
                String path = FirestoreUtils.extractCollectionPathFromFullyQualifiedName(table.getFullyQualifiedName());
                if (docID != null) {
                    executionContext.getService().collection(path).document(path + "/" + docID).set(insertMap).get((long)this.timeout, TimeUnit.SECONDS);
                } else {
                    executionContext.getService().collection(path).add(insertMap);
                }
                this.setUpdateRowCount(1);
            } else if (statement instanceof Update) {
                Update update = (Update)statement;
                this.parseUpdate(update);
                List columns = update.getColumns();
                List valueExpressions = update.getExpressions();
                if (CommonUtils.isEmpty((Collection)columns) || CommonUtils.isEmpty((Collection)valueExpressions)) {
                    throw new DBCException("Empty columns/values");
                }
                if (columns.size() != valueExpressions.size()) {
                    throw new DBCException("Column set doesn't match value set");
                }
                Query query = FireStoreQueryBuilder.buildQueryFromStatement(executionContext, (Statement)update, this.collectionPath);
                QuerySnapshot queryDocumentSnapshots = (QuerySnapshot)query.get().get((long)this.timeout, TimeUnit.SECONDS);
                List documents = queryDocumentSnapshots.getDocuments();
                this.setUpdateRowCount(documents.size());
                for (QueryDocumentSnapshot document : documents) {
                    Map data = document.getData();
                    int i = 0;
                    while (i < columns.size()) {
                        Column item = (Column)columns.get(i);
                        String key = FirestoreUtils.unquote(item.getFullyQualifiedName());
                        Object value = FirestoreUtils.convertValueExpressionToObject((Expression)valueExpressions.get(i));
                        if ("__name__".equals(key)) {
                            throw new DBCException("Update by DOC_ID is not supported");
                        }
                        data.put(key, value);
                        ++i;
                    }
                    document.getReference().set(data).get((long)this.timeout, TimeUnit.SECONDS);
                }
            }
            return this.hasResultSet();
        }
        catch (Throwable exception) {
            throw this.handleExecuteError(exception);
        }
    }

    private void parseUpdate(Update update) throws DBCException {
        if (update.getTable() == null) {
            throw new DBCException("Can update only one table");
        }
        if (!CommonUtils.isEmpty((Collection)update.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (update.getSelect() != null) {
            throw new DBCException("SELECT in UPDATE not supported");
        }
        this.collectionPath = this.getCollectionFromTable(update.getTable());
    }

    private static List<Expression> getExpressions(Insert insert, List<Column> columns) throws DBCException {
        List subSelects = ((SetOperationList)insert.getSelect()).getSelects();
        if (CommonUtils.isEmpty(columns) || CommonUtils.isEmpty((Collection)subSelects)) {
            throw new DBCException("Empty columns/values");
        }
        if (subSelects.size() != 1 || !(subSelects.get(0) instanceof Values)) {
            throw new DBCException("Invalid VALUES clause");
        }
        Values valuesStatement = (Values)subSelects.get(0);
        ExpressionList valueExpressions = valuesStatement.getExpressions();
        List expressions = valueExpressions.getExpressions();
        return expressions;
    }

    private void parseInsert(Insert insert) throws DBCException {
        if (insert.getTable() == null) {
            throw new DBCException("Can insert only into one table");
        }
        if (!CommonUtils.isEmpty((Collection)insert.getWithItemsList())) {
            throw new DBCException("WITH is not supported");
        }
        if (insert.getSelect() == null) {
            throw new DBCException("VALUES not specified");
        }
        this.collectionPath = this.getCollectionFromTable(insert.getTable());
    }

    private void parseDelete(Delete delete) throws DBException {
        if (delete.getTable() == null) {
            throw new DBCException("Can delete only from single table");
        }
        if (!CommonUtils.isEmpty((Collection)delete.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        this.collectionPath = this.getCollectionFromTable(delete.getTable());
    }

    public DBSEntity getSourceEntity() {
        try {
            if (this.collectionPath.contains("/")) {
                return this.dataSource.getChildrenEntityInstance(this.collectionPath, ((FireStoreSession)this.connection).getProgressMonitor(), true, true);
            }
            return (DBSEntity)this.dataSource.getChild(((FireStoreSession)this.connection).getProgressMonitor(), this.collectionPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PlainSelect makePlainSelectFromStatement(Select select) throws DBException {
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            this.parseSelect(plainSelect);
            return plainSelect;
        }
        throw new DBCException("Non selects are not supported");
    }

    /*
     * WARNING - void declaration
     */
    private void parseSelect(PlainSelect select) throws DBCException {
        void sourceTable;
        FromItem fromItem = select.getFromItem();
        if (!(fromItem instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        Table table = (Table)fromItem;
        this.updateDataSource();
        this.collectionPath = this.getCollectionFromTable((Table)sourceTable);
        for (SelectItem item : CommonUtils.safeList((List)select.getSelectItems())) {
            Expression expression = item.getExpression();
            if (expression instanceof AllColumns || expression instanceof AllTableColumns) break;
            if (!(expression instanceof Function)) continue;
            Function function = (Function)expression;
            if (function.getName().equalsIgnoreCase("count")) {
                this.count = true;
                continue;
            }
            if (function.getParameters() == null || function.getParameters().getExpressions().size() != 1) {
                throw new DBCException("Accumulator functions only accept one argument");
            }
            if (!(function.getParameters().getExpressions().get(0) instanceof Column)) {
                throw new DBCException("First argument of an accumulator function must be column name");
            }
            throw new DBCException("Joins are not supported");
        }
        this.extractLimit(select);
    }

    private void extractLimit(PlainSelect select) throws DBCException {
        Limit sLimit = select.getLimit();
        if (sLimit != null) {
            try {
                if (sLimit.getOffset() != null) {
                    this.offset = Integer.parseInt(sLimit.getOffset().toString());
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Integer.parseInt(sLimit.getRowCount().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
    }

    private void updateDataSource() {
        DBSDataContainer dataContainer;
        DBCExecutionSource statementSource;
        if (this.dataSource == null && (statementSource = this.getStatementSource()) != null && (dataContainer = statementSource.getDataContainer()) != null) {
            this.dataSource = (FireStoreDatasource)dataContainer.getDataSource();
        }
    }

    private String getCollectionFromTable(Table sourceTable) throws DBCException {
        String fullyQualifiedName = sourceTable.getFullyQualifiedName();
        try {
            if (fullyQualifiedName.contains(".")) {
                return FirestoreUtils.extractCollectionPathFromFullyQualifiedName(fullyQualifiedName);
            }
            return DBUtils.getUnQuotedIdentifier((DBPDataSource)this.dataSource, (String)fullyQualifiedName);
        }
        catch (Exception exception) {
            throw new DBCException("Child not found", (Throwable)exception);
        }
    }
}

