/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class FireStoreExecutionContext
extends AbstractExecutionContext<FireStoreDatasource> {
    private static final Log log = Log.getLog(FireStoreExecutionContext.class);
    private Firestore service;
    private String token;

    public FireStoreExecutionContext(@NotNull FireStoreDatasource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public Firestore getService() {
        return this.service;
    }

    public void connect(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((FireStoreDatasource)this.dataSource).getContainer());
        try {
            try {
                DBPDataSourceContainer container = ((FireStoreDatasource)this.dataSource).getContainer();
                DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
                DBPAuthModelDescriptor authModelDescriptor = container.getDriver().getDataSourceProvider().detectConnectionAuthModel(container.getDriver(), configuration);
                DBAAuthModel authModel = authModelDescriptor.getInstance();
                DBAAuthCredentials credentials = authModel.loadCredentials(container, configuration);
                Object authentication = authModel.initAuthentication(monitor, this.getDataSource(), credentials, configuration, new Properties());
                boolean useDefaultCreds = false;
                boolean usedSSO = false;
                if (credentials instanceof AuthModelGCPCredentials || authentication instanceof AuthModelGCPCredentials) {
                    AuthModelGCPCredentials gcpCredentials;
                    AuthModelGCPCredentials authModelGCPCredentials = gcpCredentials = credentials instanceof AuthModelGCPCredentials ? (AuthModelGCPCredentials)credentials : (AuthModelGCPCredentials)authentication;
                    if (gcpCredentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
                        configuration.setProviderProperty("credentialsFile", gcpCredentials.getServiceAccountConfigPath());
                        configuration.setProviderProperty("credentials", gcpCredentials.getServiceAccountConfig());
                    } else if (gcpCredentials.getAuthType() == GCPAuthType.SSO_OVER_CLI || gcpCredentials.getAuthType() == GCPAuthType.SESSION_CREDENTIALS) {
                        gcpCredentials.resolveCredentials(monitor);
                        this.token = gcpCredentials.getToken();
                        usedSSO = true;
                    } else if (gcpCredentials.getAuthType() == GCPAuthType.DEFAULT) {
                        useDefaultCreds = true;
                    }
                } else {
                    useDefaultCreds = CommonUtils.toBoolean((Object)configuration.getProviderProperty("useDefaultCredentials"));
                }
                String projectID = container.getActualConnectionConfiguration().getProviderProperty("projectId");
                if (CommonUtils.isEmpty((String)projectID)) {
                    throw new DBException("Empty project ID");
                }
                CredentialsProvider googleCredentials = this.setupCredentials(configuration, useDefaultCreds, usedSSO);
                FirestoreOptions.Builder builder = FirestoreOptions.getDefaultInstance().toBuilder();
                if (!CommonUtils.isEmpty((String)configuration.getServerName())) {
                    builder.setDatabaseId(configuration.getServerName());
                }
                FirestoreOptions options = ((FirestoreOptions.Builder)builder.setCredentialsProvider(googleCredentials).setProjectId(projectID)).build();
                this.service = (Firestore)options.getService();
                super.initContextBootstrap(monitor, true);
                ((FireStoreDatasource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                this.close();
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((FireStoreDatasource)this.dataSource).getContainer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.disconnect();
        FireStoreExecutionContext fireStoreExecutionContext = this;
        synchronized (fireStoreExecutionContext) {
            ((FireStoreDatasource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    @NotNull
    public DBCSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String task) {
        return new FireStoreSession(monitor, purpose, task, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return this.service != null;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (phase == DBCInvalidatePhase.BEFORE_INVALIDATE) {
            this.disconnect();
        }
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            this.connect(monitor);
            ((FireStoreDatasource)this.dataSource).refreshObject(monitor);
        }
    }

    private CredentialsProvider setupCredentials(@NotNull DBPConnectionConfiguration cfg, boolean useDefaultCreds, boolean usedSSO) throws DBException {
        try {
            GoogleCredentials credentials;
            block26: {
                if (useDefaultCreds) {
                    credentials = GoogleCredentials.getApplicationDefault();
                } else if (usedSSO && CommonUtils.isNotEmpty((String)this.token)) {
                    credentials = GoogleCredentials.create((AccessToken)new AccessToken(this.token, null));
                } else {
                    String credFileName = CommonUtils.toString((Object)cfg.getProviderProperty("credentialsFile"));
                    String credEncodedData = CommonUtils.toString((Object)cfg.getProviderProperty("credentials"));
                    if (CommonUtils.isNotEmpty((String)credFileName)) {
                        Throwable throwable = null;
                        Object var8_12 = null;
                        try (FileInputStream cfgFileStream = new FileInputStream(credFileName);){
                            credentials = GoogleCredentials.fromStream((InputStream)cfgFileStream);
                            break block26;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (CommonUtils.isNotEmpty((String)credEncodedData)) {
                        Throwable throwable = null;
                        Object var8_14 = null;
                        try (ByteArrayInputStream cfgFileStream = new ByteArrayInputStream(Base64.getDecoder().decode(credEncodedData));){
                            credentials = GoogleCredentials.fromStream((InputStream)cfgFileStream);
                            break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    throw new DBException("Error reading Google credentials file. Please provide path to credentials file or use another authentication type.");
                }
            }
            return FixedCredentialsProvider.create((Credentials)credentials);
        }
        catch (Exception e) {
            throw new DBException("Error reading Google credentials", (Throwable)e);
        }
    }

    private void disconnect() {
        if (this.service != null) {
            try {
                this.service.close();
            }
            catch (Exception e) {
                log.debug((Object)"Error disconnecting cluster", (Throwable)e);
            }
        }
    }
}

