/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQuerySelectItems;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.AdvancedTextCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

class VQBPanelQueryJoins
extends VQBPanelQueryElements<Object> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);

    protected VQBPanelQueryJoins(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Join) {
                    return this.getChildren(inputElement);
                }
                return super.getElements(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Join) {
                    Expression conditions = VQBPanelQueryJoins.this.getJoinConditions((Join)parentElement);
                    if (conditions == null) {
                        return null;
                    }
                    ArrayList<Expression> result = new ArrayList<Expression>();
                    if (VQBUtils.isCompoundExpression((Expression)conditions)) {
                        VQBUtils.collectNestedConditions((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), result, (Expression)conditions, (Expression)conditions);
                    } else {
                        result.add(conditions);
                    }
                    return result.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Join) {
                    return VQBPanelQueryJoins.this.getJoinConditions((Join)element) != null;
                }
                return false;
            }
        };
    }

    @Override
    protected void loadElements() {
        Statement statement = this.getQueryInfo().getParsedQuery();
        if (statement instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)statement;
            ArrayList<FromItem> items = new ArrayList<FromItem>();
            if (select.getFromItem() != null) {
                items.add(select.getFromItem());
            }
            if (select.getJoins() != null) {
                items.addAll(select.getJoins());
            }
            this.elementViewer.setInput(items);
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Object> columnsController) {
        super.fillColumns(columnsController);
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object element) {
                AdvancedTextCellEditor cellEditor = new AdvancedTextCellEditor((Composite)VQBPanelQueryJoins.this.elementViewer.getTree());
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryJoins.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getTextEditor());
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Expression;
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected void setValue(Object element, Object value) {
                String newExpressionString = value.toString();
                if (CommonUtils.isEmpty((String)newExpressionString) && element instanceof Expression) {
                    Expression curExpression = (Expression)element;
                    VQBPanelQueryJoins.this.removeExpressionFromJoin(curExpression);
                }
                if (Objects.equals(element.toString(), newExpressionString)) {
                    return;
                }
                try {
                    Expression curExpression;
                    Object ELEMENT_TYPE;
                    Expression newExpression = SQLSemanticProcessor.parseExpression((String)newExpressionString);
                    PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                    if (plainSelect == null) {
                        throw new DBCException("No plain select. Cannot remove condition.");
                    }
                    if (element instanceof Expression && (ELEMENT_TYPE = VQBPanelQueryJoins.this.getParentElement(curExpression = (Expression)element)) instanceof Join) {
                        Join join = (Join)ELEMENT_TYPE;
                        ERDJoin erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)join);
                        if (erdJoin == null) {
                            throw new DBCException("No JOINs detected. Cannot remove condition.");
                        }
                        erdJoin.updateCondition(curExpression, newExpression);
                        Expression onExpression = VQBUtils.getJoinOnExpression((Join)join);
                        Expression newOn = VQBUtils.updateConditionInExpression((Expression)onExpression, (Expression)curExpression, (Expression)newExpression);
                        join.setOnExpressions(newOn == null ? List.of() : List.of(newOn));
                        erdJoin.setJoin(join);
                        VQBPanelQueryJoins.this.elementViewer.refresh((Object)join);
                        VQBPanelQueryJoins.this.refreshDiagramAndStatement();
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Change join condition error", null, (Throwable)e);
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_conditions_name, VQBMessages.editor_panel_joins_columns_join_conditions_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                Join join = (Join)item;
                FromItem rightItem = join.getRightItem();
                if (rightItem instanceof Table) {
                    Table table = (Table)rightItem;
                    return table.getFullyQualifiedName();
                }
            } else {
                if (item instanceof Table) {
                    Table from = (Table)item;
                    return from.getFullyQualifiedName();
                }
                if (item instanceof Expression) {
                    return item.toString();
                }
            }
            return null;
        }, editingSupport);
        EditingSupport typeEditingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryJoins.this.elementViewer, (Composite)VQBPanelQueryJoins.this.elementViewer.getTree(), new String[0], 12);
                VQBJoinType[] types = VQBJoinType.values();
                ArrayList<String> typeNames = new ArrayList<String>();
                VQBJoinType[] vQBJoinTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    VQBJoinType type = vQBJoinTypeArray[n2];
                    if (type.isSupported()) {
                        typeNames.add(type.getName());
                    }
                    ++n2;
                }
                editor.setItems(typeNames.toArray(new String[0]));
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryJoins.this.presentation.getSQLEditor().getSite(), (Control)editor.getControl());
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Join;
            }

            protected Object getValue(Object element) {
                if (element instanceof Join) {
                    return VQBJoinType.getByJoin((Join)((Join)element)).getName();
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                VQBJoinType newType;
                Join join;
                VQBJoinType oldType;
                if (element instanceof Join && (oldType = VQBJoinType.getByJoin((Join)(join = (Join)element))) != (newType = VQBJoinType.getByName((String)((String)value)))) {
                    ERDJoin erdJoin;
                    newType.setJoinType(join);
                    if (newType != VQBJoinType.SIMPLE && (erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)join)) != null) {
                        join.setOnExpressions((Collection)erdJoin.makeExpressionFromConditions());
                    }
                    VQBPanelQueryJoins.this.refreshDiagramAndStatement();
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_type_name, VQBMessages.editor_panel_joins_columns_join_type_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                Join join = (Join)item;
                return VQBJoinType.getByJoin((Join)join).getName();
            }
            if (item instanceof Table) {
                return VQBMessages.editor_panel_joins_columns_from_name;
            }
            return null;
        }, typeEditingSupport);
        VQBPanelQueryElements.TextEditingSupport<Object> aliasEditingSupport = new VQBPanelQueryElements.TextEditingSupport<Object>((VQBPanelQueryElements)this){

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof Join || element instanceof Table;
            }

            @Override
            protected String convertExpressionToString(Object object) {
                if (object instanceof Join) {
                    Join join = (Join)object;
                    Alias alias = join.getRightItem().getAlias();
                    return alias == null ? "" : alias.getName();
                }
                if (object instanceof Table) {
                    Table from = (Table)object;
                    Alias alias = from.getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return null;
            }

            @Override
            protected boolean validate(Object element, Object alias) {
                Statement statement = VQBPanelQueryJoins.this.getQueryInfo().getParsedQuery();
                if (statement instanceof PlainSelect) {
                    Alias fromAlias;
                    PlainSelect select = (PlainSelect)statement;
                    if (select.getFromItem() != null && (fromAlias = select.getFromItem().getAlias()) != null && fromAlias.getName().equals(alias)) {
                        return false;
                    }
                    List joins = select.getJoins();
                    if (joins != null) {
                        for (Join join : joins) {
                            if (join.getRightItem() == null || join.getRightItem().getAlias() == null || !join.getRightItem().getAlias().getName().equals(alias)) continue;
                            return false;
                        }
                    }
                }
                return super.validate(element, alias);
            }

            @Override
            protected void updateElementText(Object join, String text) {
                if (join instanceof Join) {
                    Join j = (Join)join;
                    Alias alias = CommonUtils.isEmpty((String)text) ? null : new Alias(text);
                    FromItem fromItem = j.getRightItem();
                    if (fromItem instanceof Table) {
                        Table table = (Table)fromItem;
                        VQBUtils.updateTableAlias((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), (Table)table, (Alias)alias);
                    }
                } else if (join instanceof Table) {
                    Table from = (Table)join;
                    Alias alias = CommonUtils.isEmpty((String)text) ? null : new Alias(text);
                    VQBUtils.updateTableAlias((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), (Table)from, (Alias)alias);
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_alias_name, VQBMessages.editor_panel_joins_columns_alias_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                Join join = (Join)item;
                Alias alias = join.getRightItem().getAlias();
                return alias == null ? null : alias.getName();
            }
            if (item instanceof Table) {
                Table table = (Table)item;
                Alias alias = table.getAlias();
                return alias == null ? null : alias.getName();
            }
            return null;
        }, (EditingSupport)aliasEditingSupport);
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_add_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                if (plainSelect == null) {
                    DBWorkbench.getPlatformUI().showError("Cannot find plain select", "Cannot find plain select");
                    return;
                }
                Join parentJoin = null;
                Object selectedElement = VQBPanelQueryJoins.this.getSelectedElement();
                EqualsTo newExpression = new EqualsTo();
                newExpression.setLeftExpression((Expression)new LongValue(1L));
                newExpression.setRightExpression((Expression)new LongValue(1L));
                Object ELEMENT_TYPE = VQBPanelQueryJoins.this.getParentElement();
                if (ELEMENT_TYPE instanceof Join) {
                    Join parentJoinTemp;
                    parentJoin = parentJoinTemp = (Join)ELEMENT_TYPE;
                } else if (selectedElement instanceof Join) {
                    Join selectedJoin;
                    parentJoin = selectedJoin = (Join)selectedElement;
                }
                if (parentJoin == null) {
                    DBWorkbench.getPlatformUI().showError("Cannot find parent join", "Cannot find parent join");
                    return;
                }
                ERDJoin erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)parentJoin);
                if (erdJoin == null) {
                    return;
                }
                erdJoin.addCondition((Expression)newExpression);
                erdJoin.updateStatementJoin(parentJoin);
                VQBPanelQueryJoins.this.refreshDiagramAndStatement();
            }

            public boolean isEnabled() {
                Join join;
                Object ELEMENT_TYPE;
                return VQBPanelQueryJoins.this.getSelectedElement() instanceof Expression || (ELEMENT_TYPE = VQBPanelQueryJoins.this.getSelectedElement()) instanceof Join && !(join = (Join)ELEMENT_TYPE).isSimple();
            }
        });
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_remove, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE)){

            public void run() {
                ERDJoin erdJoin;
                Object selectedElement = VQBPanelQueryJoins.this.getSelectedElement();
                if (selectedElement instanceof Expression) {
                    Expression curExpression = (Expression)selectedElement;
                    VQBPanelQueryJoins.this.removeExpressionFromJoin(curExpression);
                } else if (selectedElement instanceof Join && (erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)((Join)selectedElement))) != null) {
                    PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                    if (plainSelect == null) {
                        log.error((Object)"No plain select. Cannot remove condition.");
                        return;
                    }
                    List joins = plainSelect.getJoins();
                    if (joins.isEmpty()) {
                        log.error((Object)"No JOINs detected. Cannot remove condition.");
                        return;
                    }
                    UIUtils.syncExec(() -> {
                        erdJoin.getTargetEntity().removeReferenceAssociation((ERDAssociation)erdJoin, true);
                        erdJoin.getSourceEntity().removeAssociation((ERDAssociation)erdJoin, true);
                    });
                    joins.remove(selectedElement);
                }
                VQBPanelQueryJoins.this.refreshDiagramAndStatement();
            }

            public boolean isEnabled() {
                return VQBPanelQueryJoins.this.getSelectedElement() instanceof Expression || VQBPanelQueryJoins.this.getSelectedElement() instanceof Join;
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_order_by_action_move_up, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQueryJoins.this.moveJoin(-1);
            }

            public boolean isEnabled() {
                Object selectedElement;
                PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                if (plainSelect != null && (selectedElement = VQBPanelQueryJoins.this.getSelectedElement()) instanceof Join) {
                    Join join = (Join)selectedElement;
                    List joins = plainSelect.getJoins();
                    return joins != null && joins.indexOf(join) > 0;
                }
                return false;
            }
        });
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_order_by_action_move_down, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQueryJoins.this.moveJoin(1);
            }

            public boolean isEnabled() {
                Object selectedElement;
                PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                if (plainSelect != null && (selectedElement = VQBPanelQueryJoins.this.getSelectedElement()) instanceof Join) {
                    Join join = (Join)selectedElement;
                    List joins = plainSelect.getJoins();
                    return joins != null && joins.indexOf(join) < joins.size() - 1;
                }
                return false;
            }
        });
    }

    private void moveJoin(int shift) {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof Join) {
            List joins;
            Join selectedJoin = (Join)selectedElement;
            PlainSelect plainSelect = this.getPlainSelect();
            if (plainSelect != null && (joins = plainSelect.getJoins()) != null) {
                int oldIndex = joins.indexOf(selectedJoin);
                int newIndex = oldIndex + shift;
                VQBEditorQueryPanel queryPanel = this.presentation.getQueryPanel();
                if (queryPanel != null && newIndex >= 0 && newIndex < joins.size()) {
                    if (!this.canMoveJoin(plainSelect, selectedJoin, oldIndex, newIndex)) {
                        DBWorkbench.getPlatformUI().showError(VQBMessages.editor_panel_joins_move_error_title, NLS.bind((String)VQBMessages.editor_panel_joins_move_error_message, (Object)VQBUtils.getFromItemName((FromItem)((Join)joins.get(oldIndex)).getFromItem()), (Object)VQBUtils.getFromItemName((FromItem)((Join)joins.get(newIndex)).getFromItem())));
                        return;
                    }
                    if (joins.remove(selectedJoin)) {
                        joins.add(newIndex, selectedJoin);
                        queryPanel.refreshActions();
                        this.refreshDiagramAndStatement();
                    }
                }
            }
        }
    }

    private boolean canMoveJoin(PlainSelect plainSelect, Join join, int oldIndex, int newIndex) {
        int i;
        List joins = plainSelect.getJoins();
        if (joins == null) {
            return false;
        }
        FromItem currentJoinTable = join.getRightItem();
        if (currentJoinTable == null) {
            return true;
        }
        if (newIndex > oldIndex) {
            i = oldIndex + 1;
            while (i <= newIndex) {
                if (this.joinReferencesTable((Join)joins.get(i), currentJoinTable)) {
                    return false;
                }
                ++i;
            }
        }
        if (newIndex < oldIndex) {
            i = newIndex;
            while (i < oldIndex) {
                FromItem otherTable = ((Join)joins.get(i)).getRightItem();
                if (otherTable != null && this.joinReferencesTable(join, otherTable)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean joinReferencesTable(Join join, FromItem table) {
        Expression onExpression = VQBUtils.getJoinOnExpression((Join)join);
        if (onExpression == null) {
            return false;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        this.collectColumns(onExpression, columns);
        for (Column column : columns) {
            if (column.getTable() == null || !(table instanceof Table)) continue;
            Table targetTable = (Table)table;
            if (column.getTable().equals(targetTable)) {
                return true;
            }
            if (targetTable.getAlias() == null || !column.getTable().getName().equals(targetTable.getAlias().getName())) continue;
            return true;
        }
        return false;
    }

    private void collectColumns(Expression expression, List<Column> columns) {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            columns.add(column);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)expression;
            this.collectColumns(binaryExpr.getLeftExpression(), columns);
            this.collectColumns(binaryExpr.getRightExpression(), columns);
        }
    }

    private void removeExpressionFromJoin(Expression curExpression) {
        Join join;
        Expression onExpression;
        Object ELEMENT_TYPE = this.getParentElement(curExpression);
        if (ELEMENT_TYPE instanceof Join && VQBUtils.isPartOf((Expression)curExpression, (Expression)(onExpression = VQBUtils.getJoinOnExpression((Join)(join = (Join)ELEMENT_TYPE))))) {
            Expression newOn = onExpression == null || onExpression == curExpression ? null : VQBUtils.removeConditionFromExpression((Expression)onExpression, (Expression)curExpression);
            join.setOnExpressions(newOn == null ? List.of() : List.of(newOn));
            ERDJoin erdJoin = VQBUtils.findERDJoin((ERDDiagram)this.presentation.getVQBEditor().getDiagram(), (Join)join);
            if (erdJoin != null) {
                erdJoin.removeCondition(curExpression);
            }
        }
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return null;
    }

    private Expression getJoinConditions(Join join) {
        if (join.isSimple()) {
            return null;
        }
        return VQBUtils.getJoinOnExpression((Join)join);
    }
}

