/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.QueryExpressionTransfer;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.CustomExpression;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

abstract class VQBPanelQueryElements<ELEMENT_TYPE>
extends TabbedFolderPage
implements IAdaptable {
    private static final Log log = Log.getLog(VQBPanelQueryElements.class);
    protected final VQBEditorPresentation presentation;
    private SashForm viewDivider;
    protected TreeViewer elementViewer;
    private ViewerColumnController<Object, ELEMENT_TYPE> columnsController;
    private volatile boolean isNewElement;
    private SQLEditorBase sqlEditor;
    private StringEditorInput sqlEditorInput;
    private AbstractJob queryUpdateJob;

    protected VQBPanelQueryElements(VQBEditorPresentation presentation) {
        this.presentation = presentation;
    }

    protected VQBQueryInfo getQueryInfo() {
        return this.presentation.getVQBEditor().getQueryInfo();
    }

    protected boolean supportsTextView() {
        return false;
    }

    protected String getEditorText() {
        return "-- SQL text";
    }

    void toggleEditMode() {
        if (!this.supportsTextView() || this.viewDivider == null) {
            return;
        }
        Control curActive = this.viewDivider.getMaximizedControl();
        if (curActive == this.elementViewer.getControl()) {
            this.viewDivider.setMaximizedControl((Control)this.sqlEditor.getEditorControlWrapper());
            this.updateEditText();
        } else {
            this.viewDivider.setMaximizedControl(this.elementViewer.getControl());
            this.elementViewer.refresh();
        }
        this.viewDivider.getMaximizedControl().setFocus();
    }

    private void updateEditText() {
        this.sqlEditorInput.setText(this.getEditorText());
        this.sqlEditor.setInput((IEditorInput)this.sqlEditorInput);
        this.sqlEditor.reloadSyntaxRules();
    }

    private void updateQueryFromText() {
        if (this.queryUpdateJob == null) {
            this.queryUpdateJob = new AbstractJob("Update VQB query from text"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    UIUtils.asyncExec(() -> {
                        String text = VQBPanelQueryElements.this.sqlEditor.getDocument().get();
                        try {
                            VQBPanelQueryElements.this.updateQueryFromElementsText(text);
                        }
                        catch (DBException e) {
                            log.error((Object)e);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.queryUpdateJob.cancel();
        }
        this.queryUpdateJob.schedule(500L);
    }

    protected void updateQueryFromElementsText(String text) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public void createControl(Composite parent) {
        Composite mainComposite = parent;
        if (this.supportsTextView()) {
            this.viewDivider = new SashForm(parent, 512);
            mainComposite = this.viewDivider;
        }
        this.elementViewer = new TreeViewer(mainComposite, 66304);
        Tree tree = this.elementViewer.getTree();
        tree.setHeaderVisible(true);
        if (!UIStyles.isDarkTheme()) {
            tree.setLinesVisible(true);
        }
        this.elementViewer.setContentProvider((IContentProvider)this.makeContentProvider());
        this.elementViewer.addSelectionChangedListener(event -> {
            VQBEditorQueryPanel queryPanel = this.presentation.getQueryPanel();
            if (queryPanel != null) {
                queryPanel.updateActions();
            }
        });
        if (this.supportsElementsMove()) {
            Transfer[] types = new Transfer[]{QueryExpressionTransfer.getInstance()};
            int operations = 7;
            DragSource dndSource = new DragSource(this.elementViewer.getControl(), operations);
            dndSource.setTransfer(types);
            dndSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

                public void dragSetData(DragSourceEvent event) {
                    event.data = VQBPanelQueryElements.this.getSelectedElement();
                }
            });
            DropTarget dndTarget = new DropTarget(this.elementViewer.getControl(), operations);
            dndTarget.setTransfer(types);
            dndTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void drop(DropTargetEvent event) {
                    if (event.item == null) {
                        return;
                    }
                    Object toElement = event.item.getData();
                    if (toElement != event.data) {
                        VQBPanelQueryElements.this.moveElementTo(event.data, toElement);
                    }
                }
            });
        }
        if (this.supportsTextView()) {
            this.sqlEditor = new SQLEditorBase(){

                public DBCExecutionContext getExecutionContext() {
                    return VQBPanelQueryElements.this.presentation.getSQLEditor().getExecutionContext();
                }

                public SQLScriptElement extractQueryAtPos(int currentPos) {
                    VQBQueryInfo queryInfo = VQBPanelQueryElements.this.presentation.getVQBEditor().getQueryInfo();
                    return queryInfo == null ? null : queryInfo.getQuery();
                }
            };
            this.sqlEditorInput = new StringEditorInput("SQL Text", (CharSequence)"", false, GeneralUtils.getDefaultFileEncoding());
            try {
                this.sqlEditor.init((IEditorSite)new SubEditorSite((IWorkbenchPartSite)this.presentation.getSQLEditor().getEditorSite()), (IEditorInput)this.sqlEditorInput);
                this.sqlEditor.createPartControl((Composite)this.viewDivider);
                this.sqlEditor.reloadSyntaxRules();
            }
            catch (PartInitException e2) {
                DBWorkbench.getPlatformUI().showError("Create error", "Can't create SQL preview editor", (Throwable)e2);
            }
            StyledText sqlEditorControl = this.sqlEditor.getEditorControl();
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.sqlEditor.getSite(), (Control)sqlEditorControl);
            if (sqlEditorControl != null) {
                sqlEditorControl.addModifyListener(e -> this.updateQueryFromText());
            }
            this.viewDivider.setMaximizedControl(this.elementViewer.getControl());
            this.viewDivider.addDisposeListener(e -> this.sqlEditor.dispose());
        }
    }

    protected boolean supportsElementsMove() {
        return false;
    }

    protected void moveElementTo(ELEMENT_TYPE srcElement, ELEMENT_TYPE dsyElement) {
        throw new IllegalStateException("Move not supported");
    }

    protected void fillPanelContributions(IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.presentation.getSQLEditor().getEditorSite(), (String)"com.dbeaver.ee.vqb.ui.show.preview", (int)32));
        if (this.supportsTextView()) {
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.presentation.getSQLEditor().getEditorSite(), (String)"com.dbeaver.ee.vqb.ui.show.panel.sql", (int)32));
        }
        contributionManager.add((IContributionItem)new Separator());
    }

    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }

    public void setFocus() {
        this.elementViewer.getControl().setFocus();
    }

    public void aboutToBeShown() {
        if (this.columnsController == null) {
            this.columnsController = new ViewerColumnController(((Object)((Object)this)).getClass().getSimpleName(), (ColumnViewer)this.elementViewer);
            this.columnsController.setDefaultIcon(this.getDefaultIcon());
            this.fillColumns(this.columnsController);
            this.loadElements();
            this.columnsController.createColumns();
            Control control = this.elementViewer.getControl();
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(control);
            menuMgr.addMenuListener(manager -> {
                if (this.columnsController.isClickOnHeader()) {
                    this.columnsController.fillConfigMenu((IContributionManager)manager);
                    manager.add((IContributionItem)new Separator());
                } else {
                    this.fillPanelContributions((IContributionManager)manager);
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            control.setMenu(menu);
            control.addDisposeListener(e -> menuMgr.dispose());
        }
    }

    public void aboutToBeHidden() {
    }

    protected void loadElements() {
    }

    protected void fillColumns(ViewerColumnController<Object, ELEMENT_TYPE> columnsController) {
    }

    @Nullable
    protected DBIcon getDefaultIcon() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Nullable
    protected PlainSelect getPlainSelect() {
        VQBQueryInfo queryInfo = this.getQueryInfo();
        return queryInfo == null ? null : queryInfo.getPlainSelect();
    }

    public ELEMENT_TYPE getSelectedElement() {
        ISelection selection = this.elementViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            return (ELEMENT_TYPE)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public ELEMENT_TYPE getParentElement() {
        TreeItem parentItem;
        Object parent = null;
        TreeItem[] selection = this.elementViewer.getTree().getSelection();
        if (selection.length == 1 && (parentItem = selection[0].getParentItem()) != null) {
            parent = parentItem.getData();
        }
        return (ELEMENT_TYPE)parent;
    }

    public ELEMENT_TYPE getParentElement(Object element) {
        TreeItem ti;
        TreeItem parentItem;
        Widget item = this.elementViewer.testFindItem(element);
        if (item instanceof TreeItem && (parentItem = (ti = (TreeItem)item).getParentItem()) != null) {
            return (ELEMENT_TYPE)parentItem.getData();
        }
        return null;
    }

    public void addNewElement(ELEMENT_TYPE element, int columnIndex) {
        this.elementViewer.refresh();
        this.elementViewer.expandAll();
        this.elementViewer.editElement(element, columnIndex);
    }

    public void refreshElementsFromStatement() {
        if (this.elementViewer != null) {
            this.elementViewer.getTree().setRedraw(false);
            try {
                this.loadElements();
            }
            finally {
                this.elementViewer.getTree().setRedraw(true);
            }
        }
    }

    public void refreshQueryTextFromStatement() {
        this.refreshElementsFromStatement();
        VQBEditorQueryPanel queryPanel = this.presentation.getQueryPanel();
        if (queryPanel != null) {
            queryPanel.refreshFromStatement(false);
        }
        this.presentation.getVQBEditor().markEditorDirty();
    }

    protected void refreshDiagramAndStatement() {
        this.presentation.getVQBEditor().scheduleQueryGenerator();
        this.presentation.getVQBEditor().refreshDiagram(false, true, true);
    }

    public void editElement(Object element) {
        int index = this.columnsController.getEditableColumnIndex(element);
        if (index >= 0) {
            this.elementViewer.editElement(element, index);
        }
    }

    boolean isTextEditMode() {
        return this.viewDivider != null && this.sqlEditor != null && this.viewDivider.getMaximizedControl() == this.sqlEditor.getEditorControlWrapper();
    }

    protected abstract class DeleteActionAbstract
    extends Action {
        DeleteActionAbstract() {
            super("Remove", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE));
        }

        public void run() {
            List container;
            Object selectItem = VQBPanelQueryElements.this.getSelectedElement();
            if (selectItem != null && (container = this.getElementsContainer()) != null) {
                container.remove(selectItem);
                VQBPanelQueryElements.this.refreshDiagramAndStatement();
            }
        }

        public boolean isEnabled() {
            return VQBPanelQueryElements.this.getSelectedElement() != null;
        }

        protected abstract List<ELEMENT_TYPE> getElementsContainer();
    }

    protected abstract class ExpressionEditingSupport<ITEM>
    extends EditingSupport {
        public ExpressionEditingSupport() {
            super((ColumnViewer)VQBPanelQueryElements.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)VQBPanelQueryElements.this.elementViewer.getTree());
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryElements.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return this.convertExpressionToString(element);
        }

        protected final void setValue(Object element, Object value) {
            String newValue = (String)value;
            if (!VQBPanelQueryElements.this.isNewElement && CommonUtils.equalObjects((Object)this.getValue(element), (Object)newValue)) {
                return;
            }
            if (CommonUtils.isEmpty((String)newValue)) {
                newValue = CommonUtils.toString((Object)element);
            }
            VQBPanelQueryElements.this.isNewElement = false;
            if (this.setValue(element, newValue.trim())) {
                VQBPanelQueryElements.this.refreshDiagramAndStatement();
            }
        }

        protected boolean setValue(ITEM item, String text) {
            try {
                Object parent = VQBPanelQueryElements.this.getParentElement();
                Expression newExpression = this.parseNewExpression(text);
                return this.updateElementExpression(parent, item, newExpression);
            }
            catch (DBCException e) {
                DBWorkbench.getPlatformUI().showError("Parse error", "Error parsing expression", (Throwable)e);
                return false;
            }
        }

        protected Expression parseNewExpression(String text) throws DBCException {
            if (CommonUtils.isEmpty((String)text)) {
                return null;
            }
            try {
                return SQLSemanticProcessor.parseExpression((String)text, (boolean)false);
            }
            catch (DBCException dBCException) {
                return new CustomExpression(text);
            }
        }

        protected String convertExpressionToString(ITEM item) {
            return item.toString();
        }

        protected abstract boolean updateElementExpression(ELEMENT_TYPE var1, ITEM var2, Expression var3);
    }

    protected abstract class TextEditingSupport<ITEM>
    extends EditingSupport {
        public TextEditingSupport() {
            super((ColumnViewer)VQBPanelQueryElements.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)VQBPanelQueryElements.this.elementViewer.getTree());
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryElements.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return this.convertExpressionToString(element);
        }

        protected void setValue(Object element, Object value) {
            String newValue = (String)value;
            if (!VQBPanelQueryElements.this.isNewElement && CommonUtils.equalObjects((Object)this.getValue(element), (Object)newValue)) {
                return;
            }
            if (!this.validate(element, value)) {
                return;
            }
            this.updateElementText(element, newValue);
            VQBPanelQueryElements.this.isNewElement = false;
            VQBPanelQueryElements.this.refreshDiagramAndStatement();
        }

        protected abstract String convertExpressionToString(ITEM var1);

        protected abstract void updateElementText(ITEM var1, String var2);

        protected boolean validate(Object element, Object value) {
            return true;
        }
    }
}

