/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.ui.views;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.QueryTrace;
import com.datastax.oss.driver.api.core.cql.TraceEvent;
import com.dbeaver.db.ycql.exec.CasQueryTrace;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelBase;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class CasQueryTracePanel
extends ResultSetPanelBase {
    private static final Log log = Log.getLog(CasQueryTracePanel.class);
    public static final String PANEL_ID = "ycql-query-trace";
    private IResultSetPresentation presentation;
    private Table eventsTable;
    private CasQueryTrace lastTrace;
    private Text textQueriesHost;
    private Text textConsistencyLevel;

    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        CTabFolder traceFolders = new CTabFolder(parent, 0x800080);
        traceFolders.setLayoutData((Object)new GridData(1808));
        CTabItem eventsTab = new CTabItem(traceFolders, 0);
        eventsTab.setText("Events");
        this.eventsTable = new Table((Composite)traceFolders, 65536);
        this.eventsTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)this.eventsTable, (int)0, (String)"Event");
        UIUtils.createTableColumn((Table)this.eventsTable, (int)0, (String)"Time");
        UIUtils.createTableColumn((Table)this.eventsTable, (int)0, (String)"Source");
        UIUtils.createTableColumn((Table)this.eventsTable, (int)0, (String)"Thread");
        UIUtils.packColumns((Table)this.eventsTable);
        eventsTab.setControl((Control)this.eventsTable);
        CTabItem infoTab = new CTabItem(traceFolders, 0);
        infoTab.setText("Info");
        Composite infoPH = new Composite((Composite)traceFolders, 0);
        infoPH.setLayout((Layout)new GridLayout(2, false));
        infoTab.setControl((Control)infoPH);
        this.textQueriesHost = UIUtils.createLabelText((Composite)infoPH, (String)"Queried host", (String)"", (int)8, (Object)new GridData(768));
        this.textConsistencyLevel = UIUtils.createLabelText((Composite)infoPH, (String)"Consistency level", (String)"", (int)8, (Object)new GridData(768));
        traceFolders.setSelection(0);
        return traceFolders;
    }

    public boolean isDirty() {
        return false;
    }

    public void activatePanel() {
        this.refresh(false);
    }

    public void deactivatePanel() {
    }

    public void setFocus() {
    }

    public void refresh(boolean force) {
        try {
            DBCTrace trace = this.presentation.getController().getModel().getTrace();
            if (trace == this.lastTrace) {
                return;
            }
            if (trace instanceof CasQueryTrace) {
                this.lastTrace = (CasQueryTrace)trace;
                this.eventsTable.removeAll();
                final ExecutionInfo ei = ((CasQueryTrace)trace).getExecutionInfo();
                if (ei.getStatement() != null) {
                    this.textQueriesHost.setText(ei.getStatement().getNode() == null ? "N/A" : ei.getRequest().getNode().getDatacenter());
                    this.textConsistencyLevel.setText(ei.getStatement().getConsistencyLevel() == null ? "N/A" : ei.getStatement().getConsistencyLevel().name());
                    ei.getStatement();
                }
                new AbstractJob("Get Cassandra query trace"){
                    private int tryCount;
                    private CompletionStage<QueryTrace> asyncRunner;
                    {
                        super($anonymous0);
                        this.tryCount = 0;
                        this.setUser(false);
                    }

                    protected IStatus run(DBRProgressMonitor monitor) {
                        try {
                            Thread.sleep(100L);
                            this.asyncRunner = ei.getQueryTraceAsync();
                            if (this.asyncRunner.toCompletableFuture().isCancelled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (ei.getTracingId() == null) {
                                log.warn((Object)"Yugabyte query trace was disabled");
                                return Status.OK_STATUS;
                            }
                            QueryTrace queryTrace = this.asyncRunner.toCompletableFuture().get(20L, TimeUnit.SECONDS);
                            if (queryTrace == null) {
                                ++this.tryCount;
                                if (this.tryCount >= 5) {
                                    log.warn((Object)"Yugabyte query trace is not available");
                                    return Status.OK_STATUS;
                                }
                                this.schedule(500L);
                                return Status.OK_STATUS;
                            }
                            queryTrace.getEvents();
                            UIUtils.syncExec(() -> CasQueryTracePanel.this.loadQueryTrace(queryTrace));
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            return GeneralUtils.makeExceptionStatus((Throwable)e);
                        }
                    }

                    protected void canceling() {
                        this.asyncRunner.toCompletableFuture().cancel(true);
                    }
                }.schedule();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void loadQueryTrace(QueryTrace queryTrace) {
        if (this.eventsTable.isDisposed()) {
            return;
        }
        this.eventsTable.setRedraw(false);
        try {
            for (TraceEvent event : queryTrace.getEvents()) {
                TableItem item = new TableItem(this.eventsTable, 0);
                item.setText(0, event.getActivity());
                item.setText(1, String.valueOf(event.getSourceElapsedMicros()));
                item.setText(2, event.getSource() == null ? "N/A" : event.getSource().toString());
                item.setText(3, event.getThreadName() == null ? "N/A" : event.getThreadName());
            }
            TableColumn[] tableColumnArray = this.eventsTable.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
        finally {
            this.eventsTable.setRedraw(true);
        }
    }

    public void contributeActions(IContributionManager manager) {
    }
}

