/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.ui.views;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.dbeaver.db.ycql.ui.internal.CasUIActivator;
import com.dbeaver.db.ycql.ui.internal.CasUIMessages;
import com.dbeaver.db.ycql.ui.views.CasSocketSettingsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class CasConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = CasUIActivator.getImageDescriptor("icons/yugabyte_logo.png");
    protected Text hostText;
    protected Text portText;
    protected Text keyspaceText;
    private Combo defConsistencyLevel;
    private Text datacenterText;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.setControl((Control)this.createGeneralTab(composite));
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Composite configGroup = new Composite(parent, 0);
        configGroup.setLayout((Layout)new GridLayout(1, false));
        configGroup.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)configGroup, (String)CasUIMessages.connection_page_group_connection_setings, (int)4, (int)768, (int)0);
        this.createSettingsPanel(textListener, (Composite)settingsGroup);
        this.createAuthPanel(configGroup, 1);
        Group miscGroup = UIUtils.createControlGroup((Composite)configGroup, (String)CasUIMessages.connection_page_group_misc, (int)2, (int)768, (int)0);
        this.defConsistencyLevel = UIUtils.createLabelCombo((Composite)miscGroup, (String)CasUIMessages.connection_page_label_combo_default_consistency_level, (String)CasUIMessages.connection_page_label_combo_tip_default_consistency_level, (int)12);
        DefaultConsistencyLevel[] defaultConsistencyLevelArray = DefaultConsistencyLevel.values();
        int n = defaultConsistencyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultConsistencyLevel cl = defaultConsistencyLevelArray[n2];
            this.defConsistencyLevel.add(cl.name());
            ++n2;
        }
        this.createDriverPanel(configGroup);
        return configGroup;
    }

    protected void createSettingsPanel(ModifyListener textListener, Composite settingsGroup) {
        this.hostText = UIUtils.createLabelText((Composite)settingsGroup, (String)CasUIMessages.connection_page_label_text_host, (String)"", (int)2048);
        this.hostText.setToolTipText(CasUIMessages.connection_page_tip_text_contact_point);
        GridData gd = new GridData(768);
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)settingsGroup, (String)CasUIMessages.connection_page_label_text_port, (String)"", (int)2048);
        gd = new GridData(768);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.keyspaceText = UIUtils.createLabelText((Composite)settingsGroup, (String)CasUIMessages.connection_page_label_text_keyspace, (String)"", (int)2048);
        this.keyspaceText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.keyspaceText);
        this.keyspaceText.addModifyListener(textListener);
        this.datacenterText = UIUtils.createLabelText((Composite)settingsGroup, (String)CasUIMessages.connection_page_label_text_datacenter, (String)"", (int)2048);
        this.datacenterText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.datacenterText);
        this.datacenterText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)settingsGroup, (int)3, (int)1);
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && !this.hostText.getText().isEmpty();
    }

    public void loadSettings() {
        String clName;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            Object hostName = !CommonUtils.isEmpty((String)connectionInfo.getHostName()) ? connectionInfo.getHostName() : "localhost";
            String extraCP = connectionInfo.getProviderProperty("@dbeaver-connection.points@");
            if (!CommonUtils.isEmpty((String)extraCP)) {
                hostName = (String)hostName + "," + extraCP;
            }
            this.hostText.setText(CommonUtils.notEmpty((String)hostName));
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.keyspaceText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.keyspaceText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.keyspaceText.setText("system");
            }
        }
        if (this.datacenterText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.datacenter@"))) {
                this.datacenterText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.datacenter@")));
            } else {
                this.datacenterText.setText("");
            }
        }
        if (CommonUtils.isEmpty((String)(clName = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-default.consistency.level@"))))) {
            this.defConsistencyLevel.setText(this.getDefaultConsistencyLevel().name());
        } else {
            this.defConsistencyLevel.setText(clName);
        }
        this.activated = true;
    }

    @NotNull
    protected ConsistencyLevel getDefaultConsistencyLevel() {
        return ConsistencyLevel.ONE;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            String hostNames = this.hostText.getText().trim();
            int divPos = hostNames.indexOf(",");
            if (divPos != -1) {
                connectionInfo.setProviderProperty("@dbeaver-connection.points@", hostNames.substring(divPos + 1).trim());
                hostNames = hostNames.substring(0, divPos).trim();
            } else {
                connectionInfo.removeProviderProperty("@dbeaver-connection.points@");
            }
            connectionInfo.setHostName(hostNames);
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.keyspaceText != null) {
            connectionInfo.setDatabaseName(this.keyspaceText.getText().trim());
        }
        if (this.datacenterText != null) {
            connectionInfo.setProviderProperty("@dbeaver-cas.net.datacenter@", this.datacenterText.getText().trim());
        }
        connectionInfo.setProviderProperty("@dbeaver-default.consistency.level@", String.valueOf(this.defConsistencyLevel.getText()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new CasSocketSettingsPage(this.site.getDriver().getFullName())};
    }
}

