/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dsql.model;

import com.dbeaver.db.dsql.model.DSQLConstants;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSSimple;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dsql.DsqlUtilities;
import software.amazon.awssdk.services.dsql.model.GenerateAuthTokenRequest;

public class AuthModelDSQL
extends AuthModelAWSSimple {
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (!CommonUtils.isEmpty((String)configuration.getUserPassword())) {
            return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
        }
        String region = credentials.getRegion();
        if (CommonUtils.isEmpty((String)region)) {
            region = configuration.getAuthProperty("iam.region");
        }
        if (CommonUtils.isEmpty((String)region)) {
            region = Region.AWS_GLOBAL.id();
        }
        credentials.setRegion(region);
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        this.initDSQLTokenAuthentication(monitor, credentials, configuration, credentialsProvider);
        if (credentials.getUserName() != null) {
            connProperties.put("user", credentials.getUserName());
        }
        if (credentials.getUserPassword() != null) {
            connProperties.put("password", credentials.getUserPassword());
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
    }

    public boolean supportsDatabaseUser() {
        return true;
    }

    private void initDSQLTokenAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull AwsCredentialsProvider credentialsProvider) throws DBException {
        String regionStr = credentials.getRegion();
        String hostName = configuration.getHostName();
        String userName = configuration.getUserName();
        DsqlUtilities dsqlUtilities = DsqlUtilities.builder().region(Region.of((String)regionStr)).credentialsProvider(credentialsProvider).build();
        String token = (String)AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)monitor, (AuthModelAWSCredentials)credentials, () -> AuthModelDSQL.isAdminUser(configuration) ? dsqlUtilities.generateDbConnectAdminAuthToken(builder -> {
            GenerateAuthTokenRequest.Builder builder2 = builder.hostname(hostName).region(Region.of((String)regionStr));
        }) : dsqlUtilities.generateDbConnectAuthToken(builder -> {
            GenerateAuthTokenRequest.Builder builder2 = builder.hostname(hostName).region(Region.of((String)regionStr));
        }));
        credentials.setUserName(userName);
        credentials.setUserPassword(token);
    }

    private static boolean isAdminUser(DBPConnectionConfiguration configuration) {
        return CommonUtils.equalObjects((Object)configuration.getUserName(), (Object)DSQLConstants.ADMIN_USERNAME);
    }
}

