/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mysql.model;

import com.dbeaver.db.mysql.model.MySQLDataSourceExt;
import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class MySQLChangeUserPasswordManager
implements DBAUserPasswordManager {
    private static final Log log = Log.getLog(MySQLChangeUserPasswordManager.class);
    private final MySQLDataSourceExt dataSource;

    MySQLChangeUserPasswordManager(MySQLDataSourceExt dataSource) {
        this.dataSource = dataSource;
    }

    public void changeUserPassword(@NotNull DBRProgressMonitor monitor, @NotNull String userName, @NotNull String newPassword, @NotNull String oldPassword) throws DBException {
        Object hostName;
        JDBCSession session;
        Object var7_11;
        String fullUserName = null;
        try {
            Throwable throwable = null;
            var7_11 = null;
            try {
                session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.dataSource, (String)"Read current user full name");
                try {
                    String[] strings;
                    String currentUserName = JDBCUtils.queryString((Connection)session, (String)"SELECT CURRENT_USER()", (Object[])new Object[0]);
                    if (CommonUtils.isNotEmpty((String)currentUserName) && currentUserName.contains("@") && (strings = currentUserName.split("@")).length == 2) {
                        fullUserName = SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)strings[0]) + "@" + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)strings[1]);
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error reading current user info.", (Throwable)e);
        }
        if (CommonUtils.isEmpty(fullUserName)) {
            hostName = this.dataSource.getContainer().getConnectionConfiguration().getHostName();
            fullUserName = SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)userName) + "@" + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)hostName);
        }
        try {
            hostName = null;
            var7_11 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Change current user password");
                try {
                    session.enableLogging(false);
                    String sql = MySQLUtils.isAlterUSerSupported((MySQLDataSource)this.dataSource) ? "ALTER USER " + fullUserName + " IDENTIFIED BY " + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)CommonUtils.notEmpty((String)newPassword)) : "SET PASSWORD FOR " + fullUserName + " = PASSWORD(" + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)newPassword) + ")";
                    JDBCUtils.executeSQL((Connection)session, (String)sql, (Object[])new Object[0]);
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (hostName == null) {
                    hostName = throwable;
                } else if (hostName != throwable) {
                    ((Throwable)hostName).addSuppressed(throwable);
                }
                throw hostName;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error changing current user password.", (Throwable)e);
        }
    }
}

