/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.athena;

import com.dbeaver.db.athena.AthenaCredentialsProvider;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSSimple;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelAthena
extends AuthModelAWSSimple {
    public static final String ID = "iam_athena";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        return AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)monitor, (AuthModelAWSCredentials)credentials, () -> this.initAthenaAuthentication(monitor, dataSource, credentials, configuration, connProperties));
    }

    private Object initAthenaAuthentication(DBRProgressMonitor monitor, DBPDataSource dataSource, AuthModelAWSCredentials credentials, DBPConnectionConfiguration configuration, Properties connProperties) throws DBException {
        String regionName = configuration.getServerName();
        if (regionName == null) {
            regionName = configuration.getProviderProperty("AwsRegion");
        }
        if (regionName == null) {
            throw new DBException("AWS region not specified");
        }
        credentials.setRegion(regionName);
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        StringBuilder cpParams = new StringBuilder();
        if (!CommonUtils.isEmpty((String)awsCredentials.accessKeyId())) {
            cpParams.append(awsCredentials.accessKeyId()).append(",").append(awsCredentials.secretAccessKey());
        }
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)awsCredentials;
            cpParams.append(",").append(sessionCredentials.sessionToken());
        }
        connProperties.put("CredentialsProvider", AthenaCredentialsProvider.class.getName());
        connProperties.put("CredentialsProviderArguments", cpParams.toString());
        return credentials;
    }
}

