/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.model.auth;

import com.dbeaver.db.salesforce.model.auth.SalesForceOAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SalesForceOAuthModel
implements DBAAuthModel<SalesForceOAuthCredentials> {
    @NotNull
    public SalesForceOAuthCredentials createCredentials() {
        return new SalesForceOAuthCredentials();
    }

    @NotNull
    public SalesForceOAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        SalesForceOAuthCredentials credentials = this.createCredentials();
        credentials.setClientID(configuration.getAuthProperty("client_id"));
        credentials.setClientSecret(configuration.getAuthProperty("client_secret"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull SalesForceOAuthCredentials credentials) {
        configuration.setAuthProperty("client_id", credentials.getClientID());
        configuration.setAuthProperty("client_secret", credentials.getClientSecret());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull SalesForceOAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String clientID = credentials.getClientID();
        String clientSecret = credentials.getClientSecret();
        connProperties.put("oauth_flow_type", configuration.getAuthProperty("oauth_flow_type"));
        connProperties.put("useOAuth", "true");
        connProperties.put("client_id", clientID);
        if (!CommonUtils.isEmpty((String)clientSecret)) {
            connProperties.put("client_secret", clientSecret);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull SalesForceOAuthCredentials credentials) throws DBException {
    }
}

