/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.aws;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.model.FoundationModelSummary;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary;

public class AwsModels {
    public static Map<String, AIModel> KNOWN_MODELS = new HashMap<String, AIModel>();
    public static String DEFAULT_MODEL = "anthropic.claude-2";

    public static Set<AIModelFeature> mapFeaturesForModels(@NotNull FoundationModelSummary m) {
        HashSet<AIModelFeature> features = new HashSet<AIModelFeature>();
        if (m.responseStreamingSupported() != null && m.responseStreamingSupported().booleanValue()) {
            features.add(AIModelFeature.STREAMING);
        }
        return features;
    }

    static Set<AIModelFeature> mapFeaturesForInferences(InferenceProfileSummary m, @NotNull BedrockAsyncClient metadataClient) {
        HashSet<AIModelFeature> features = new HashSet<AIModelFeature>();
        features.add(AIModelFeature.STREAMING);
        return features;
    }

    public static Integer getContextWindowSize() {
        return 32768;
    }
}

