/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.provider;

import com.dbeaver.ui.editors.sql.plan.diagram.features.PlansDetailInfoFeature;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class PlansToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    private static final boolean SHOW_CONTEXT_BUTTON_PAD = false;

    public PlansToolBehaviorProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    private PlanNodeRenderInfo getRenderInfo(PictogramElement pe) {
        if (pe == null) {
            return null;
        }
        if (pe.getLink() == null) {
            return null;
        }
        for (Object o : pe.getLink().getBusinessObjects()) {
            if (!(o instanceof PlanNodeRenderInfo)) continue;
            return (PlanNodeRenderInfo)((Object)o);
        }
        return null;
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        data.getGenericContextButtons().clear();
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        ICustomFeature[] customFeatures;
        ContextMenuEntry subMenu = new ContextMenuEntry(null, (IContext)context);
        subMenu.setText("Cu&stom");
        subMenu.setDescription("Custom features submenu");
        subMenu.setSubmenu(true);
        ICustomFeature[] iCustomFeatureArray = customFeatures = this.getFeatureProvider().getCustomFeatures(context);
        int n = customFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature customFeature = iCustomFeatureArray[n2];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                subMenu.add((IContextMenuEntry)menuEntry);
            }
            ++n2;
        }
        return new IContextMenuEntry[]{subMenu};
    }

    public IPaletteCompartmentEntry[] getPalette() {
        return new IPaletteCompartmentEntry[0];
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EObject) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            if (invisible.getGraphicsAlgorithmChildren().isEmpty()) {
                return super.getClickArea(pe);
            }
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        EList graphicsAlgorithmChildren;
        GraphicsAlgorithm invisible;
        if (pe instanceof ContainerShape && !(invisible = pe.getGraphicsAlgorithm()).getLineVisible().booleanValue() && !(graphicsAlgorithmChildren = invisible.getGraphicsAlgorithmChildren()).isEmpty()) {
            return (GraphicsAlgorithm)graphicsAlgorithmChildren.get(0);
        }
        return super.getSelectionBorder(pe);
    }

    public Object getToolTip(GraphicsAlgorithm ga) {
        PlanNodeRenderInfo renderInfo = this.getRenderInfo(ga.getPictogramElement());
        if (renderInfo != null) {
            return renderInfo.getNode().getText();
        }
        return super.getToolTip(ga);
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        return new PlansDetailInfoFeature(this.getFeatureProvider());
    }
}

