/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataFile;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OracleDataFileManager
extends SQLObjectEditor<OracleDataFile, OracleTablespace> {
    protected OracleDataFile createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        if (container instanceof OracleTablespace) {
            return new OracleDataFile((OracleTablespace)container, "new_file");
        }
        return null;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Add data file", this.buildStatement((OracleDataFile)command.getObject())));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        OracleDataFile dataFile = (OracleDataFile)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop data file", "ALTER TABLESPACE " + DBUtils.getQuotedIdentifier((DBSObject)dataFile.getTablespace()) + " DROP " + (dataFile.isTemporary() ? "TEMPFILE " : "DATAFILE ") + SQLUtils.quoteString((DBPDataSource)dataFile.getDataSource(), (String)dataFile.getName())));
    }

    private String buildStatement(@NotNull OracleDataFile dataFile) {
        StringBuilder sb = new StringBuilder("ALTER TABLESPACE ");
        sb.append(DBUtils.getQuotedIdentifier((DBSObject)dataFile.getTablespace()));
        sb.append(" ADD ");
        if (dataFile.isTemporary()) {
            sb.append("TEMPFILE ");
        } else {
            sb.append("DATAFILE ");
        }
        sb.append(SQLUtils.quoteString((DBPDataSource)dataFile.getDataSource(), (String)dataFile.getName()));
        sb.append(" SIZE ");
        if (dataFile.getBytes() != null) {
            sb.append(dataFile.getBytes());
        } else {
            sb.append("10M");
        }
        if (dataFile.isAutoExtensible()) {
            sb.append(" AUTOEXTEND ON ");
            if (dataFile.getMaxBytes() != null) {
                sb.append("MAXSIZE ").append(dataFile.getMaxBytes());
            }
        }
        return sb.toString();
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleDataFile> getObjectsCache(OracleDataFile object) {
        return object.getTablespace().getFileCache();
    }
}

