/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.model;

import com.dbeaver.db.neo4j.model.Neo4jTableColumn;
import com.dbeaver.db.neo4j.model.Neo4jUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.Pair;

public class Neo4jTableCache
extends TableCache {
    protected Neo4jTableCache(@NotNull GenericDataSource dataSource) {
        super(dataSource);
    }

    public synchronized void loadChildren(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer owner, @NotNull GenericTableBase table) throws DBException {
        ArrayList<Neo4jTableColumn> tmpObjectList = new ArrayList<Neo4jTableColumn>();
        GenericDataSource dataSource = owner.getDataSource();
        if (dataSource == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        StringBuilder query = new StringBuilder(100);
        query.append("MATCH");
        query.append(" (columns: ").append(table).append(") ");
        query.append("RETURN").append(" *");
        query.append("LIMIT").append(" 1");
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Load column objects");){
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(query.toString());){
                    Object executeQuery = JDBCUtils.executeQuery((Connection)session, (String)query.toString(), (Object[])new Object[0]);
                    if (executeQuery instanceof LinkedHashMap) {
                        LinkedHashMap result = (LinkedHashMap)executeQuery;
                        for (Map.Entry entry : result.entrySet()) {
                            String columnName = "";
                            Object k = entry.getKey();
                            if (k instanceof String) {
                                String name = (String)k;
                                columnName = name.trim();
                            }
                            Pair<String, Integer> name2type = Neo4jUtils.convertValueToColumnType(entry.getValue());
                            tmpObjectList.add(new Neo4jTableColumn(table, columnName, (String)name2type.getFirst(), (Integer)name2type.getSecond(), 0, 0, 0L, 0L, 0, 0, 0, false, "", "", false, false));
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage(), (Throwable)e);
        }
        HashMap<GenericTableBase, ArrayList<Neo4jTableColumn>> objectMap = new HashMap<GenericTableBase, ArrayList<Neo4jTableColumn>>();
        objectMap.put(table, tmpObjectList);
        for (Map.Entry colEntry : objectMap.entrySet()) {
            if (this.isChildrenCached((DBSObject)((GenericTableBase)colEntry.getKey()))) continue;
            this.cacheChildren((DBSObject)((GenericTableBase)colEntry.getKey()), (List)colEntry.getValue());
        }
        if (table == null) {
            if (!objectMap.isEmpty()) {
                for (GenericTableBase tmpObject : this.getAllObjects(monitor, (DBSObject)owner)) {
                    if (this.isChildrenCached((DBSObject)tmpObject) || objectMap.containsKey(tmpObject)) continue;
                    this.cacheChildren((DBSObject)tmpObject, new ArrayList());
                }
            }
        } else if (!objectMap.containsKey(table)) {
            this.cacheChildren((DBSObject)table, new ArrayList());
        }
    }
}

