/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.model;

import com.dbeaver.db.neo4j.model.Neo4jJdbcFactory;
import com.dbeaver.db.neo4j.model.Neo4jMetaModel;
import com.dbeaver.db.neo4j.model.Neo4jSQLDialect;
import com.dbeaver.db.neo4j.model.Neo4jTableCache;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;

public class Neo4jDataSource
extends GenericDataSource
implements DocumentDataManager<Neo4jDataSource, Map<String, Object>>,
DBPDataTypeProvider {
    private Neo4jTableCache tableCache = new Neo4jTableCache(this);
    private static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().create();

    public Neo4jDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    public Neo4jDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new Neo4jSQLDialect());
    }

    public Neo4jDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (GenericMetaModel)new Neo4jMetaModel(), (SQLDialect)new Neo4jSQLDialect());
    }

    public List<? extends GenericTableBase> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getTables(monitor);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        return DBPDataKind.DOCUMENT;
    }

    public void serializeDocument(Map<String, Object> document, Writer writer) {
        JSON_BUILDER.toJson(document, (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<Neo4jDataSource> convertNativeDocumentToMap(Map<String, Object> document) throws DBCException {
        return null;
    }

    public Map<String, Object> convertMapToNativeDocument(DBMapValue<Neo4jDataSource> map) throws DBCException {
        return null;
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return null;
    }

    @NotNull
    public TableCache getTableCache() {
        return this.tableCache;
    }

    protected JDBCFactory createJdbcFactory() {
        return new Neo4jJdbcFactory();
    }
}

