/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.handler;

import com.dbeaver.db.neo4j.model.Neo4jDataSource;
import com.dbeaver.db.neo4j.model.Neo4jTable;
import com.dbeaver.db.neo4j.model.data.Neo4jDocument;
import com.dbeaver.model.document.data.DBDocumentAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class Neo4jValueHandlerDocument
implements DBDValueHandlerComposite {
    public static final Neo4jValueHandlerDocument INSTANCE = new Neo4jValueHandlerDocument();

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return Object.class;
    }

    public String getValueContentType(DBSTypedObject attribute) {
        return "text/json";
    }

    public Object fetchValueObject(DBCSession session, DBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException {
        return this.getValueFromObject(session, type, resultSet.getAttributeValue(index), false, false);
    }

    public void bindValueObject(DBCSession session, DBCStatement statement, DBSTypedObject type, int index, Object value) throws DBCException {
    }

    public Object getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        Neo4jTable table = this.getTable(type);
        if (object == null) {
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, null);
        }
        if (object instanceof Map) {
            Map srcMap = (Map)object;
            LinkedHashMap<String, Object> ddbMap = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : srcMap.entrySet()) {
                ddbMap.put(entry.getKey().toString(), entry.getValue());
            }
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, ddbMap);
        }
        if (type instanceof JDBCColumnMetaData) {
            JDBCColumnMetaData columnMetaData = (JDBCColumnMetaData)type;
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, Map.of(columnMetaData.getLabel(), object));
        }
        return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, Map.of(type.getFullTypeName(), object));
    }

    public Object createNewValueObject(DBCSession session, DBSTypedObject type) throws DBCException {
        Neo4jTable table = this.getTable(type);
        LinkedHashMap<String, Object> attrValues = table == null ? null : new LinkedHashMap<String, Object>();
        return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, attrValues);
    }

    public void releaseValueObject(Object value) {
    }

    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        DBPDataKind dataKind = attribute.getDataKind();
        if (DBPDataKind.DOCUMENT == dataKind) {
            return new DBCLogicalOperator[0];
        }
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.ROWID) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
        }
        if (dataKind == DBPDataKind.ARRAY) {
            operators.add(DBCLogicalOperator.CONTAINS);
            operators.add(DBCLogicalOperator.CONTAINS_KEY);
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }

    public String getValueDisplayString(DBSTypedObject column, Object value, DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    @Nullable
    private Neo4jTable getTable(@NotNull DBSTypedObject type) {
        JDBCColumnMetaData columnMetaData;
        DBSDataContainer dBSDataContainer;
        JDBCColumnMetaData columnMetaData2;
        DBSDataContainer dBSDataContainer2;
        Neo4jTable neo4jTable;
        DBDocumentAttribute dbdDocAttribute;
        DBSEntity parentObject;
        Neo4jTable table = null;
        DBSTypedObject entityAttribute = type;
        if (entityAttribute instanceof DBDAttributeBinding) {
            DBDAttributeBinding dbdBindAttribute = (DBDAttributeBinding)entityAttribute;
            entityAttribute = dbdBindAttribute.getEntityAttribute();
        }
        if (entityAttribute instanceof DBDocumentAttribute && (parentObject = (dbdDocAttribute = (DBDocumentAttribute)entityAttribute).getParentObject()) instanceof Neo4jTable) {
            table = neo4jTable = (Neo4jTable)parentObject;
        }
        if (entityAttribute instanceof JDBCColumnMetaData && (dBSDataContainer2 = (columnMetaData2 = (JDBCColumnMetaData)entityAttribute).getSource().getDataContainer()) instanceof Neo4jTable) {
            table = neo4jTable = (Neo4jTable)dBSDataContainer2;
        }
        if (type instanceof JDBCColumnMetaData && (dBSDataContainer = (columnMetaData = (JDBCColumnMetaData)type).getSource().getDataContainer()) instanceof Neo4jTable) {
            Neo4jTable neo4jTable2;
            table = neo4jTable2 = (Neo4jTable)dBSDataContainer;
        }
        return table;
    }
}

