/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary;

public class ListModelCopyJobsIterable
implements SdkIterable<ListModelCopyJobsResponse> {
    private final BedrockClient client;
    private final ListModelCopyJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelCopyJobsIterable(BedrockClient client, ListModelCopyJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelCopyJobsResponseFetcher();
    }

    public Iterator<ListModelCopyJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelCopyJobSummary> modelCopyJobSummaries() {
        Function<ListModelCopyJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCopyJobSummaries() != null) {
                return response.modelCopyJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelCopyJobsResponseFetcher
    implements SyncPageFetcher<ListModelCopyJobsResponse> {
        private ListModelCopyJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCopyJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelCopyJobsResponse nextPage(ListModelCopyJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCopyJobsIterable.this.client.listModelCopyJobs(ListModelCopyJobsIterable.this.firstRequest);
            }
            return ListModelCopyJobsIterable.this.client.listModelCopyJobs((ListModelCopyJobsRequest)((Object)ListModelCopyJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

