/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestCaseIdListCopier;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAutomatedReasoningPolicyTestWorkflowRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, StartAutomatedReasoningPolicyTestWorkflowRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(StartAutomatedReasoningPolicyTestWorkflowRequest.getter(StartAutomatedReasoningPolicyTestWorkflowRequest::policyArn)).setter(StartAutomatedReasoningPolicyTestWorkflowRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildWorkflowId").getter(StartAutomatedReasoningPolicyTestWorkflowRequest.getter(StartAutomatedReasoningPolicyTestWorkflowRequest::buildWorkflowId)).setter(StartAutomatedReasoningPolicyTestWorkflowRequest.setter(Builder::buildWorkflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()}).build();
    private static final SdkField<List<String>> TEST_CASE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testCaseIds").getter(StartAutomatedReasoningPolicyTestWorkflowRequest.getter(StartAutomatedReasoningPolicyTestWorkflowRequest::testCaseIds)).setter(StartAutomatedReasoningPolicyTestWorkflowRequest.setter(Builder::testCaseIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartAutomatedReasoningPolicyTestWorkflowRequest.getter(StartAutomatedReasoningPolicyTestWorkflowRequest::clientRequestToken)).setter(StartAutomatedReasoningPolicyTestWorkflowRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, BUILD_WORKFLOW_ID_FIELD, TEST_CASE_IDS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAutomatedReasoningPolicyTestWorkflowRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String buildWorkflowId;
    private final List<String> testCaseIds;
    private final String clientRequestToken;

    private StartAutomatedReasoningPolicyTestWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.testCaseIds = builder.testCaseIds;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String buildWorkflowId() {
        return this.buildWorkflowId;
    }

    public final boolean hasTestCaseIds() {
        return this.testCaseIds != null && !(this.testCaseIds instanceof SdkAutoConstructList);
    }

    public final List<String> testCaseIds() {
        return this.testCaseIds;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestCaseIds() ? this.testCaseIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomatedReasoningPolicyTestWorkflowRequest)) {
            return false;
        }
        StartAutomatedReasoningPolicyTestWorkflowRequest other = (StartAutomatedReasoningPolicyTestWorkflowRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.buildWorkflowId(), other.buildWorkflowId()) && this.hasTestCaseIds() == other.hasTestCaseIds() && Objects.equals(this.testCaseIds(), other.testCaseIds()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartAutomatedReasoningPolicyTestWorkflowRequest").add("PolicyArn", (Object)this.policyArn()).add("BuildWorkflowId", (Object)this.buildWorkflowId()).add("TestCaseIds", this.hasTestCaseIds() ? this.testCaseIds() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "buildWorkflowId": {
                return Optional.ofNullable(clazz.cast(this.buildWorkflowId()));
            }
            case "testCaseIds": {
                return Optional.ofNullable(clazz.cast(this.testCaseIds()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("testCaseIds", TEST_CASE_IDS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomatedReasoningPolicyTestWorkflowRequest, T> g) {
        return obj -> g.apply((StartAutomatedReasoningPolicyTestWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String buildWorkflowId;
        private List<String> testCaseIds = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomatedReasoningPolicyTestWorkflowRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.buildWorkflowId(model.buildWorkflowId);
            this.testCaseIds(model.testCaseIds);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return this.buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final Collection<String> getTestCaseIds() {
            if (this.testCaseIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.testCaseIds;
        }

        public final void setTestCaseIds(Collection<String> testCaseIds) {
            this.testCaseIds = AutomatedReasoningPolicyTestCaseIdListCopier.copy(testCaseIds);
        }

        @Override
        public final Builder testCaseIds(Collection<String> testCaseIds) {
            this.testCaseIds = AutomatedReasoningPolicyTestCaseIdListCopier.copy(testCaseIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCaseIds(String ... testCaseIds) {
            this.testCaseIds(Arrays.asList(testCaseIds));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomatedReasoningPolicyTestWorkflowRequest build() {
            return new StartAutomatedReasoningPolicyTestWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAutomatedReasoningPolicyTestWorkflowRequest> {
        public Builder policyArn(String var1);

        public Builder buildWorkflowId(String var1);

        public Builder testCaseIds(Collection<String> var1);

        public Builder testCaseIds(String ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

