/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelModality {
    TEXT("TEXT"),
    IMAGE("IMAGE"),
    EMBEDDING("EMBEDDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelModality> VALUE_MAP;
    private final String value;

    private ModelModality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelModality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelModality> knownValues() {
        EnumSet<ModelModality> knownValues = EnumSet.allOf(ModelModality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelModality.class, ModelModality::toString);
    }
}

