/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelDataSource;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus;
import software.amazon.awssdk.services.bedrock.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelImportJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetModelImportJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::jobArn)).setter(GetModelImportJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::jobName)).setter(GetModelImportJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelName").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::importedModelName)).setter(GetModelImportJobResponse.setter(Builder::importedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelArn").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::importedModelArn)).setter(GetModelImportJobResponse.setter(Builder::importedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::roleArn)).setter(GetModelImportJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelDataSource").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::modelDataSource)).setter(GetModelImportJobResponse.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::statusAsString)).setter(GetModelImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::failureMessage)).setter(GetModelImportJobResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::creationTime)).setter(GetModelImportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::lastModifiedTime)).setter(GetModelImportJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::endTime)).setter(GetModelImportJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::vpcConfig)).setter(GetModelImportJobResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelKmsKeyArn").getter(GetModelImportJobResponse.getter(GetModelImportJobResponse::importedModelKmsKeyArn)).setter(GetModelImportJobResponse.setter(Builder::importedModelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelKmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, IMPORTED_MODEL_NAME_FIELD, IMPORTED_MODEL_ARN_FIELD, ROLE_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, VPC_CONFIG_FIELD, IMPORTED_MODEL_KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetModelImportJobResponse.memberNameToFieldInitializer();
    private final String jobArn;
    private final String jobName;
    private final String importedModelName;
    private final String importedModelArn;
    private final String roleArn;
    private final ModelDataSource modelDataSource;
    private final String status;
    private final String failureMessage;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Instant endTime;
    private final VpcConfig vpcConfig;
    private final String importedModelKmsKeyArn;

    private GetModelImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.importedModelName = builder.importedModelName;
        this.importedModelArn = builder.importedModelArn;
        this.roleArn = builder.roleArn;
        this.modelDataSource = builder.modelDataSource;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.vpcConfig = builder.vpcConfig;
        this.importedModelKmsKeyArn = builder.importedModelKmsKeyArn;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String importedModelName() {
        return this.importedModelName;
    }

    public final String importedModelArn() {
        return this.importedModelArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final ModelImportJobStatus status() {
        return ModelImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String importedModelKmsKeyArn() {
        return this.importedModelKmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelKmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelImportJobResponse)) {
            return false;
        }
        GetModelImportJobResponse other = (GetModelImportJobResponse)((Object)obj);
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.importedModelName(), other.importedModelName()) && Objects.equals(this.importedModelArn(), other.importedModelArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.importedModelKmsKeyArn(), other.importedModelKmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetModelImportJobResponse").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("ImportedModelName", (Object)this.importedModelName()).add("ImportedModelArn", (Object)this.importedModelArn()).add("RoleArn", (Object)this.roleArn()).add("ModelDataSource", (Object)this.modelDataSource()).add("Status", (Object)this.statusAsString()).add("FailureMessage", (Object)this.failureMessage()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EndTime", (Object)this.endTime()).add("VpcConfig", (Object)this.vpcConfig()).add("ImportedModelKmsKeyArn", (Object)this.importedModelKmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "importedModelName": {
                return Optional.ofNullable(clazz.cast(this.importedModelName()));
            }
            case "importedModelArn": {
                return Optional.ofNullable(clazz.cast(this.importedModelArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "modelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "importedModelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.importedModelKmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("importedModelName", IMPORTED_MODEL_NAME_FIELD);
        map.put("importedModelArn", IMPORTED_MODEL_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("modelDataSource", MODEL_DATA_SOURCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("importedModelKmsKeyArn", IMPORTED_MODEL_KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetModelImportJobResponse, T> g) {
        return obj -> g.apply((GetModelImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String importedModelName;
        private String importedModelArn;
        private String roleArn;
        private ModelDataSource modelDataSource;
        private String status;
        private String failureMessage;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private Instant endTime;
        private VpcConfig vpcConfig;
        private String importedModelKmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelImportJobResponse model) {
            super(model);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.importedModelName(model.importedModelName);
            this.importedModelArn(model.importedModelArn);
            this.roleArn(model.roleArn);
            this.modelDataSource(model.modelDataSource);
            this.status(model.status);
            this.failureMessage(model.failureMessage);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.endTime(model.endTime);
            this.vpcConfig(model.vpcConfig);
            this.importedModelKmsKeyArn(model.importedModelKmsKeyArn);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getImportedModelName() {
            return this.importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        public final String getImportedModelArn() {
            return this.importedModelArn;
        }

        public final void setImportedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
        }

        @Override
        public final Builder importedModelArn(String importedModelArn) {
            this.importedModelArn = importedModelArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImportedModelKmsKeyArn() {
            return this.importedModelKmsKeyArn;
        }

        public final void setImportedModelKmsKeyArn(String importedModelKmsKeyArn) {
            this.importedModelKmsKeyArn = importedModelKmsKeyArn;
        }

        @Override
        public final Builder importedModelKmsKeyArn(String importedModelKmsKeyArn) {
            this.importedModelKmsKeyArn = importedModelKmsKeyArn;
            return this;
        }

        @Override
        public GetModelImportJobResponse build() {
            return new GetModelImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelImportJobResponse> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder importedModelName(String var1);

        public Builder importedModelArn(String var1);

        public Builder roleArn(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder status(String var1);

        public Builder status(ModelImportJobStatus var1);

        public Builder failureMessage(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder importedModelKmsKeyArn(String var1);
    }
}

