/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle;
import software.amazon.awssdk.services.bedrock.model.InferenceType;
import software.amazon.awssdk.services.bedrock.model.InferenceTypeListCopier;
import software.amazon.awssdk.services.bedrock.model.ModelCustomization;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationListCopier;
import software.amazon.awssdk.services.bedrock.model.ModelModality;
import software.amazon.awssdk.services.bedrock.model.ModelModalityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FoundationModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FoundationModelSummary> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(FoundationModelSummary.getter(FoundationModelSummary::modelArn)).setter(FoundationModelSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(FoundationModelSummary.getter(FoundationModelSummary::modelId)).setter(FoundationModelSummary.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(FoundationModelSummary.getter(FoundationModelSummary::modelName)).setter(FoundationModelSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(FoundationModelSummary.getter(FoundationModelSummary::providerName)).setter(FoundationModelSummary.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<List<String>> INPUT_MODALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputModalities").getter(FoundationModelSummary.getter(FoundationModelSummary::inputModalitiesAsStrings)).setter(FoundationModelSummary.setter(Builder::inputModalitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputModalities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OUTPUT_MODALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputModalities").getter(FoundationModelSummary.getter(FoundationModelSummary::outputModalitiesAsStrings)).setter(FoundationModelSummary.setter(Builder::outputModalitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModalities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RESPONSE_STREAMING_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("responseStreamingSupported").getter(FoundationModelSummary.getter(FoundationModelSummary::responseStreamingSupported)).setter(FoundationModelSummary.setter(Builder::responseStreamingSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseStreamingSupported").build()}).build();
    private static final SdkField<List<String>> CUSTOMIZATIONS_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customizationsSupported").getter(FoundationModelSummary.getter(FoundationModelSummary::customizationsSupportedAsStrings)).setter(FoundationModelSummary.setter(Builder::customizationsSupportedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationsSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INFERENCE_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferenceTypesSupported").getter(FoundationModelSummary.getter(FoundationModelSummary::inferenceTypesSupportedAsStrings)).setter(FoundationModelSummary.setter(Builder::inferenceTypesSupportedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceTypesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FoundationModelLifecycle> MODEL_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelLifecycle").getter(FoundationModelSummary.getter(FoundationModelSummary::modelLifecycle)).setter(FoundationModelSummary.setter(Builder::modelLifecycle)).constructor(FoundationModelLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelLifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, MODEL_ID_FIELD, MODEL_NAME_FIELD, PROVIDER_NAME_FIELD, INPUT_MODALITIES_FIELD, OUTPUT_MODALITIES_FIELD, RESPONSE_STREAMING_SUPPORTED_FIELD, CUSTOMIZATIONS_SUPPORTED_FIELD, INFERENCE_TYPES_SUPPORTED_FIELD, MODEL_LIFECYCLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FoundationModelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelArn;
    private final String modelId;
    private final String modelName;
    private final String providerName;
    private final List<String> inputModalities;
    private final List<String> outputModalities;
    private final Boolean responseStreamingSupported;
    private final List<String> customizationsSupported;
    private final List<String> inferenceTypesSupported;
    private final FoundationModelLifecycle modelLifecycle;

    private FoundationModelSummary(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.modelId = builder.modelId;
        this.modelName = builder.modelName;
        this.providerName = builder.providerName;
        this.inputModalities = builder.inputModalities;
        this.outputModalities = builder.outputModalities;
        this.responseStreamingSupported = builder.responseStreamingSupported;
        this.customizationsSupported = builder.customizationsSupported;
        this.inferenceTypesSupported = builder.inferenceTypesSupported;
        this.modelLifecycle = builder.modelLifecycle;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final List<ModelModality> inputModalities() {
        return ModelModalityListCopier.copyStringToEnum(this.inputModalities);
    }

    public final boolean hasInputModalities() {
        return this.inputModalities != null && !(this.inputModalities instanceof SdkAutoConstructList);
    }

    public final List<String> inputModalitiesAsStrings() {
        return this.inputModalities;
    }

    public final List<ModelModality> outputModalities() {
        return ModelModalityListCopier.copyStringToEnum(this.outputModalities);
    }

    public final boolean hasOutputModalities() {
        return this.outputModalities != null && !(this.outputModalities instanceof SdkAutoConstructList);
    }

    public final List<String> outputModalitiesAsStrings() {
        return this.outputModalities;
    }

    public final Boolean responseStreamingSupported() {
        return this.responseStreamingSupported;
    }

    public final List<ModelCustomization> customizationsSupported() {
        return ModelCustomizationListCopier.copyStringToEnum(this.customizationsSupported);
    }

    public final boolean hasCustomizationsSupported() {
        return this.customizationsSupported != null && !(this.customizationsSupported instanceof SdkAutoConstructList);
    }

    public final List<String> customizationsSupportedAsStrings() {
        return this.customizationsSupported;
    }

    public final List<InferenceType> inferenceTypesSupported() {
        return InferenceTypeListCopier.copyStringToEnum(this.inferenceTypesSupported);
    }

    public final boolean hasInferenceTypesSupported() {
        return this.inferenceTypesSupported != null && !(this.inferenceTypesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> inferenceTypesSupportedAsStrings() {
        return this.inferenceTypesSupported;
    }

    public final FoundationModelLifecycle modelLifecycle() {
        return this.modelLifecycle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputModalities() ? this.inputModalitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputModalities() ? this.outputModalitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseStreamingSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomizationsSupported() ? this.customizationsSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceTypesSupported() ? this.inferenceTypesSupportedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLifecycle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FoundationModelSummary)) {
            return false;
        }
        FoundationModelSummary other = (FoundationModelSummary)obj;
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.providerName(), other.providerName()) && this.hasInputModalities() == other.hasInputModalities() && Objects.equals(this.inputModalitiesAsStrings(), other.inputModalitiesAsStrings()) && this.hasOutputModalities() == other.hasOutputModalities() && Objects.equals(this.outputModalitiesAsStrings(), other.outputModalitiesAsStrings()) && Objects.equals(this.responseStreamingSupported(), other.responseStreamingSupported()) && this.hasCustomizationsSupported() == other.hasCustomizationsSupported() && Objects.equals(this.customizationsSupportedAsStrings(), other.customizationsSupportedAsStrings()) && this.hasInferenceTypesSupported() == other.hasInferenceTypesSupported() && Objects.equals(this.inferenceTypesSupportedAsStrings(), other.inferenceTypesSupportedAsStrings()) && Objects.equals(this.modelLifecycle(), other.modelLifecycle());
    }

    public final String toString() {
        return ToString.builder((String)"FoundationModelSummary").add("ModelArn", (Object)this.modelArn()).add("ModelId", (Object)this.modelId()).add("ModelName", (Object)this.modelName()).add("ProviderName", (Object)this.providerName()).add("InputModalities", this.hasInputModalities() ? this.inputModalitiesAsStrings() : null).add("OutputModalities", this.hasOutputModalities() ? this.outputModalitiesAsStrings() : null).add("ResponseStreamingSupported", (Object)this.responseStreamingSupported()).add("CustomizationsSupported", this.hasCustomizationsSupported() ? this.customizationsSupportedAsStrings() : null).add("InferenceTypesSupported", this.hasInferenceTypesSupported() ? this.inferenceTypesSupportedAsStrings() : null).add("ModelLifecycle", (Object)this.modelLifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "inputModalities": {
                return Optional.ofNullable(clazz.cast(this.inputModalitiesAsStrings()));
            }
            case "outputModalities": {
                return Optional.ofNullable(clazz.cast(this.outputModalitiesAsStrings()));
            }
            case "responseStreamingSupported": {
                return Optional.ofNullable(clazz.cast(this.responseStreamingSupported()));
            }
            case "customizationsSupported": {
                return Optional.ofNullable(clazz.cast(this.customizationsSupportedAsStrings()));
            }
            case "inferenceTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.inferenceTypesSupportedAsStrings()));
            }
            case "modelLifecycle": {
                return Optional.ofNullable(clazz.cast(this.modelLifecycle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("inputModalities", INPUT_MODALITIES_FIELD);
        map.put("outputModalities", OUTPUT_MODALITIES_FIELD);
        map.put("responseStreamingSupported", RESPONSE_STREAMING_SUPPORTED_FIELD);
        map.put("customizationsSupported", CUSTOMIZATIONS_SUPPORTED_FIELD);
        map.put("inferenceTypesSupported", INFERENCE_TYPES_SUPPORTED_FIELD);
        map.put("modelLifecycle", MODEL_LIFECYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FoundationModelSummary, T> g) {
        return obj -> g.apply((FoundationModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelArn;
        private String modelId;
        private String modelName;
        private String providerName;
        private List<String> inputModalities = DefaultSdkAutoConstructList.getInstance();
        private List<String> outputModalities = DefaultSdkAutoConstructList.getInstance();
        private Boolean responseStreamingSupported;
        private List<String> customizationsSupported = DefaultSdkAutoConstructList.getInstance();
        private List<String> inferenceTypesSupported = DefaultSdkAutoConstructList.getInstance();
        private FoundationModelLifecycle modelLifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(FoundationModelSummary model) {
            this.modelArn(model.modelArn);
            this.modelId(model.modelId);
            this.modelName(model.modelName);
            this.providerName(model.providerName);
            this.inputModalitiesWithStrings(model.inputModalities);
            this.outputModalitiesWithStrings(model.outputModalities);
            this.responseStreamingSupported(model.responseStreamingSupported);
            this.customizationsSupportedWithStrings(model.customizationsSupported);
            this.inferenceTypesSupportedWithStrings(model.inferenceTypesSupported);
            this.modelLifecycle(model.modelLifecycle);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Collection<String> getInputModalities() {
            if (this.inputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputModalities;
        }

        public final void setInputModalities(Collection<String> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copy(inputModalities);
        }

        @Override
        public final Builder inputModalitiesWithStrings(Collection<String> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copy(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalitiesWithStrings(String ... inputModalities) {
            this.inputModalitiesWithStrings(Arrays.asList(inputModalities));
            return this;
        }

        @Override
        public final Builder inputModalities(Collection<ModelModality> inputModalities) {
            this.inputModalities = ModelModalityListCopier.copyEnumToString(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalities(ModelModality ... inputModalities) {
            this.inputModalities(Arrays.asList(inputModalities));
            return this;
        }

        public final Collection<String> getOutputModalities() {
            if (this.outputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputModalities;
        }

        public final void setOutputModalities(Collection<String> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copy(outputModalities);
        }

        @Override
        public final Builder outputModalitiesWithStrings(Collection<String> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copy(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalitiesWithStrings(String ... outputModalities) {
            this.outputModalitiesWithStrings(Arrays.asList(outputModalities));
            return this;
        }

        @Override
        public final Builder outputModalities(Collection<ModelModality> outputModalities) {
            this.outputModalities = ModelModalityListCopier.copyEnumToString(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalities(ModelModality ... outputModalities) {
            this.outputModalities(Arrays.asList(outputModalities));
            return this;
        }

        public final Boolean getResponseStreamingSupported() {
            return this.responseStreamingSupported;
        }

        public final void setResponseStreamingSupported(Boolean responseStreamingSupported) {
            this.responseStreamingSupported = responseStreamingSupported;
        }

        @Override
        public final Builder responseStreamingSupported(Boolean responseStreamingSupported) {
            this.responseStreamingSupported = responseStreamingSupported;
            return this;
        }

        public final Collection<String> getCustomizationsSupported() {
            if (this.customizationsSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customizationsSupported;
        }

        public final void setCustomizationsSupported(Collection<String> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copy(customizationsSupported);
        }

        @Override
        public final Builder customizationsSupportedWithStrings(Collection<String> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copy(customizationsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizationsSupportedWithStrings(String ... customizationsSupported) {
            this.customizationsSupportedWithStrings(Arrays.asList(customizationsSupported));
            return this;
        }

        @Override
        public final Builder customizationsSupported(Collection<ModelCustomization> customizationsSupported) {
            this.customizationsSupported = ModelCustomizationListCopier.copyEnumToString(customizationsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customizationsSupported(ModelCustomization ... customizationsSupported) {
            this.customizationsSupported(Arrays.asList(customizationsSupported));
            return this;
        }

        public final Collection<String> getInferenceTypesSupported() {
            if (this.inferenceTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferenceTypesSupported;
        }

        public final void setInferenceTypesSupported(Collection<String> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copy(inferenceTypesSupported);
        }

        @Override
        public final Builder inferenceTypesSupportedWithStrings(Collection<String> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copy(inferenceTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceTypesSupportedWithStrings(String ... inferenceTypesSupported) {
            this.inferenceTypesSupportedWithStrings(Arrays.asList(inferenceTypesSupported));
            return this;
        }

        @Override
        public final Builder inferenceTypesSupported(Collection<InferenceType> inferenceTypesSupported) {
            this.inferenceTypesSupported = InferenceTypeListCopier.copyEnumToString(inferenceTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceTypesSupported(InferenceType ... inferenceTypesSupported) {
            this.inferenceTypesSupported(Arrays.asList(inferenceTypesSupported));
            return this;
        }

        public final FoundationModelLifecycle.Builder getModelLifecycle() {
            return this.modelLifecycle != null ? this.modelLifecycle.toBuilder() : null;
        }

        public final void setModelLifecycle(FoundationModelLifecycle.BuilderImpl modelLifecycle) {
            this.modelLifecycle = modelLifecycle != null ? modelLifecycle.build() : null;
        }

        @Override
        public final Builder modelLifecycle(FoundationModelLifecycle modelLifecycle) {
            this.modelLifecycle = modelLifecycle;
            return this;
        }

        public FoundationModelSummary build() {
            return new FoundationModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FoundationModelSummary> {
        public Builder modelArn(String var1);

        public Builder modelId(String var1);

        public Builder modelName(String var1);

        public Builder providerName(String var1);

        public Builder inputModalitiesWithStrings(Collection<String> var1);

        public Builder inputModalitiesWithStrings(String ... var1);

        public Builder inputModalities(Collection<ModelModality> var1);

        public Builder inputModalities(ModelModality ... var1);

        public Builder outputModalitiesWithStrings(Collection<String> var1);

        public Builder outputModalitiesWithStrings(String ... var1);

        public Builder outputModalities(Collection<ModelModality> var1);

        public Builder outputModalities(ModelModality ... var1);

        public Builder responseStreamingSupported(Boolean var1);

        public Builder customizationsSupportedWithStrings(Collection<String> var1);

        public Builder customizationsSupportedWithStrings(String ... var1);

        public Builder customizationsSupported(Collection<ModelCustomization> var1);

        public Builder customizationsSupported(ModelCustomization ... var1);

        public Builder inferenceTypesSupportedWithStrings(Collection<String> var1);

        public Builder inferenceTypesSupportedWithStrings(String ... var1);

        public Builder inferenceTypesSupported(Collection<InferenceType> var1);

        public Builder inferenceTypesSupported(InferenceType ... var1);

        public Builder modelLifecycle(FoundationModelLifecycle var1);

        default public Builder modelLifecycle(Consumer<FoundationModelLifecycle.Builder> modelLifecycle) {
            return this.modelLifecycle((FoundationModelLifecycle)((FoundationModelLifecycle.Builder)FoundationModelLifecycle.builder().applyMutation(modelLifecycle)).build());
        }
    }
}

