/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckLogicWarning;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRuleListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckTranslation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningCheckImpossibleFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningCheckImpossibleFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("translation").getter(AutomatedReasoningCheckImpossibleFinding.getter(AutomatedReasoningCheckImpossibleFinding::translation)).setter(AutomatedReasoningCheckImpossibleFinding.setter(Builder::translation)).constructor(AutomatedReasoningCheckTranslation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()}).build();
    private static final SdkField<List<AutomatedReasoningCheckRule>> CONTRADICTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contradictingRules").getter(AutomatedReasoningCheckImpossibleFinding.getter(AutomatedReasoningCheckImpossibleFinding::contradictingRules)).setter(AutomatedReasoningCheckImpossibleFinding.setter(Builder::contradictingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contradictingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningCheckRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicWarning").getter(AutomatedReasoningCheckImpossibleFinding.getter(AutomatedReasoningCheckImpossibleFinding::logicWarning)).setter(AutomatedReasoningCheckImpossibleFinding.setter(Builder::logicWarning)).constructor(AutomatedReasoningCheckLogicWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD, CONTRADICTING_RULES_FIELD, LOGIC_WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningCheckImpossibleFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningCheckTranslation translation;
    private final List<AutomatedReasoningCheckRule> contradictingRules;
    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckImpossibleFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.contradictingRules = builder.contradictingRules;
        this.logicWarning = builder.logicWarning;
    }

    public final AutomatedReasoningCheckTranslation translation() {
        return this.translation;
    }

    public final boolean hasContradictingRules() {
        return this.contradictingRules != null && !(this.contradictingRules instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningCheckRule> contradictingRules() {
        return this.contradictingRules;
    }

    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return this.logicWarning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContradictingRules() ? this.contradictingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicWarning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckImpossibleFinding)) {
            return false;
        }
        AutomatedReasoningCheckImpossibleFinding other = (AutomatedReasoningCheckImpossibleFinding)obj;
        return Objects.equals(this.translation(), other.translation()) && this.hasContradictingRules() == other.hasContradictingRules() && Objects.equals(this.contradictingRules(), other.contradictingRules()) && Objects.equals(this.logicWarning(), other.logicWarning());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningCheckImpossibleFinding").add("Translation", (Object)this.translation()).add("ContradictingRules", this.hasContradictingRules() ? this.contradictingRules() : null).add("LogicWarning", (Object)this.logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "translation": {
                return Optional.ofNullable(clazz.cast(this.translation()));
            }
            case "contradictingRules": {
                return Optional.ofNullable(clazz.cast(this.contradictingRules()));
            }
            case "logicWarning": {
                return Optional.ofNullable(clazz.cast(this.logicWarning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("contradictingRules", CONTRADICTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckImpossibleFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckImpossibleFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningCheckTranslation translation;
        private List<AutomatedReasoningCheckRule> contradictingRules = DefaultSdkAutoConstructList.getInstance();
        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckImpossibleFinding model) {
            this.translation(model.translation);
            this.contradictingRules(model.contradictingRules);
            this.logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return this.translation != null ? this.translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final List<AutomatedReasoningCheckRule.Builder> getContradictingRules() {
            List<AutomatedReasoningCheckRule.Builder> result = AutomatedReasoningCheckRuleListCopier.copyToBuilder(this.contradictingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContradictingRules(Collection<AutomatedReasoningCheckRule.BuilderImpl> contradictingRules) {
            this.contradictingRules = AutomatedReasoningCheckRuleListCopier.copyFromBuilder(contradictingRules);
        }

        @Override
        public final Builder contradictingRules(Collection<AutomatedReasoningCheckRule> contradictingRules) {
            this.contradictingRules = AutomatedReasoningCheckRuleListCopier.copy(contradictingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(AutomatedReasoningCheckRule ... contradictingRules) {
            this.contradictingRules(Arrays.asList(contradictingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(Consumer<AutomatedReasoningCheckRule.Builder> ... contradictingRules) {
            this.contradictingRules(Stream.of(contradictingRules).map(c -> (AutomatedReasoningCheckRule)((AutomatedReasoningCheckRule.Builder)AutomatedReasoningCheckRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return this.logicWarning != null ? this.logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        public AutomatedReasoningCheckImpossibleFinding build() {
            return new AutomatedReasoningCheckImpossibleFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningCheckImpossibleFinding> {
        public Builder translation(AutomatedReasoningCheckTranslation var1);

        default public Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return this.translation((AutomatedReasoningCheckTranslation)((AutomatedReasoningCheckTranslation.Builder)AutomatedReasoningCheckTranslation.builder().applyMutation(translation)).build());
        }

        public Builder contradictingRules(Collection<AutomatedReasoningCheckRule> var1);

        public Builder contradictingRules(AutomatedReasoningCheckRule ... var1);

        public Builder contradictingRules(Consumer<AutomatedReasoningCheckRule.Builder> ... var1);

        public Builder logicWarning(AutomatedReasoningCheckLogicWarning var1);

        default public Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return this.logicWarning((AutomatedReasoningCheckLogicWarning)((AutomatedReasoningCheckLogicWarning.Builder)AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning)).build());
        }
    }
}

