/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.dbeaver.db.ycql.model.CasKeyspace;
import com.dbeaver.db.ycql.model.CasTableBase;
import com.dbeaver.db.ycql.model.CasTableIndex;
import com.dbeaver.db.ycql.model.CasTableKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class CasTable
extends CasTableBase {
    private static final Log log = Log.getLog(CasTable.class);
    private final TableMetadata metadata;
    private final IndexCache indexCache = new IndexCache();
    private CasTableKey primaryKey;
    private CasTableKey partitionKey;

    public CasTable(CasKeyspace keyspace, TableMetadata metadata) {
        super(keyspace);
        this.metadata = metadata;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName().toString();
    }

    @Property(viewable=true, editable=true, order=100)
    @Nullable
    public String getDescription() {
        Map options = this.metadata.getOptions();
        if (options == null) {
            return null;
        }
        return CommonUtils.toString(options.get(CqlIdentifier.fromInternal((String)"comment")));
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return monitor == null ? this.indexCache.getCachedObjects() : this.indexCache.getAllObjects(monitor, this);
    }

    public IndexCache getIndexCache() {
        return this.indexCache;
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.indexCache.clearCache();
        this.primaryKey = null;
        return super.refreshObject(monitor);
    }

    public Collection<CasTableKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.primaryKey == null) {
            this.primaryKey = new CasTableKey(monitor, this, this.metadata.getPrimaryKey(), DBSEntityConstraintType.PRIMARY_KEY);
            this.partitionKey = new CasTableKey(monitor, this, this.metadata.getPartitionKey(), CasTableKey.PARTITION_KEY);
        }
        return Arrays.asList(this.primaryKey, this.partitionKey);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.metadata.describe(true);
    }

    @Property(order=10, category="Options")
    public double getBloomFilterFalsePositiveChance() {
        return CommonUtils.toDouble(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"bloom_filter_fp_chance")));
    }

    @Property(order=11, category="Options")
    public Map<String, String> getCaching() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"caching"));
        return o == null ? null : (Map)o;
    }

    @Property(order=12, category="Options")
    public Map<String, String> getCompaction() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"compaction"));
        return o == null ? null : (Map)o;
    }

    @Property(order=13, category="Options")
    public Map<String, String> getCompression() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"compression"));
        return o == null ? null : (Map)o;
    }

    @Property(order=14, category="Options")
    public int getDefaultTimeToLive() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"default_time_to_live")));
    }

    @Property(order=15, category="Options")
    public int getGcGraceInSeconds() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"gc_grace_seconds")));
    }

    @Property(order=16, category="Options")
    public Integer getIndexInterval() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"max_index_interval")));
    }

    @Property(order=17, category="Options")
    public double getLocalReadRepairChance() {
        return CommonUtils.toDouble(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"read_repair")));
    }

    @Property(order=18, category="Options")
    public int getMemtableFlushPeriodInMs() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"memtable_flush_period_in_ms")));
    }

    @Property(order=19, category="Options")
    public boolean getPopulateIOCacheOnFlush() {
        return CommonUtils.toBoolean(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"populate_io_cache_on_flush")));
    }

    @Property(order=21, category="Options")
    public boolean getReplicateOnWrite() {
        return CommonUtils.toBoolean(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"replicate-on-write")));
    }

    @Property(order=22, category="Options")
    public String getSpeculativeRetry() {
        return CommonUtils.toString(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"speculative_retry")));
    }

    @Property(order=23, category="Options")
    public boolean isCompactStorage() {
        return this.metadata.isCompactStorage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isKeyColumn(String name) {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            CasTableKey.KeyColumn col;
            this.getConstraints((DBRProgressMonitor)monitor);
            if (this.primaryKey == null) return false;
            Iterator<CasTableKey.KeyColumn> iterator = this.primaryKey.getAttributeReferences((DBRProgressMonitor)monitor).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(col = iterator.next()).getName().equals(name));
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return false;
    }

    protected List<ColumnMetadata> getMetaColumns() {
        return this.metadata.getColumns().values().stream().toList();
    }

    public class IndexCache
    extends AbstractObjectCache<CasTable, CasTableIndex> {
        @NotNull
        public Collection<CasTableIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasTable table) {
            if (!this.isFullyCached()) {
                ArrayList<CasTableIndex> indexes = new ArrayList<CasTableIndex>();
                for (IndexMetadata imd : CasTable.this.metadata.getIndexes().values()) {
                    indexes.add(new CasTableIndex(table, imd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(indexes);
            }
            return this.getCachedObjects();
        }

        public CasTableIndex getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasTable casKeyspace, @NotNull String name) throws DBException {
            return (CasTableIndex)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

