/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.dbeaver.db.ycql.model.CasKeyspace;
import com.dbeaver.db.ycql.model.CasTableBase;
import com.dbeaver.db.ycql.model.CasTableKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public class CasMView
extends CasTableBase
implements DBPScriptObject,
DBSView {
    private static final Log log = Log.getLog(CasMView.class);
    private final ViewMetadata metadata;

    public CasMView(CasKeyspace keyspace, ViewMetadata metadata) {
        super(keyspace);
        this.metadata = metadata;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName().toString();
    }

    @Property(viewable=true, editable=true, order=100)
    public String getDescription() {
        return (String)this.metadata.getOptions().get("comment");
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.VIEW;
    }

    @Override
    protected Collection<ColumnMetadata> getMetaColumns() {
        return this.metadata.getColumns().values();
    }

    public boolean isView() {
        return true;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<CasTableKey> getConstraints(@NotNull DBRProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.metadata.describe(true);
    }

    @Property(order=10, category="Options")
    public double getBloomFilterFalsePositiveChance() {
        return CommonUtils.toDouble(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"bloom_filter_fp_chance")));
    }

    @Property(order=11, category="Options")
    public Map<String, String> getCaching() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"caching"));
        return o == null ? null : (Map)o;
    }

    @Property(order=12, category="Options")
    public Map<String, String> getCompaction() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"compaction"));
        return o == null ? null : (Map)o;
    }

    @Property(order=13, category="Options")
    public Map<String, String> getCompression() {
        Object o = this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"compression"));
        return o == null ? null : (Map)o;
    }

    @Property(order=14, category="Options")
    public int getDefaultTimeToLive() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"default_time_to_live")));
    }

    @Property(order=15, category="Options")
    public int getGcGraceInSeconds() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"gc_grace_seconds")));
    }

    @Property(order=16, category="Options")
    public Integer getIndexInterval() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"max_index_interval")));
    }

    @Property(order=17, category="Options")
    public double getLocalReadRepairChance() {
        return CommonUtils.toDouble(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"read_repair")));
    }

    @Property(order=18, category="Options")
    public int getMemtableFlushPeriodInMs() {
        return CommonUtils.toInt(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"memtable_flush_period_in_ms")));
    }

    @Property(order=19, category="Options")
    public boolean getPopulateIOCacheOnFlush() {
        return CommonUtils.toBoolean(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"populate_io_cache_on_flush")));
    }

    @Property(order=21, category="Options")
    public boolean getReplicateOnWrite() {
        return CommonUtils.toBoolean(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"replicate-on-write")));
    }

    @Property(order=22, category="Options")
    public String getSpeculativeRetry() {
        return CommonUtils.toString(this.metadata.getOptions().get(CqlIdentifier.fromInternal((String)"speculative_retry")));
    }
}

