/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.dbeaver.db.ycql.model.CasAggregate;
import com.dbeaver.db.ycql.model.CasCQLObject;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasFunction;
import com.dbeaver.db.ycql.model.CasMView;
import com.dbeaver.db.ycql.model.CasTable;
import com.dbeaver.db.ycql.model.CasUserType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class CasKeyspace
implements DBSCatalog,
CasCQLObject,
DBPNamedObject2,
DBPSystemObject,
DBPRefreshableObject,
DBPSaveableObject {
    private static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    @NotNull
    private final CasDataSource dataSource;
    private final TableCache tableCache = new TableCache();
    private final MaterializedViewCache mviewsCache = new MaterializedViewCache();
    private final UserTypeCache userTypeCache = new UserTypeCache();
    private final AggregateCache aggregateCache = new AggregateCache();
    private final FunctionCache functionCache = new FunctionCache();
    @Nullable
    private KeyspaceMetadata metadata;
    @Nullable
    private String name;
    @Nullable
    private Map<String, String> replicationStrategy;
    private boolean persisted;

    public CasKeyspace(@NotNull CasDataSource dataSource, @Nullable String name, @Nullable Map<String, String> replicationStrategy) {
        this.dataSource = dataSource;
        this.metadata = null;
        this.name = name;
        this.replicationStrategy = replicationStrategy;
        this.persisted = false;
    }

    public CasKeyspace(@NotNull CasDataSource dataSource, @NotNull KeyspaceMetadata metadata) {
        this.dataSource = dataSource;
        this.metadata = metadata;
        this.persisted = true;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata == null ? this.name : this.metadata.getName().toString();
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property
    public boolean isDurableWrites() {
        return this.metadata != null && this.metadata.isDurableWrites();
    }

    @Property(editable=true, length=PropertyLength.MULTILINE)
    public String getReplication() {
        StringBuilder str = new StringBuilder();
        str.append("{ ");
        int paramNum = 0;
        Map<String, String> replicationStrategy = this.getReplicationMap();
        for (Map.Entry<String, String> rsEntry : replicationStrategy.entrySet()) {
            str.append("'").append(rsEntry.getKey()).append("': '").append(rsEntry.getValue()).append("'");
            if (paramNum < replicationStrategy.size() - 1) {
                str.append(",\n");
            }
            ++paramNum;
        }
        str.append("\n}");
        return str.toString();
    }

    public void setReplication(String rsString) {
        this.replicationStrategy = (Map)gson.fromJson(rsString, Map.class);
    }

    public Map<String, String> getReplicationMap() {
        return this.metadata == null ? this.replicationStrategy : this.metadata.getReplication();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    @Association
    public Collection<CasTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasMView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        return this.mviewsCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasUserType> getUserTypes(DBRProgressMonitor monitor) throws DBException {
        return this.userTypeCache.getAllObjects(monitor, this);
    }

    public CasUserType getUserType(DBRProgressMonitor monitor, DataType type) throws DBException {
        for (CasUserType userType : this.userTypeCache.getAllObjects(monitor, this)) {
            if (!userType.getCasDataType().equals(type)) continue;
            return userType;
        }
        return null;
    }

    @Association
    public Collection<CasAggregate> getAggregates(DBRProgressMonitor monitor) throws DBException {
        return this.aggregateCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, this);
    }

    public Collection<CasTable> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    public CasTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.tableCache.getObject(monitor, this, childName);
    }

    @NotNull
    public Class<CasTable> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CasTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.tableCache.getAllObjects(monitor, this);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.metadata == null ? "" : this.metadata.describe(true);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.tableCache.clearCache();
        this.mviewsCache.clearCache();
        this.userTypeCache.clearCache();
        this.aggregateCache.clearCache();
        this.functionCache.clearCache();
        this.metadata = this.dataSource.getCQLSession().getMetadata().getKeyspace(DBUtils.getQuotedIdentifier((DBSObject)this)).orElse(null);
        return this;
    }

    public boolean isSystem() {
        String name = this.getName();
        return name.equals("system") || name.startsWith("system_");
    }

    public String toString() {
        return this.getName();
    }

    class AggregateCache
    extends AbstractObjectCache<CasKeyspace, CasAggregate> {
        AggregateCache() {
        }

        @NotNull
        public Collection<CasAggregate> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasAggregate> types = new ArrayList<CasAggregate>();
                if (CasKeyspace.this.metadata != null) {
                    for (AggregateMetadata tmd : CasKeyspace.this.metadata.getAggregates().values()) {
                        types.add(new CasAggregate(casKeyspace, tmd));
                        if (monitor.isCanceled()) break;
                    }
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasAggregate getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasAggregate)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class FunctionCache
    extends AbstractObjectCache<CasKeyspace, CasFunction> {
        FunctionCache() {
        }

        @NotNull
        public Collection<CasFunction> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasFunction> types = new ArrayList<CasFunction>();
                if (CasKeyspace.this.metadata != null) {
                    for (Map.Entry tmd : CasKeyspace.this.metadata.getFunctions().entrySet()) {
                        types.add(new CasFunction(casKeyspace, (FunctionMetadata)tmd.getValue()));
                        if (monitor.isCanceled()) break;
                    }
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasFunction getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasFunction)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class MaterializedViewCache
    extends AbstractObjectCache<CasKeyspace, CasMView> {
        MaterializedViewCache() {
        }

        @NotNull
        public Collection<CasMView> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasMView> tables = new ArrayList<CasMView>();
                if (CasKeyspace.this.metadata != null) {
                    for (ViewMetadata metadata : CasKeyspace.this.metadata.getViews().values()) {
                        tables.add(new CasMView(casKeyspace, metadata));
                        if (monitor.isCanceled()) break;
                    }
                }
                this.setCache(tables);
            }
            return this.getCachedObjects();
        }

        public CasMView getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasMView)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    public class TableCache
    extends AbstractObjectCache<CasKeyspace, CasTable> {
        @NotNull
        public Collection<CasTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasTable> tables = new ArrayList<CasTable>();
                if (CasKeyspace.this.metadata != null) {
                    for (Map.Entry tmd : CasKeyspace.this.metadata.getTables().entrySet()) {
                        tables.add(new CasTable(casKeyspace, (TableMetadata)tmd.getValue()));
                        if (monitor.isCanceled()) break;
                    }
                    tables.sort(DBUtils.nameComparator());
                }
                this.setCache(tables);
            }
            return this.getCachedObjects();
        }

        public CasTable getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasTable)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class UserTypeCache
    extends AbstractObjectCache<CasKeyspace, CasUserType> {
        UserTypeCache() {
        }

        @NotNull
        public Collection<CasUserType> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CasUserType> types = new ArrayList<CasUserType>();
                if (CasKeyspace.this.metadata != null) {
                    for (UserDefinedType tmd : CasKeyspace.this.metadata.getUserDefinedTypes().values()) {
                        types.add(new CasUserType(casKeyspace, tmd));
                        if (monitor.isCanceled()) break;
                    }
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasUserType getObject(@NotNull DBRProgressMonitor monitor, @NotNull CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasUserType)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

