/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.dbeaver.db.ycql.model.CasDataSource;
import java.net.InetSocketAddress;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasHost
implements DBSObject {
    private final CasDataSource dataSource;
    private final Node metadata;

    public CasHost(CasDataSource dataSource, Node metadata) {
        this.dataSource = dataSource;
        this.metadata = metadata;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getHostId().toString();
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=2)
    public String getHostName(DBRProgressMonitor monitor) {
        InetSocketAddress inetSocketAddress = this.metadata.getBroadcastAddress().orElse(null);
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getHostName();
    }

    @Property(viewable=true, order=3)
    public String getDatacenter() {
        return this.metadata.getDatacenter();
    }

    @Property(viewable=true, order=4)
    public String getRack() {
        return this.metadata.getRack();
    }

    @Property(viewable=true, order=5)
    public String getCassandraVersion() {
        Version version = this.metadata.getCassandraVersion();
        return version == null ? "?" : version.toString();
    }
}

