/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.edit;

import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasKeyspace;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class CasKeyspaceManager
extends SQLObjectEditor<CasKeyspace, CasDataSource> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, CasKeyspace> getObjectsCache(CasKeyspace object) {
        return object.getDataSource().getKeyspaceCache();
    }

    protected CasKeyspace createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        LinkedHashMap<String, String> rs = new LinkedHashMap<String, String>();
        rs.put("class", "SimpleStrategy");
        rs.put("replication_factor", "3");
        return new CasKeyspace((CasDataSource)((Object)container), "NewKeyspace", rs);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CasKeyspace keyspace = (CasKeyspace)command.getObject();
        String cql = "CREATE KEYSPACE IF NOT EXISTS " + DBUtils.getQuotedIdentifier((DBSObject)keyspace) + " WITH REPLICATION =\n" + keyspace.getReplication();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create keyspace", cql));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        CasKeyspace keyspace = (CasKeyspace)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop keyspace", "DROP KEYSPACE " + DBUtils.getQuotedIdentifier((DBSObject)keyspace)));
    }
}

