/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.dbeaver.db.ycql.data.handlers.CasBaseValueHandler;
import com.dbeaver.db.ycql.exec.CasPreparedStatement;
import com.dbeaver.db.ycql.exec.CasSession;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasNumberValueHandler
extends CasBaseValueHandler
implements DBDValueHandlerConfigurable {
    private static final Log log = Log.getLog(CasNumberValueHandler.class);
    private final DBDFormatSettings formatSettings;
    private DataType typeName;
    private DBDDataFormatter formatter;
    private boolean useScientificNotation;

    public CasNumberValueHandler(DBSTypedObject typedObject, DataType typeName, DBDFormatSettings formatSettings) {
        this.formatSettings = formatSettings;
        this.typeName = typeName;
        this.useScientificNotation = formatSettings.isUseScientificNumericFormat();
    }

    public void refreshValueHandlerConfiguration(DBSTypedObject type) {
        this.formatter = null;
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value == null) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
            if (value instanceof Number) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value), (boolean)this.useScientificNotation);
            }
            return value.toString();
        }
        DBDDataFormatter dataFormatter = this.getFormatterByTypeOrDefault(column);
        return dataFormatter.formatValue(value);
    }

    @NotNull
    public Class<? extends Number> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return this.getNumberType(attribute);
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        DBDDataFormatter dataFormatter = this.getFormatterByTypeOrDefault(type);
        return DBValueFormatting.convertStringToNumber((String)object.toString(), this.getNumberType(type), (DBDDataFormatter)dataFormatter, (boolean)validateValue);
    }

    public Class<? extends Number> getNumberType(DBSTypedObject type) {
        if (this.typeName.equals(DataTypes.SMALLINT)) {
            return Short.class;
        }
        if (this.typeName.equals(DataTypes.TINYINT)) {
            return Byte.class;
        }
        if (this.typeName.equals(DataTypes.INT)) {
            return Integer.class;
        }
        if (this.typeName.equals(DataTypes.BIGINT) || this.typeName.equals(DataTypes.COUNTER)) {
            return Long.class;
        }
        if (this.typeName.equals(DataTypes.VARINT)) {
            return BigInteger.class;
        }
        if (this.typeName.equals(DataTypes.DECIMAL)) {
            return BigDecimal.class;
        }
        if (this.typeName.equals(DataTypes.FLOAT)) {
            return Float.class;
        }
        if (this.typeName.equals(DataTypes.DOUBLE)) {
            return Double.class;
        }
        return Long.class;
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        BoundStatement boundStatement = statement.getBoundStatement();
        if (!(value instanceof Number)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setToNull(paramIndex));
        } else if (this.typeName.equals(DataTypes.SMALLINT)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setShort(paramIndex, ((Number)value).shortValue()));
        } else if (this.typeName.equals(DataTypes.TINYINT)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setByte(paramIndex, ((Number)value).byteValue()));
        } else if (this.typeName.equals(DataTypes.INT)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setInt(paramIndex, ((Number)value).intValue()));
        } else if (this.typeName.equals(DataTypes.BIGINT) || this.typeName.equals(DataTypes.COUNTER)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setLong(paramIndex, ((Number)value).longValue()));
        } else if (this.typeName.equals(DataTypes.VARINT)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setBigInteger(paramIndex, value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(((Number)value).longValue())));
        } else if (this.typeName.equals(DataTypes.DECIMAL)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setBigDecimal(paramIndex, value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Number)value).longValue())));
        } else if (this.typeName.equals(DataTypes.FLOAT)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setFloat(paramIndex, ((Number)value).floatValue()));
        } else if (this.typeName.equals(DataTypes.DOUBLE)) {
            statement.updateBoundStatement((BoundStatement)boundStatement.setDouble(paramIndex, ((Number)value).doubleValue()));
        } else {
            statement.updateBoundStatement((BoundStatement)boundStatement.setLong(paramIndex, ((Number)value).longValue()));
        }
    }

    private DBDDataFormatter getFormatterByTypeOrDefault(@NotNull DBSTypedObject column) {
        if (this.formatter == null) {
            try {
                return this.formatSettings.getDataFormatterProfile().createFormatter("number", column);
            }
            catch (Exception e) {
                log.error((Object)"Can't create formatter for number value handler", (Throwable)e);
                return DefaultDataFormatter.INSTANCE;
            }
        }
        return this.formatter;
    }
}

